/*
 * Decompiled with CFR 0.152.
 */
package com.xsb.interprolog;

import com.declarativa.interprolog.gui.ListenerWindow;
import com.declarativa.interprolog.util.IPAbortedException;
import com.declarativa.interprolog.util.IPException;
import com.declarativa.interprolog.util.IPInterruptedException;
import com.xsb.interprolog.NativeEngine;
import com.xsb.interprolog.NativeEngineWindow;
import javax.swing.SwingUtilities;

public class NativeEngineWindow
extends ListenerWindow {
    public NativeEngineWindow(NativeEngine nativeEngine) {
        this(nativeEngine, true);
        this.setTitle("NativeEngine listener (" + nativeEngine.getPrologVersion() + ")");
    }

    public NativeEngineWindow(NativeEngine nativeEngine, boolean bl) {
        super(nativeEngine, bl);
        this.prologInput.setToolTipText("Prolog goal, sent when you press enter. Drag and drop .P files here to consult them");
        this.prologInput.getAccessibleContext().setAccessibleDescription(this.prologInput.getToolTipText());
        this.prologOutput.setToolTipText("Goals and their first solutions");
        this.prologOutput.getAccessibleContext().setAccessibleDescription(this.prologOutput.getToolTipText());
    }

    public void sendToProlog() {
        String string = this.prologInput.getText().trim();
        if (string.equals(";")) {
            ListenerWindow.beep();
            this.prologOutput.append("Sorry, no multiple solutions available with NativeEngine; use SubprocessEngine if you need them\n");
            return;
        }
        if (string.endsWith(".")) {
            string = string.substring(0, string.length() - 1);
        }
        if (string.length() == 0) {
            ListenerWindow.beep();
            this.prologOutput.append("Goal must be nonempty\n");
            return;
        }
        String string2 = string;
        this.prologOutput.append(String.valueOf(string2) + "\n");
        this.addToHistory();
        1 var3_3 = new 1(string2, this);
        var3_3.setName("NativeEngineWindow command");
        var3_3.start();
    }

    protected String formatGoalResult(Object[] objectArray) {
        if (objectArray == null) {
            return "FAILED\n";
        }
        return String.valueOf(objectArray[0].toString()) + "\n";
    }

    public static void main(String[] stringArray) {
        ListenerWindow.commonMain(stringArray);
        if (ListenerWindow.prologStartCommand.indexOf(32) != -1) {
            System.err.println("Beware that any extra arguments in your command line will NOT");
            System.err.println("be considered by Prolog. For finer control use the NativeEngine class directly");
        }
        new NativeEngineWindow(new NativeEngine(ListenerWindow.prologStartCommand, ListenerWindow.debug, ListenerWindow.loadFromJar));
    }

    private static final class 1
    extends Thread {
        private final /* synthetic */ String val$finalGoal;
        private final /* synthetic */ NativeEngineWindow this$0;
        String result;

        public void run() {
            try {
                Object[] objectArray = this.this$0.engine.deterministicGoal(this.val$finalGoal, null);
                this.result = this.this$0.formatGoalResult(objectArray);
            }
            catch (IPInterruptedException iPInterruptedException) {
                this.result = "Goal was interrupted!";
            }
            catch (IPAbortedException iPAbortedException) {
                this.result = "Goal was aborted!";
            }
            catch (IPException iPException) {
                this.result = "Goal was aborted! \n" + iPException.getMessage();
            }
            SwingUtilities.invokeLater(new 2(this.this$0, this));
        }

        /* synthetic */ 1(String string, NativeEngineWindow nativeEngineWindow) {
            this.val$finalGoal = string;
            this.this$0 = nativeEngineWindow;
        }
    }
}

