/*
 * Decompiled with CFR 0.152.
 */
package moulserver;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import moulserver.AuthServer;
import moulserver.Results;
import prpobjects.Guid;
import shared.DateTimeUtils;
import shared.m;
import shared.nested;

public class Database {
    public static final String fields = "fields";
    public static final String idx = "idx";
    public static final String createTime = "createTime";
    public static final String modifyTime = "modifyTime";
    public static final String createAgeName = "createAgeName";
    public static final String createAgeUuid = "createAgeUuid";
    public static final String creatorUuid = "creatorUuid";
    public static final String creatorIdx = "creatorIdx";
    public static final String type = "type";
    public static final String int_1 = "int_1";
    public static final String int_2 = "int_2";
    public static final String int_3 = "int_3";
    public static final String int_4 = "int_4";
    public static final String uint_1 = "uint_1";
    public static final String uint_2 = "uint_2";
    public static final String uint_3 = "uint_3";
    public static final String uint_4 = "uint_4";
    public static final String uuid_1 = "uuid_1";
    public static final String uuid_2 = "uuid_2";
    public static final String uuid_3 = "uuid_3";
    public static final String uuid_4 = "uuid_4";
    public static final String str_1 = "str_1";
    public static final String str_2 = "str_2";
    public static final String str_3 = "str_3";
    public static final String str_4 = "str_4";
    public static final String str_5 = "str_5";
    public static final String str_6 = "str_6";
    public static final String lstr_1 = "lstr_1";
    public static final String lstr_2 = "lstr_2";
    public static final String text_1 = "text_1";
    public static final String text_2 = "text_2";
    public static final String blob_1 = "blob_1";
    public static final String blob_2 = "blob_2";
    private Connection conn;

    public void initialise(String dbfile) {
        try {
            Class.forName("org.h2.Driver");
            String username = "admin";
            String password = "";
            this.conn = DriverManager.getConnection("jdbc:h2:" + dbfile, username, password);
            this.setup();
        }
        catch (Exception e2) {
            throw new nested(e2);
        }
    }

    public void sqlupdate(String sql, Object ... parameters) {
        try {
            PreparedStatement stmt = this._sql(sql, parameters);
            stmt.execute();
        }
        catch (Exception e2) {
            throw new nested(e2);
        }
    }

    public Results sqlquery(String sql, Object ... parameters) {
        try {
            PreparedStatement stmt = this._sql(sql, parameters);
            ResultSet r = stmt.executeQuery();
            return new Results(r);
        }
        catch (Exception e2) {
            throw new nested(e2);
        }
    }

    public PreparedStatement _sql(String sql, Object ... parameters) throws SQLException {
        PreparedStatement stmt = this.conn.prepareStatement(sql);
        for (int i = 1; i <= parameters.length; ++i) {
            Class<?> klass;
            Object obj = parameters[i - 1];
            if (obj == null) {
                boolean dummy = false;
            }
            if ((klass = obj.getClass()).isPrimitive()) {
                if (klass == Integer.TYPE) {
                    stmt.setInt(i, (Integer)obj);
                    continue;
                }
                m.throwUncaughtException("unhandled");
                continue;
            }
            if (klass.isArray()) {
                Class<?> arrayklass = klass.getComponentType();
                if (arrayklass == Byte.TYPE) {
                    stmt.setBytes(i, (byte[])obj);
                    continue;
                }
                m.throwUncaughtException("unhandled");
                continue;
            }
            if (klass == Integer.class) {
                stmt.setInt(i, (Integer)obj);
                continue;
            }
            if (klass == String.class) {
                stmt.setString(i, (String)obj);
                continue;
            }
            if (klass == Byte.class) {
                stmt.setByte(i, (Byte)obj);
                continue;
            }
            if (klass == Long.class) {
                stmt.setLong(i, (Long)obj);
                continue;
            }
            m.throwUncaughtException("unhandled");
        }
        return stmt;
    }

    public void setup() {
        try {
            this.conn.prepareStatement("CREATE SEQUENCE IF NOT EXISTS idx_seq;").execute();
            this.conn.prepareStatement("CREATE TABLE IF NOT EXISTS accounts (   accountname VARCHAR(255) NOT NULL,   passwordhash BINARY(20) NOT NULL,   guid BINARY(16) NOT NULL,  flags INTEGER NOT NULL,  billingtype INTEGER NOT NULL,  talc_extra INTEGER,  PRIMARY KEY(accountname) )").execute();
            this.conn.prepareStatement("CREATE TABLE IF NOT EXISTS vault (fields BIGINT NOT NULL,idx INTEGER NOT NULL,createTime INTEGER NOT NULL,modifyTime INTEGER NOT NULL,createAgeName VARCHAR(255),createAgeUuid BINARY(16),creatorUuid BINARY(16) NOT NULL,creatorIdx INTEGER NOT NULL,type INTEGER NOT NULL,int_1 INTEGER,int_2 INTEGER,int_3 INTEGER,int_4 INTEGER,uint_1 INTEGER,uint_2 INTEGER,uint_3 INTEGER,uint_4 INTEGER,uuid_1 BINARY(16),uuid_2 BINARY(16),uuid_3 BINARY(16),uuid_4 BINARY(16),str_1 VARCHAR(255),str_2 VARCHAR(255),str_3 VARCHAR(255),str_4 VARCHAR(255),str_5 VARCHAR(255),str_6 VARCHAR(255),lstr_1 VARCHAR(255),lstr_2 VARCHAR(255),text_1 VARCHAR(65535),text_2 VARCHAR(65535),blob_1 BINARY(10000000),blob_2 BINARY(10000000),  permissions INTEGER,  owner INTEGER,  grp INTEGER,  age_time TIMESTAMP,  talc_extra INTEGER,  PRIMARY KEY(idx))").execute();
            this.conn.prepareStatement("CREATE TABLE IF NOT EXISTS ref_vault (   parent_idx INTEGER NOT NULL,  child_idx INTEGER NOT NULL,  owner_idx INTEGER NOT NULL,  seen TINYINT NOT NULL,  timestamp TIMESTAMP,  talc_extra INTEGER,  PRIMARY KEY(parent_idx,child_idx))").execute();
        }
        catch (Exception e2) {
            throw new nested(e2);
        }
    }

    public void reset() {
        try {
            this.conn.prepareStatement("DROP ALL OBJECTS").execute();
        }
        catch (Exception e2) {
            throw new nested(e2);
        }
        this.setup();
    }

    public String findString(String sql, Object ... params) {
        Results r = this.sqlquery(sql, params);
        if (!r.first()) {
            m.throwUncaughtException("SQL query found not results!");
        }
        String ret = r.getString(1);
        return ret;
    }

    public int getNextIdx() {
        Results r = this.sqlquery("SELECT NEXTVAL('idx_seq');", new Object[0]);
        r.first();
        long num = r.getLong(1);
        int num2 = (int)num;
        return num2;
    }

    public int getCurrentIdx() {
        Results r = this.sqlquery("SELECT CURRVAL('idx_seq');", new Object[0]);
        r.first();
        long num = r.getLong(1);
        int num2 = (int)num;
        return num2;
    }

    public void CreatePlayer(String playerName, String avatarModel) {
    }

    public void AddUser(String username, String password) {
        byte[] hash = AuthServer.AcctLoginRequest.getStoredHash(username, password);
        byte[] guid = Guid.newRandomPlayer();
        int flags = 8;
        int billingtype = 1;
        this.sqlupdate("INSERT INTO accounts (accountname,passwordhash,guid,flags,billingtype) VALUES (?,?,?,?,?)", username, hash, guid, flags, billingtype);
    }

    public accountinfo GetUser(String username) {
        Results results = this.sqlquery("SELECT * FROM accounts WHERE accountname=?", username);
        boolean hasrows = results.first();
        if (!hasrows) {
            return null;
        }
        accountinfo r = new accountinfo(results);
        return r;
    }

    public static int getCurrentTime() {
        return DateTimeUtils.getCurrentTimeInSeconds();
    }

    public static class accountinfo {
        String accountname;
        byte[] passwordhash;
        byte[] guid;
        int flags;
        int billingtype;

        public accountinfo(Results r) {
            try {
                this.accountname = r.getString("accountname");
                this.passwordhash = r.getBytes("passwordhash");
                this.guid = r.getBytes("guid");
                this.flags = r.getInt("flags");
                this.billingtype = r.getInt("billingtype");
            }
            catch (Exception e2) {
                throw new nested(e2);
            }
        }
    }
}

