/*
 * Decompiled with CFR 0.152.
 */
package prpobjects;

import prpobjects.PrpObject;
import prpobjects.PrpTaggedObject;
import prpobjects.Transmatrix;
import prpobjects.Typeid;
import prpobjects.uruobj;
import shared.Flt;
import shared.Quat;
import shared.Vertex;
import shared.b;
import shared.e;
import shared.m;
import shared.readexception;
import shared.uncaughtexception;
import uru.Bytedeque;
import uru.context;
import uru.writesOwnTypeid;

public class PrpController
extends uruobj {
    public static Quat decompressQuaternion(int data1, int data2) {
        long d1 = b.Int32ToInt64(data1);
        long d2 = b.Int32ToInt64(data2);
        long data = d1 << 0 | d2 << 32;
        int bits1 = (int)(data >>> 0 & 0x3FFL);
        int bits2 = (int)(data >>> 10 & 0xFFFFFL);
        int bits5 = (int)(data >>> 30 & 3L);
        int bits4 = (int)(data >>> 32 & 0x1FFFFFL);
        int bits3 = (int)(data >>> 53 & 0x8FFL);
        int bits13 = bits3 | bits1 << 11;
        double decoded1 = ((double)bits2 / 1048575.0 - 0.5) * Math.sqrt(2.0);
        double decoded2 = ((double)bits13 / 2097151.0 - 0.5) * Math.sqrt(2.0);
        double decoded3 = ((double)bits4 / 2097151.0 - 0.5) * Math.sqrt(2.0);
        double last = Math.sqrt(1.0 - (decoded2 * decoded2 + decoded1 * decoded1 + decoded3 * decoded3));
        float w = 0.0f;
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        switch (bits5) {
            case 0: {
                w = (float)last;
                x = (float)decoded1;
                y = (float)decoded2;
                z = (float)decoded3;
                break;
            }
            case 1: {
                w = (float)decoded1;
                x = (float)last;
                y = (float)decoded2;
                z = (float)decoded3;
                break;
            }
            case 2: {
                w = (float)decoded1;
                x = (float)decoded2;
                y = (float)last;
                z = (float)decoded3;
                break;
            }
            case 3: {
                w = (float)decoded1;
                x = (float)decoded2;
                y = (float)decoded3;
                z = (float)last;
            }
        }
        Quat result = new Quat(new Flt(w), new Flt(x), new Flt(y), new Flt(z));
        return result;
    }

    public static class plTMController
    extends uruobj {
        public int type1;
        public int type2;
        public int type3;
        public PrpObject poscontroller;
        public PrpObject rotcontroller;
        public PrpObject scalecontroller;

        public plTMController(context c) throws readexception {
            e.ensure(c.readversion == 3);
            this.type1 = c.readInt();
            switch (this.type1) {
                case 0: {
                    break;
                }
                case 1: {
                    this.poscontroller = new PrpObject(c, Typeid.plSimplePosController);
                    break;
                }
                case 2: {
                    this.poscontroller = new PrpObject(c, Typeid.plCompoundPosController);
                    break;
                }
                default: {
                    throw new readexception("pltmcontroller: error");
                }
            }
            this.type2 = c.readInt();
            switch (this.type2) {
                case 0: {
                    break;
                }
                case 1: {
                    this.rotcontroller = new PrpObject(c, Typeid.plSimpleRotController);
                    break;
                }
                case 3: {
                    this.rotcontroller = new PrpObject(c, Typeid.plCompoundRotController);
                    break;
                }
                default: {
                    throw new readexception("pltmcontroller: error");
                }
            }
            this.type3 = c.readInt();
            switch (this.type3) {
                case 0: {
                    break;
                }
                case 1: {
                    this.scalecontroller = new PrpObject(c, Typeid.plSimpleScaleController);
                    break;
                }
                default: {
                    throw new readexception("pltmcontroller: error");
                }
            }
        }

        public void compile(Bytedeque c) {
            c.writeInt(this.type1);
            switch (this.type1) {
                case 0: {
                    break;
                }
                case 1: {
                    this.poscontroller.compile(c);
                    break;
                }
                case 2: {
                    this.poscontroller.compile(c);
                    break;
                }
                default: {
                    throw new uncaughtexception("pltmcontroller: error");
                }
            }
            c.writeInt(this.type2);
            switch (this.type2) {
                case 0: {
                    break;
                }
                case 1: {
                    this.rotcontroller.compile(c);
                    break;
                }
                case 3: {
                    this.rotcontroller.compile(c);
                    break;
                }
                default: {
                    throw new uncaughtexception("pltmcontroller: error");
                }
            }
            c.writeInt(this.type3);
            switch (this.type3) {
                case 0: {
                    break;
                }
                case 1: {
                    this.scalecontroller.compile(c);
                    break;
                }
                default: {
                    throw new uncaughtexception("pltmcontroller: error");
                }
            }
        }
    }

    public static class uk
    extends uruobj {
        int xu0;
        public Vertex u1;
        public Quat u2;
        public Quat u3;
        public Vertex u4;
        public Flt u5;

        public uk(context c) throws readexception {
            if (c.readversion == 3 || c.readversion == 4 || c.readversion == 7) {
                this.xu0 = c.readInt();
            }
            this.u1 = new Vertex(c);
            this.u2 = new Quat(c);
            this.u3 = new Quat(c);
            this.u4 = new Vertex(c);
            this.u5 = new Flt(c);
        }

        public void compile(Bytedeque c) {
            c.writeInt(0);
            this.u1.compile(c);
            this.u2.compile(c);
            this.u3.compile(c);
            this.u4.compile(c);
            this.u5.compile(c);
        }
    }

    public static class plCompoundController
    extends uruobj
    implements writesOwnTypeid {
        PrpTaggedObject u1;
        PrpTaggedObject u2;
        PrpTaggedObject u3;

        public plCompoundController(context c) throws readexception {
            e.ensure(c.readversion == 6 || c.readversion == 4 || c.readversion == 7);
            this.u1 = new PrpTaggedObject(c);
            this.u2 = new PrpTaggedObject(c);
            this.u3 = new PrpTaggedObject(c);
        }

        public void compileTypeid(Bytedeque c) {
            int mytype = this.gettype();
            if (mytype == 4) {
                Typeid.plTMController.compile(c);
            } else if (mytype == 6) {
                Typeid.plCompoundPosController.compile(c);
            } else {
                m.err("plcompoundcontroller: compiletypeid: problem.");
            }
        }

        public void compile(Bytedeque c) {
            this.compileSpecial(c);
        }

        private static int gettype(PrpTaggedObject obj) {
            int type = -1;
            if (obj.type == Typeid.nil) {
                type = 0;
            } else if (obj.type == Typeid.plLeafController) {
                plLeafController leaf = (plLeafController)obj.prpobject.object;
                switch (leaf.controllertype) {
                    case 1: 
                    case 2: {
                        type = 1;
                        break;
                    }
                    case 3: 
                    case 4: {
                        if (leaf.controllertype == 3) {
                            m.warn("Experimental prpcontroller case...");
                        }
                        type = 5;
                        break;
                    }
                    case 7: 
                    case 9: {
                        type = 2;
                        break;
                    }
                    case 5: 
                    case 6: {
                        type = 3;
                        break;
                    }
                    default: {
                        m.err("plcompoundcontroller:gettype:problem");
                        break;
                    }
                }
            } else if (obj.type == Typeid.plCompoundController) {
                plCompoundController leaf = (plCompoundController)obj.prpobject.object;
                type = leaf.gettype();
            } else {
                m.err("plCompoundController:gettype:problem.");
            }
            return type;
        }

        private int gettype() {
            int type1 = plCompoundController.gettype(this.u1);
            int type2 = plCompoundController.gettype(this.u2);
            int type3 = plCompoundController.gettype(this.u3);
            if (!(type1 != 0 && type1 != 1 && type1 != 6 || type2 != 0 && type2 != 2 && type2 != 6 || type3 != 0 && type3 != 3)) {
                return 4;
            }
            if (!(type1 != 0 && type1 != 5 || type2 != 0 && type2 != 5 || type3 != 0 && type3 != 5)) {
                return 6;
            }
            m.warn("plcompoundcontroller: no type matches.");
            return -1;
        }

        public void compileSpecial(Bytedeque c) {
            int mytype;
            String breakname = "RTSpiralLight01_back_anim_1";
            if (c.curRootObject.objectname.toString().toLowerCase().equals(breakname.toLowerCase())) {
                boolean dummy = false;
            }
            if ((mytype = this.gettype()) == 4) {
                if (this.u1.type == Typeid.nil) {
                    c.writeInt(0);
                } else if (this.u1.type == Typeid.plLeafController) {
                    c.writeInt(1);
                    this.u1.prpobject.object.compile(c);
                } else if (this.u1.type == Typeid.plCompoundController) {
                    c.writeInt(2);
                    this.u1.prpobject.object.compile(c);
                } else {
                    m.err("plCompoundController: unhandled.");
                }
                if (this.u2.type == Typeid.nil) {
                    c.writeInt(0);
                } else if (this.u2.type == Typeid.plLeafController) {
                    c.writeInt(1);
                    this.u2.prpobject.object.compile(c);
                } else if (this.u2.type == Typeid.plCompoundController) {
                    c.writeInt(3);
                    this.u2.prpobject.object.compile(c);
                } else {
                    m.err("plCompoundController: unhandled.");
                }
                if (this.u3.type == Typeid.nil) {
                    c.writeInt(0);
                } else if (this.u3.type == Typeid.plLeafController) {
                    c.writeInt(1);
                    this.u3.prpobject.object.compile(c);
                } else {
                    m.err("plCompoundController: unhandled.");
                }
            } else if (mytype == 6) {
                plLeafController lc;
                if (this.u1.type == Typeid.nil) {
                    c.writeInt(0);
                } else if (this.u1.type == Typeid.plLeafController) {
                    lc = (plLeafController)this.u1.prpobject.object;
                    if (lc.controllertype == 4 || lc.controllertype == 3) {
                        c.writeInt(1);
                        this.u1.prpobject.object.compile(c);
                    } else {
                        m.err("plcompoundcontroller: unhandled");
                    }
                } else {
                    m.err("plcompoundcontroller: unhandled.");
                }
                if (this.u2.type == Typeid.nil) {
                    c.writeInt(0);
                } else if (this.u2.type == Typeid.plLeafController) {
                    lc = (plLeafController)this.u2.prpobject.object;
                    if (lc.controllertype == 4 || lc.controllertype == 3) {
                        c.writeInt(1);
                        this.u2.prpobject.object.compile(c);
                    } else {
                        m.err("plcompoundcontroller: unhandled");
                    }
                } else {
                    m.err("plcompoundcontroller: unhandled.");
                }
                if (this.u3.type == Typeid.nil) {
                    c.writeInt(0);
                } else if (this.u3.type == Typeid.plLeafController) {
                    lc = (plLeafController)this.u3.prpobject.object;
                    if (lc.controllertype == 4 || lc.controllertype == 3) {
                        c.writeInt(1);
                        this.u3.prpobject.object.compile(c);
                    } else {
                        m.err("plcompoundcontroller: unhandled");
                    }
                } else {
                    m.err("plcompoundcontroller: unhandled.");
                }
            } else {
                m.err("plCompoundController: unhandled.");
            }
        }
    }

    public static class moul12
    extends uruobj {
        short framenum;
        Transmatrix data;

        public moul12(context c) throws readexception {
            if (c.readversion == 6) {
                this.framenum = c.readShort();
            } else if (c.readversion == 4 || c.readversion == 7) {
                Flt flt = new Flt(c);
                this.framenum = (short)Math.round(flt.toJavaFloat() * 30.0f);
            }
            this.data = new Transmatrix(c);
        }
    }

    public static class moul11
    extends uruobj {
        short framenum;
        Flt[] matrixdata;

        public moul11(context c) throws readexception {
            if (c.readversion == 6) {
                this.framenum = c.readShort();
            } else if (c.readversion == 4 || c.readversion == 7) {
                Flt flt = new Flt(c);
                this.framenum = (short)Math.round(flt.toJavaFloat() * 30.0f);
            }
            this.matrixdata = (Flt[])c.readArray(Flt.class, 9);
        }
    }

    public static class moul10
    extends uruobj {
        short framenum;
        uk data;

        public moul10(context c) throws readexception {
            if (c.readversion == 6) {
                this.framenum = c.readShort();
            } else if (c.readversion == 4 || c.readversion == 7) {
                Flt flt = new Flt(c);
                this.framenum = (short)Math.round(flt.toJavaFloat() * 30.0f);
            }
            this.data = new uk(c);
        }
    }

    public static class moul9
    extends uruobj {
        short framenum;
        int data1;
        int data2;

        public moul9(context c) throws readexception {
            if (c.readversion == 6) {
                this.framenum = c.readShort();
            } else if (c.readversion == 4 || c.readversion == 7) {
                Flt flt = new Flt(c);
                this.framenum = (short)Math.round(flt.toJavaFloat() * 30.0f);
            }
            this.data1 = c.readInt();
            this.data2 = c.readInt();
            PrpController.decompressQuaternion(this.data1, this.data2);
        }
    }

    public static class moul8
    extends uruobj {
        short framenum;
        int data;

        public moul8(context c) throws readexception {
            if (c.readversion == 6) {
                this.framenum = c.readShort();
            } else if (c.readversion == 4 || c.readversion == 7) {
                Flt flt = new Flt(c);
                this.framenum = (short)Math.round(flt.toJavaFloat() * 30.0f);
            }
            this.data = c.readInt();
        }
    }

    public static class moul7
    extends uruobj {
        short framenum;
        Quat data;

        public moul7(context c) throws readexception {
            if (c.readversion == 6) {
                this.framenum = c.readShort();
            } else if (c.readversion == 4 || c.readversion == 7) {
                Flt flt = new Flt(c);
                this.framenum = (short)Math.round(flt.toJavaFloat() * 30.0f);
            }
            this.data = new Quat(c);
        }
    }

    public static class moul6
    extends uruobj {
        short framenum;
        Vertex data1;
        Vertex data2;
        Vertex data3;
        Quat data4;

        public moul6(context c) throws readexception {
            if (c.readversion == 6) {
                this.framenum = c.readShort();
            } else if (c.readversion == 4 || c.readversion == 7) {
                Flt flt = new Flt(c);
                this.framenum = (short)Math.round(flt.toJavaFloat() * 30.0f);
            }
            this.data1 = new Vertex(c);
            this.data2 = new Vertex(c);
            this.data3 = new Vertex(c);
            this.data4 = new Quat(c);
        }
    }

    public static class moul5
    extends uruobj {
        short framenum;
        Vertex data1;
        Quat data2;

        public moul5(context c) throws readexception {
            if (c.readversion == 6) {
                this.framenum = c.readShort();
            } else if (c.readversion == 4 || c.readversion == 7) {
                Flt flt = new Flt(c);
                this.framenum = (short)Math.round(flt.toJavaFloat() * 30.0f);
            }
            this.data1 = new Vertex(c);
            this.data2 = new Quat(c);
        }
    }

    public static class moul4
    extends uruobj {
        short framenum;
        Flt data1;
        Flt data2;
        Flt data3;

        public moul4(context c) throws readexception {
            if (c.readversion == 6) {
                this.framenum = c.readShort();
            } else if (c.readversion == 4 || c.readversion == 7) {
                Flt flt = new Flt(c);
                this.framenum = (short)Math.round(flt.toJavaFloat() * 30.0f);
            }
            this.data1 = new Flt(c);
            this.data2 = new Flt(c);
            this.data3 = new Flt(c);
        }
    }

    public static class moul3
    extends uruobj {
        short framenum;
        Flt data;

        public moul3(context c) throws readexception {
            if (c.readversion == 6) {
                this.framenum = c.readShort();
            } else if (c.readversion == 4 || c.readversion == 7) {
                Flt flt = new Flt(c);
                this.framenum = (short)Math.round(flt.toJavaFloat() * 30.0f);
            }
            this.data = new Flt(c);
        }
    }

    public static class moul2
    extends uruobj {
        short framenum;
        Vertex data1;
        Vertex data2;
        Vertex data3;

        public moul2(context c) throws readexception {
            if (c.readversion == 6) {
                this.framenum = c.readShort();
            } else if (c.readversion == 4 || c.readversion == 7) {
                Flt flt = new Flt(c);
                this.framenum = (short)Math.round(flt.toJavaFloat() * 30.0f);
            }
            this.data1 = new Vertex(c);
            this.data2 = new Vertex(c);
            this.data3 = new Vertex(c);
        }
    }

    public static class moul1
    extends uruobj {
        short framenum;
        Vertex data;

        public moul1(context c) throws readexception {
            if (c.readversion == 6) {
                this.framenum = c.readShort();
            } else if (c.readversion == 4 || c.readversion == 7) {
                Flt flt = new Flt(c);
                this.framenum = (short)Math.round(flt.toJavaFloat() * 30.0f);
            }
            this.data = new Vertex(c);
        }
    }

    public static class plLeafController
    extends uruobj
    implements writesOwnTypeid {
        int u1;
        int count;
        plEaseController[] easecontrollers;
        int garbage;
        byte controllertype;
        int count2;
        moul1[] xtype1;
        moul2[] xtype2;
        moul3[] xtype3;
        moul4[] xtype4;
        moul5[] xtype5;
        moul6[] xtype6;
        moul7[] xtype7;
        moul8[] xtype8;
        moul9[] xtype9;
        moul10[] xtype10;
        moul11[] xtype11;
        moul12[] xtype12;
        private int readversion;

        public plLeafController(context c) throws readexception {
            this.readversion = c.readversion;
            if (c.readversion == 3) {
                this.u1 = c.readInt();
                this.count = c.readInt();
                this.easecontrollers = (plEaseController[])c.readArray(plEaseController.class, this.count);
                this.garbage = c.readInt();
            } else if (c.readversion == 6) {
                this.controllertype = c.readByte();
                this.count2 = c.readInt();
                switch (this.controllertype) {
                    case 1: {
                        this.xtype1 = (moul1[])c.readArray(moul1.class, this.count2);
                        break;
                    }
                    case 2: {
                        this.xtype2 = (moul2[])c.readArray(moul2.class, this.count2);
                        break;
                    }
                    case 3: {
                        this.xtype3 = (moul3[])c.readArray(moul3.class, this.count2);
                        break;
                    }
                    case 4: {
                        this.xtype4 = (moul4[])c.readArray(moul4.class, this.count2);
                        break;
                    }
                    case 5: {
                        this.xtype5 = (moul5[])c.readArray(moul5.class, this.count2);
                        break;
                    }
                    case 6: {
                        this.xtype6 = (moul6[])c.readArray(moul6.class, this.count2);
                        break;
                    }
                    case 7: {
                        this.xtype7 = (moul7[])c.readArray(moul7.class, this.count2);
                        break;
                    }
                    case 8: {
                        this.xtype8 = (moul8[])c.readArray(moul8.class, this.count2);
                        break;
                    }
                    case 9: {
                        this.xtype9 = (moul9[])c.readArray(moul9.class, this.count2);
                        break;
                    }
                    case 10: {
                        this.xtype10 = (moul10[])c.readArray(moul10.class, this.count2);
                        break;
                    }
                    case 11: {
                        this.xtype11 = (moul11[])c.readArray(moul11.class, this.count2);
                        break;
                    }
                    case 12: {
                        this.xtype12 = (moul12[])c.readArray(moul12.class, this.count2);
                        break;
                    }
                    default: {
                        m.err("plleafcontroller: unknown type.");
                        break;
                    }
                }
            } else if (c.readversion == 4 || c.readversion == 7) {
                byte controllertype2 = c.readByte();
                this.count2 = c.readInt();
                switch (controllertype2) {
                    case 1: {
                        this.controllertype = 1;
                        this.xtype1 = (moul1[])c.readArray(moul1.class, this.count2);
                        break;
                    }
                    case 2: {
                        this.controllertype = (byte)2;
                        this.xtype2 = (moul2[])c.readArray(moul2.class, this.count2);
                        break;
                    }
                    case 3: {
                        this.controllertype = (byte)3;
                        this.xtype3 = (moul3[])c.readArray(moul3.class, this.count2);
                        break;
                    }
                    case 4: {
                        this.controllertype = (byte)4;
                        this.xtype4 = (moul4[])c.readArray(moul4.class, this.count2);
                        break;
                    }
                    case 5: {
                        this.controllertype = (byte)5;
                        this.xtype5 = (moul5[])c.readArray(moul5.class, this.count2);
                        break;
                    }
                    case 6: {
                        this.controllertype = (byte)6;
                        this.xtype6 = (moul6[])c.readArray(moul6.class, this.count2);
                        break;
                    }
                    case 7: {
                        this.controllertype = (byte)7;
                        this.xtype7 = (moul7[])c.readArray(moul7.class, this.count2);
                        break;
                    }
                    case 8: {
                        this.controllertype = (byte)8;
                        this.xtype8 = (moul8[])c.readArray(moul8.class, this.count2);
                        break;
                    }
                    case 9: {
                        this.controllertype = (byte)10;
                        this.xtype10 = (moul10[])c.readArray(moul10.class, this.count2);
                        break;
                    }
                    case 10: {
                        this.controllertype = (byte)11;
                        this.xtype11 = (moul11[])c.readArray(moul11.class, this.count2);
                        break;
                    }
                    case 11: {
                        this.controllertype = (byte)12;
                        this.xtype12 = (moul12[])c.readArray(moul12.class, this.count2);
                        break;
                    }
                    default: {
                        m.err("plleafcontroller: unknown type.");
                    }
                }
            }
        }

        public void compile(Bytedeque c) {
            if (this.readversion == 4 || this.readversion == 6 || this.readversion == 7) {
                this.compileSpecial(c);
            } else if (this.readversion == 3) {
                c.writeInt(this.u1);
                c.writeInt(this.count);
                c.writeArray2(this.easecontrollers);
                c.writeInt(this.garbage);
            } else {
                throw new uncaughtexception("PlLeafController: unexpected readversion in compile.");
            }
        }

        public void compileTypeid(Bytedeque c) {
            switch (this.controllertype) {
                case 1: {
                    Typeid.plSimplePosController.compile(c);
                    break;
                }
                case 2: {
                    Typeid.plSimplePosController.compile(c);
                    break;
                }
                case 3: {
                    Typeid.plScalarController.compile(c);
                    break;
                }
                case 4: {
                    Typeid.plScalarController.compile(c);
                    break;
                }
                case 5: {
                    Typeid.plSimpleScaleController.compile(c);
                    break;
                }
                case 6: {
                    Typeid.plSimpleScaleController.compile(c);
                    break;
                }
                case 9: {
                    Typeid.plSimpleRotController.compile(c);
                    break;
                }
                case 12: {
                    Typeid.plMatrix44Controller.compile(c);
                    break;
                }
                default: {
                    m.err("plLeafController: error");
                }
            }
        }

        public void compileSpecial(Bytedeque c) {
            plLeafController leaf = this;
            int count = leaf.count2;
            switch (leaf.controllertype) {
                case 1: {
                    c.writeInt(1);
                    c.writeInt(0);
                    c.writeInt(0);
                    c.writeInt(0);
                    c.writeInt(1);
                    c.writeInt(count);
                    for (int i = 0; i < count; ++i) {
                        c.writeInt(1);
                        int framenum = b.Int16ToInt32(leaf.xtype1[i].framenum);
                        c.writeInt(framenum);
                        float time = (float)framenum / 30.0f;
                        new Flt(time).compile(c);
                        leaf.xtype1[i].data.compile(c);
                    }
                    break;
                }
                case 2: {
                    c.writeInt(1);
                    c.writeInt(0);
                    c.writeInt(0);
                    c.writeInt(0);
                    c.writeInt(1);
                    c.writeInt(count);
                    for (int i = 0; i < count; ++i) {
                        c.writeInt(2);
                        int framenum = b.Int16ToInt32(leaf.xtype2[i].framenum);
                        c.writeInt(framenum);
                        float time = (float)framenum / 30.0f;
                        new Flt(time).compile(c);
                        leaf.xtype2[i].data1.compile(c);
                        leaf.xtype2[i].data2.compile(c);
                        leaf.xtype2[i].data3.compile(c);
                    }
                    break;
                }
                case 3: {
                    c.writeInt(0);
                    c.writeInt(0);
                    c.writeInt(0);
                    c.writeInt(1);
                    c.writeInt(count);
                    for (int i = 0; i < count; ++i) {
                        c.writeInt(1);
                        int framenum = b.Int16ToInt32(leaf.xtype3[i].framenum);
                        c.writeInt(framenum);
                        float time = (float)framenum / 30.0f;
                        new Flt(time).compile(c);
                        leaf.xtype3[i].data.compile(c);
                    }
                    break;
                }
                case 4: {
                    c.writeInt(0);
                    c.writeInt(0);
                    c.writeInt(0);
                    c.writeInt(1);
                    c.writeInt(count);
                    for (int i = 0; i < count; ++i) {
                        c.writeInt(2);
                        int framenum = b.Int16ToInt32(leaf.xtype4[i].framenum);
                        c.writeInt(framenum);
                        float time = (float)framenum / 30.0f;
                        new Flt(time).compile(c);
                        leaf.xtype4[i].data1.compile(c);
                        leaf.xtype4[i].data2.compile(c);
                        leaf.xtype4[i].data3.compile(c);
                    }
                    break;
                }
                case 5: {
                    c.writeInt(1);
                    c.writeInt(0);
                    c.writeInt(0);
                    c.writeInt(0);
                    c.writeInt(count);
                    for (int i = 0; i < count; ++i) {
                        c.writeInt(1);
                        int framenum = b.Int16ToInt32(leaf.xtype5[i].framenum);
                        c.writeInt(framenum);
                        float time = (float)framenum / 30.0f;
                        new Flt(time).compile(c);
                        leaf.xtype5[i].data1.compile(c);
                        leaf.xtype5[i].data2.compile(c);
                    }
                    break;
                }
                case 6: {
                    c.writeInt(1);
                    c.writeInt(0);
                    c.writeInt(0);
                    c.writeInt(0);
                    c.writeInt(count);
                    for (int i = 0; i < count; ++i) {
                        c.writeInt(2);
                        int framenum = b.Int16ToInt32(leaf.xtype6[i].framenum);
                        c.writeInt(framenum);
                        float time = (float)framenum / 30.0f;
                        new Flt(time).compile(c);
                        leaf.xtype6[i].data1.compile(c);
                        leaf.xtype6[i].data2.compile(c);
                        leaf.xtype6[i].data3.compile(c);
                        leaf.xtype6[i].data4.compile(c);
                    }
                    break;
                }
                case 7: {
                    c.writeInt(1);
                    c.writeInt(0);
                    c.writeInt(0);
                    c.writeInt(0);
                    c.writeInt(count);
                    for (int i = 0; i < count; ++i) {
                        c.writeInt(1);
                        int framenum = b.Int16ToInt32(leaf.xtype7[i].framenum);
                        c.writeInt(framenum);
                        float time = (float)framenum / 30.0f;
                        new Flt(time).compile(c);
                        leaf.xtype7[i].data.compile(c);
                    }
                    break;
                }
                case 9: {
                    c.writeInt(1);
                    c.writeInt(0);
                    c.writeInt(0);
                    c.writeInt(0);
                    c.writeInt(count);
                    for (int i = 0; i < count; ++i) {
                        c.writeInt(1);
                        int framenum = b.Int16ToInt32(leaf.xtype9[i].framenum);
                        c.writeInt(framenum);
                        float time = (float)framenum / 30.0f;
                        new Flt(time).compile(c);
                        Quat quat = PrpController.decompressQuaternion(leaf.xtype9[i].data1, leaf.xtype9[i].data2);
                        quat.compile(c);
                    }
                    break;
                }
                case 12: {
                    c.writeInt(0);
                    c.writeInt(0);
                    c.writeInt(0);
                    c.writeInt(count);
                    for (int i = 0; i < count; ++i) {
                        c.writeInt(2);
                        int framenum = b.Int16ToInt32(leaf.xtype12[i].framenum);
                        c.writeInt(framenum);
                        float time = (float)framenum / 30.0f;
                        new Flt(time).compile(c);
                        leaf.xtype12[i].data.compile(c);
                    }
                    break;
                }
                default: {
                    m.err("prpcontroller: specialcompile: unhandled type.", Integer.toString(leaf.controllertype));
                }
            }
        }
    }

    public static class plEaseController
    extends uruobj {
        plLeafController parent;
        int haskeylist;
        hsEaseKeyList xeasekeylist;

        public plEaseController(context c) throws readexception {
            e.ensure(c.readversion == 3);
            this.parent = new plLeafController(c);
            this.haskeylist = c.readInt();
            if (this.haskeylist != 0) {
                this.xeasekeylist = new hsEaseKeyList(c);
            }
        }
    }

    public static class hsEaseKeyList
    extends uruobj {
        int count;
        hsScalarKey[] keys;

        public hsEaseKeyList(context c) {
            e.ensure(c.readversion == 3);
            this.count = c.readInt();
            this.keys = new hsScalarKey[this.count];
            for (int i = 0; i < this.count; ++i) {
                this.keys[i] = new hsScalarKey(c);
            }
        }
    }

    public static class hsScalarKey
    extends uruobj {
        hsKeyFrame parent;
        public Flt value;
        public Flt test1;
        public Flt test2;

        public hsScalarKey(context c) {
            e.ensure(c.readversion == 3);
            this.parent = new hsKeyFrame(c);
            if ((this.parent.flags & 2) != 0) {
                this.test1 = new Flt(c);
                this.test2 = new Flt(c);
            }
            this.value = new Flt(c);
        }

        public void compile(Bytedeque c) {
            this.parent.compile(c);
            if ((this.parent.flags & 2) != 0) {
                this.test1.compile(c);
                this.test2.compile(c);
            }
            this.value.compile(c);
        }
    }

    public static class hsKeyFrame
    extends uruobj {
        int flags;
        int framenum;
        Flt frametime;

        public hsKeyFrame(context c) {
            e.ensure(c.readversion == 3);
            this.flags = c.readInt();
            this.framenum = c.readInt();
            this.frametime = new Flt(c);
        }

        public void compile(Bytedeque c) {
            c.writeInt(this.flags);
            c.writeInt(this.framenum);
            this.frametime.compile(c);
        }
    }

    public static class plScalarController
    extends uruobj {
        plLeafController parent;
        public int flag;
        public hsScalarKeyList xkeylist;

        public plScalarController(context c) throws readexception {
            e.ensure(c.readversion == 3);
            this.parent = new plLeafController(c);
            this.flag = c.readInt();
            if (this.flag != 0) {
                this.xkeylist = new hsScalarKeyList(c);
            }
        }

        public void compile(Bytedeque c) {
            this.parent.compile(c);
            c.writeInt(this.flag);
            if (this.flag != 0) {
                this.xkeylist.compile(c);
            }
        }
    }

    public static class hsScalarKeyList
    extends uruobj {
        public int count;
        public hsScalarKey[] keys;

        public hsScalarKeyList(context c) {
            e.ensure(c.readversion == 3);
            this.count = c.readInt();
            this.keys = new hsScalarKey[this.count];
            for (int i = 0; i < this.count; ++i) {
                this.keys[i] = new hsScalarKey(c);
            }
        }

        public void compile(Bytedeque c) {
            c.writeInt(this.count);
            c.writeArray2(this.keys);
        }
    }

    public static class plSimplePosController
    extends uruobj {
        public int flag;
        public plPoint3Controller xpoint3controller;

        public plSimplePosController(context c) throws readexception {
            e.ensure(c.readversion == 3);
            this.flag = c.readInt();
            if (this.flag != 0) {
                this.xpoint3controller = new plPoint3Controller(c);
            }
        }

        public void compile(Bytedeque c) {
            c.writeInt(this.flag);
            if (this.flag != 0) {
                this.xpoint3controller.compile(c);
            }
        }
    }

    public static class plPoint3Controller
    extends uruobj {
        plLeafController parent;
        public int flag;
        public hsPoint3KeyList xkeylist;

        public plPoint3Controller(context c) throws readexception {
            e.ensure(c.readversion == 3);
            this.parent = new plLeafController(c);
            this.flag = c.readInt();
            if (this.flag != 0) {
                this.xkeylist = new hsPoint3KeyList(c);
            }
        }

        public void compile(Bytedeque c) {
            this.parent.compile(c);
            c.writeInt(this.flag);
            if (this.flag != 0) {
                this.xkeylist.compile(c);
            }
        }
    }

    public static class hsPoint3KeyList
    extends uruobj {
        public int count;
        public hsPoint3Key[] keys;

        public hsPoint3KeyList(context c) throws readexception {
            e.ensure(c.readversion == 3);
            this.count = c.readInt();
            this.keys = new hsPoint3Key[this.count];
            for (int i = 0; i < this.count; ++i) {
                this.keys[i] = new hsPoint3Key(c);
            }
        }

        public void compile(Bytedeque c) {
            c.writeInt(this.count);
            c.writeArray2(this.keys);
        }
    }

    public static class hsPoint3Key
    extends uruobj {
        hsKeyFrame parent;
        public Vertex xintan;
        public Vertex xouttan;
        public Vertex value;

        public hsPoint3Key(context c) throws readexception {
            e.ensure(c.readversion == 3);
            this.parent = new hsKeyFrame(c);
            if ((this.parent.flags & 2) != 0) {
                this.xintan = new Vertex(c);
                this.xouttan = new Vertex(c);
            }
            this.value = new Vertex(c);
        }

        public void compile(Bytedeque c) {
            this.parent.compile(c);
            if ((this.parent.flags & 2) != 0) {
                this.xintan.compile(c);
                this.xouttan.compile(c);
            }
            this.value.compile(c);
        }
    }

    public static class plMatrix44Controller
    extends uruobj {
        plLeafController parent;
        public int count;
        public hsMatrix44Key[] keys;

        public plMatrix44Controller(context c) throws readexception {
            e.ensure(c.readversion == 3);
            this.parent = new plLeafController(c);
            this.count = c.readInt();
            this.keys = new hsMatrix44Key[this.count];
            for (int i = 0; i < this.count; ++i) {
                this.keys[i] = new hsMatrix44Key(c);
            }
        }

        public void compile(Bytedeque c) {
            this.parent.compile(c);
            c.writeInt(this.count);
            c.writeArray2(this.keys);
        }
    }

    public static class hsMatrix44Key
    extends uruobj {
        public hsKeyFrame parent;
        public Transmatrix value;

        public hsMatrix44Key(context c) {
            e.ensure(c.readversion == 3);
            this.parent = new hsKeyFrame(c);
            this.value = new Transmatrix(c);
        }

        public void compile(Bytedeque c) {
            this.parent.compile(c);
            this.value.compile(c);
        }
    }

    public static class hsScaleValue
    extends uruobj {
        Vertex s;
        Quat q;

        public hsScaleValue(context c) throws readexception {
            e.ensure(c.readversion == 3);
            this.s = new Vertex(c);
            this.q = new Quat(c);
        }

        public void compile(Bytedeque c) {
            this.s.compile(c);
            this.q.compile(c);
        }
    }

    public static class hsScaleKey
    extends uruobj {
        hsKeyFrame keyframe;
        Vertex xintan;
        Vertex xouttan;
        hsScaleValue value;

        public hsScaleKey(context c) throws readexception {
            e.ensure(c.readversion == 3);
            this.keyframe = new hsKeyFrame(c);
            if ((this.keyframe.flags & 2) != 0) {
                this.xintan = new Vertex(c);
                this.xouttan = new Vertex(c);
            }
            this.value = new hsScaleValue(c);
        }

        public void compile(Bytedeque c) {
            this.keyframe.compile(c);
            if ((this.keyframe.flags & 2) != 0) {
                this.xintan.compile(c);
                this.xouttan.compile(c);
            }
            this.value.compile(c);
        }
    }

    public static class plScaleValueController
    extends uruobj {
        plLeafController parent;
        int count;
        hsScaleKey[] keys;

        public plScaleValueController(context c) throws readexception {
            e.ensure(c.readversion == 3);
            this.parent = new plLeafController(c);
            this.count = c.readInt();
            this.keys = new hsScaleKey[this.count];
            for (int i = 0; i < this.count; ++i) {
                this.keys[i] = new hsScaleKey(c);
            }
        }

        public void compile(Bytedeque c) {
            this.parent.compile(c);
            c.writeInt(this.count);
            c.writeArray2(this.keys);
        }
    }

    public static class plSimpleScaleController
    extends uruobj {
        int flag;
        plScaleValueController scalecontroller;

        public plSimpleScaleController(context c) throws readexception {
            e.ensure(c.readversion == 3);
            this.flag = c.readInt();
            if (this.flag != 0) {
                this.scalecontroller = new plScaleValueController(c);
            }
            if (this.scalecontroller.keys[0].keyframe.flags != 1) {
                boolean bl = false;
            }
        }

        public void compile(Bytedeque c) {
            c.writeInt(this.flag);
            this.scalecontroller.compile(c);
        }
    }

    public static class plCompoundRotController
    extends uruobj {
        int flag1;
        plScalarController pos1;
        int flag2;
        plScalarController pos2;
        int flag3;
        plScalarController pos3;

        public plCompoundRotController(context c) throws readexception {
            e.ensure(c.readversion == 3);
            this.flag1 = c.readInt();
            if (this.flag1 != 0) {
                this.pos1 = new plScalarController(c);
            }
            this.flag2 = c.readInt();
            if (this.flag2 != 0) {
                this.pos2 = new plScalarController(c);
            }
            this.flag3 = c.readInt();
            if (this.flag3 != 0) {
                this.pos3 = new plScalarController(c);
            }
        }

        public void compile(Bytedeque c) {
            c.writeInt(this.flag1);
            if (this.flag1 != 0) {
                this.pos1.compile(c);
            }
            c.writeInt(this.flag2);
            if (this.flag2 != 0) {
                this.pos2.compile(c);
            }
            c.writeInt(this.flag3);
            if (this.flag3 != 0) {
                this.pos3.compile(c);
            }
        }
    }

    public static class hsQuatKey
    extends uruobj {
        hsKeyFrame keyframe;
        Quat value;

        public hsQuatKey(context c) {
            e.ensure(c.readversion == 3);
            this.keyframe = new hsKeyFrame(c);
            this.value = new Quat(c);
            if (this.value.w.toJavaFloat() == this.value.y.toJavaFloat() && (double)this.value.w.toJavaFloat() != 0.0) {
                boolean bl = false;
            }
        }
    }

    public static class plQuatController
    extends uruobj {
        plLeafController parent;
        int count;
        hsQuatKey[] keys;

        public plQuatController(context c) throws readexception {
            e.ensure(c.readversion == 3);
            this.parent = new plLeafController(c);
            this.count = c.readInt();
            this.keys = new hsQuatKey[this.count];
            for (int i = 0; i < this.count; ++i) {
                this.keys[i] = new hsQuatKey(c);
            }
        }
    }

    public static class plSimpleRotController
    extends uruobj {
        int flag;
        plQuatController value;

        public plSimpleRotController(context c) throws readexception {
            e.ensure(c.readversion == 3);
            this.flag = c.readInt();
            if (this.flag != 0) {
                this.value = new plQuatController(c);
            }
        }
    }

    public static class plCompoundPosController
    extends uruobj {
        public int flag1;
        public plScalarController pos1;
        public int flag2;
        public plScalarController pos2;
        public int flag3;
        public plScalarController pos3;

        public plCompoundPosController(context c) throws readexception {
            e.ensure(c.readversion == 3);
            this.flag1 = c.readInt();
            if (this.flag1 != 0) {
                this.pos1 = new plScalarController(c);
            }
            this.flag2 = c.readInt();
            if (this.flag2 != 0) {
                this.pos2 = new plScalarController(c);
            }
            this.flag3 = c.readInt();
            if (this.flag3 != 0) {
                this.pos3 = new plScalarController(c);
            }
        }

        public void compile(Bytedeque c) {
            c.writeInt(this.flag1);
            if (this.flag1 != 0) {
                this.pos1.compile(c);
            }
            c.writeInt(this.flag2);
            if (this.flag2 != 0) {
                this.pos2.compile(c);
            }
            c.writeInt(this.flag3);
            if (this.flag3 != 0) {
                this.pos3.compile(c);
            }
        }
    }
}

