/*
 * Decompiled with CFR 0.152.
 */
package prpobjects;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Vector;
import prpobjects.Pageid;
import prpobjects.Pagetype;
import prpobjects.PrpHeader;
import prpobjects.PrpObjectIndex;
import prpobjects.PrpRootObject;
import prpobjects.Typeid;
import prpobjects.Uruobjectdesc;
import prpobjects.Uruobjectref;
import prpobjects.plCoordinateInterface;
import prpobjects.plFilterCoordInterface;
import prpobjects.plSceneObject;
import prpobjects.prpprocess;
import prpobjects.prputils;
import prpobjects.uruobj;
import prpobjects.x0000Scenenode;
import shared.ByteArrayBytestream;
import shared.FileUtils;
import shared.FindAllDescendants;
import shared.IBytedeque;
import shared.SerialBytestream;
import shared.m;
import shared.uncaughtexception;
import uru.Bytedeque;
import uru.Bytestream;
import uru.context;
import uru.generics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class prpfile {
    public PrpHeader header;
    public Vector<PrpRootObject> objects2 = new Vector();
    public PrpObjectIndex objectindex;
    public String filename;
    private boolean markAsChanged = false;

    public boolean hasChanged() {
        return this.markAsChanged;
    }

    public void markAsChanged() {
        this.markAsChanged = true;
    }

    public Vector<Uruobjectref> getAllRootObjectRefs() {
        Vector<Uruobjectref> refs = new Vector<Uruobjectref>();
        for (PrpRootObject ro : this.objects2) {
            refs.add(ro.getref());
        }
        return refs;
    }

    public void sort() {
        Vector<PrpRootObject> newobjects = this.getSortedObjects();
        this.objects2 = newobjects;
    }

    public Vector<PrpRootObject> getSortedObjects() {
        Vector newobjects = (Vector)this.objects2.clone();
        Collections.sort(newobjects, new Comparator(){

            public int compare(Object o1, Object o2) {
                PrpRootObject r1 = (PrpRootObject)o1;
                PrpRootObject r2 = (PrpRootObject)o2;
                String t1 = r1.header.objecttype.toString();
                String t2 = r2.header.objecttype.toString();
                int comp = t1.compareToIgnoreCase(t2);
                return comp;
            }
        });
        return newobjects;
    }

    public Vector<Vector<PrpRootObject>> getOrderedObjects() {
        Vector<Vector<PrpRootObject>> r = new Vector<Vector<PrpRootObject>>();
        Vector<PrpRootObject> newobjects = this.getSortedObjects();
        Typeid lasttype = null;
        Vector<PrpRootObject> lastvec = null;
        for (PrpRootObject ro : newobjects) {
            if (ro.header.objecttype != lasttype) {
                lastvec = new Vector<PrpRootObject>();
                r.add(lastvec);
                lasttype = ro.header.objecttype;
            }
            lastvec.add(ro);
        }
        return r;
    }

    public <T> Vector<T> FindAllInstances(Class<T> klass) {
        Vector<T> r = FindAllDescendants.FindAllDescendantsByClass(klass, this.objects2);
        return r;
    }

    public PrpRootObject findFirstScenenode() {
        for (PrpRootObject obj : this.objects2) {
            if (obj.header.objecttype != Typeid.plSceneNode) continue;
            return obj;
        }
        return null;
    }

    public void addObject(Uruobjectref ref, uruobj obj) {
        PrpRootObject ro = PrpRootObject.createFromDescAndObject(ref.xdesc, obj);
        this.addObject(ro);
    }

    public PrpRootObject addObject(Typeid type, String name, uruobj obj) {
        Uruobjectdesc desc = Uruobjectdesc.createDefaultWithTypeNamePagePagetype(type, name, this.header.pageid, this.header.pagetype);
        PrpRootObject ro = PrpRootObject.createFromDescAndObject(desc, obj);
        this.addObject(ro);
        return ro;
    }

    public void addObject(PrpRootObject obj) {
        this.objects2.add(obj);
    }

    public Vector<String> findAllSceneobjectsThatStartWith(String startString) {
        Vector<String> result = new Vector<String>();
        for (PrpRootObject obj : this.objects2) {
            if (obj.header.objecttype != Typeid.plSceneObject || !obj.header.desc.objectname.toString().startsWith(startString)) continue;
            result.add(obj.header.desc.objectname.toString());
        }
        return result;
    }

    public Vector<String> findAllSceneobjectsThatReferencePythonfilemod(String pfmname) {
        Vector<String> result = new Vector<String>();
        for (PrpRootObject obj : this.objects2) {
            if (obj.header.objecttype != Typeid.plSceneObject) continue;
            plSceneObject so = (plSceneObject)obj.castTo();
            for (Uruobjectref ref : so.modifiers) {
                if (!ref.hasref() || ref.xdesc.objecttype != Typeid.plPythonFileMod || !ref.xdesc.objectname.toString().equals(pfmname)) continue;
                result.add(obj.header.desc.objectname.toString());
            }
        }
        return result;
    }

    public boolean contains(Uruobjectdesc desc) {
        PrpRootObject result = this.findObjectWithDesc(desc);
        return result != null;
    }

    public boolean contains(String name, Typeid type) {
        Uruobjectdesc desc = this.findDescInIndex(name, type);
        return desc != null;
    }

    public Uruobjectdesc findDescInIndex(String name, Typeid type) {
        for (PrpObjectIndex.ObjectindexObjecttype oiot : this.objectindex.types) {
            if (oiot.type != type) continue;
            for (PrpObjectIndex.ObjectindexObjecttypeObjectdesc oiotod : oiot.descs) {
                m.msg(oiotod.desc.toString());
                if (!oiotod.desc.objectname.toString().equals(name)) continue;
                return oiotod.desc;
            }
        }
        return null;
    }

    public static prpfile readHeaderAndIndexFromFile(String filename) {
        prpfile result = new prpfile();
        byte[] filedata = FileUtils.ReadFile(filename);
        File f = new File(filename);
        context c = context.createFromBytestream(new Bytestream(filedata));
        c.curFile = filename;
        result.header = new PrpHeader(c);
        context c2 = c.Fork(result.header.offsetToObjectIndex);
        result.objectindex = new PrpObjectIndex(c2);
        c2.close();
        result.filename = filename;
        return result;
    }

    public void markObjectDeleted(Uruobjectref ref, boolean warnIfNotPresent) {
        if (ref.hasref()) {
            this.markObjectDeleted(ref.xdesc.objecttype, ref.xdesc.objectname.toString(), warnIfNotPresent);
        }
    }

    public void markObjectDeleted(Typeid type, String name) {
        this.markObjectDeleted(type, name, true);
    }

    public void markObjectDeleted(Typeid type, String name, boolean warnIfNotPresent) {
        for (PrpRootObject obj : this.objects2) {
            if (obj.header.desc.objecttype != type || !obj.header.desc.objectname.toString().equals(name)) continue;
            obj.tagDeleted = true;
            return;
        }
        if (warnIfNotPresent) {
            m.msg("Could not find object to remove.");
        }
    }

    public void deleteObject(Typeid type, String name) {
        PrpRootObject ro = this.findObject(name, type);
        this.objects2.remove(ro);
    }

    public void orderObjects() {
        Collections.sort(this.objects2);
    }

    public static prpfile createFromContext(context c, Typeid[] typesToRead) {
        prpfile result = prputils.ProcessAllMoul(c, false, typesToRead);
        return result;
    }

    public static prpfile createFromObjectsAndInfo(Vector<PrpRootObject> objs, String agename, String pagename, Pageid pageid, Pagetype pagetype) {
        prpfile result = new prpfile();
        result.objects2 = objs;
        result.header = PrpHeader.createFromInfo(agename, pageid, pagetype, pagename);
        return result;
    }

    public static prpfile createFromObjectsAndInfo(PrpRootObject[] objs, String agename, String pagename, Pageid pageid, Pagetype pagetype) {
        Vector<PrpRootObject> objs2 = generics.convertArrayToVector(objs);
        return prpfile.createFromObjectsAndInfo(objs2, agename, pagename, pageid, pagetype);
    }

    public PrpRootObject addScenenode() {
        x0000Scenenode sn = x0000Scenenode.createDefault();
        String nodename = this.header.agename.toString() + "_" + this.header.pagename.toString();
        Uruobjectdesc sndesc = Uruobjectdesc.createDefaultWithTypeNamePagePagetype(Typeid.plSceneNode, nodename, this.header.pageid, this.header.pagetype);
        PrpRootObject snro = PrpRootObject.createFromDescAndObject(sndesc, sn);
        this.addObject(snro);
        return snro;
    }

    public static prpfile create(String agename, String pagename, Pageid pageid, Pagetype pagetype) {
        PrpRootObject[] objects = new PrpRootObject[]{};
        prpfile prp = prpfile.createFromObjectsAndInfo(objects, agename, pagename, pageid, pagetype);
        return prp;
    }

    public static prpfile createFromFile(String filename, boolean readRaw) {
        File f = new File(filename);
        return prpfile.createFromFile(f, readRaw);
    }

    public static prpfile createFromFile(File f, boolean readRaw) {
        context c = context.createFromBytestream(SerialBytestream.createFromFile(f));
        c.curFile = f.getAbsolutePath();
        prpfile prp = prpprocess.ProcessAllObjects(c, readRaw);
        prp.filename = f.getAbsolutePath();
        c.close();
        return prp;
    }

    public static prpfile createFromBytes(byte[] data, boolean readRaw) {
        context c = context.createFromBytestream(ByteArrayBytestream.createFromByteArray(data));
        prpfile prp = prpprocess.ProcessAllObjects(c, readRaw);
        c.close();
        return prp;
    }

    public void saveAsFile(String filename) {
        IBytedeque result = this.saveAsBytes();
        result.writeAllBytesToFile(filename);
    }

    public IBytedeque saveAsBytes() {
        return this.saveAsBytes(prputils.Compiler.getDefaultDecider());
    }

    public IBytedeque saveAsBytes(prputils.Compiler.Decider decider) {
        if (decider == null) {
            decider = prputils.Compiler.getDefaultDecider();
        }
        this.FixObjectOrder();
        Bytedeque result = prputils.Compiler.RecompilePrp(this, decider);
        return result;
    }

    public PrpRootObject findObject(String name, Typeid type) {
        for (PrpRootObject obj : this.objects2) {
            if (obj == null || !obj.header.desc.objectname.toString().equals(name) || !obj.header.desc.objecttype.equals(type)) continue;
            return obj;
        }
        return null;
    }

    public PrpRootObject findObjectWithRef(Uruobjectref ref) {
        if (!ref.hasref()) {
            m.warn("Tried to remove object, but the ref given has no desc.");
            return null;
        }
        PrpRootObject result = this.findObjectWithDesc(ref.xdesc);
        return result;
    }

    public PrpRootObject findObjectWithDesc(Uruobjectdesc desc) {
        int numobjects = this.objects2.size();
        for (int i = 0; i < numobjects; ++i) {
            PrpRootObject curobj = this.objects2.get(i);
            Uruobjectdesc curdesc = curobj.header.desc;
            if (!curdesc.objectname.toString().equals(desc.objectname.toString()) || curdesc.objecttype != desc.objecttype || !curdesc.pageid.equals(desc.pageid)) continue;
            return curobj;
        }
        return null;
    }

    public void tagRootObjectAsDeleted(PrpRootObject obj) {
        if (obj == null) {
            return;
        }
        for (PrpRootObject curobj : this.objects2) {
            if (obj != curobj) continue;
            curobj.tagDeleted = true;
        }
    }

    public void tagRootObjectAsDeleted(Uruobjectref ref) {
        PrpRootObject obj = this.findObjectWithRef(ref);
        this.tagRootObjectAsDeleted(obj);
    }

    public PrpRootObject[] FindAllObjectsOfType(Typeid type) {
        return prputils.FindAllObjectsOfType(this, type);
    }

    public Vector<PrpRootObject> FindObjectsThatReferenceAnother(Uruobjectdesc desc) {
        Vector<PrpRootObject> r = new Vector<PrpRootObject>();
        for (PrpRootObject ro : this.objects2) {
            uruobj obj = ro.getObject();
            for (Uruobjectdesc curdesc : FindAllDescendants.FindAllDescendantsByClass(Uruobjectdesc.class, obj)) {
                if (!curdesc.equals(desc) || r.contains(ro)) continue;
                r.add(ro);
            }
        }
        return r;
    }

    public void _markScenenodeSceneobjects() {
        PrpRootObject[] sns = this.FindAllObjectsOfType(Typeid.plSceneNode);
        if (sns.length != 0) {
            if (sns.length == 1) {
                x0000Scenenode sn = (x0000Scenenode)sns[0].castTo();
                for (PrpRootObject ro : this.objects2) {
                    if (ro.header.objecttype != Typeid.plSceneObject) continue;
                    plSceneObject so = (plSceneObject)ro.castTo();
                    if (sn.objectrefs1.contains(ro.getref())) {
                        so.includeInScenenode = true;
                        continue;
                    }
                    so.includeInScenenode = false;
                }
            } else {
                m.throwUncaughtException("unexpected");
            }
        }
    }

    public Vector<PrpRootObject> getAllChildren(Uruobjectref ref) {
        Vector<PrpRootObject> r = new Vector<PrpRootObject>();
        this.getAllChildren(ref, r);
        return r;
    }

    private void getAllChildren(Uruobjectref ref, Vector<PrpRootObject> r) {
        PrpRootObject so_ro = this.findObjectWithRef(ref);
        if (so_ro != null) {
            r.add(so_ro);
            plSceneObject so = (plSceneObject)so_ro.castTo();
            PrpRootObject ci_ro = this.findObjectWithRef(so.coordinateinterface);
            if (ci_ro != null) {
                plCoordinateInterface ci = (plCoordinateInterface)ci_ro.castTo();
                for (Uruobjectref childref : ci.children) {
                    this.getAllChildren(childref, r);
                }
            }
        }
    }

    public ChildrenTree GetChildrenTree(boolean includeRegularElements) {
        ChildrenTree root = new ChildrenTree(null, null);
        HashMap<Uruobjectdesc, ChildrenTree> parents = new HashMap<Uruobjectdesc, ChildrenTree>();
        for (PrpRootObject ro : this.objects2) {
            boolean handled = false;
            if (ro.header.objecttype == Typeid.plSceneObject) {
                PrpRootObject ci_ro;
                plSceneObject so = ro.castToSceneObject();
                if (so.coordinateinterface.hasref() && (ci_ro = this.findObjectWithDesc(so.coordinateinterface.xdesc)) != null) {
                    plCoordinateInterface ci;
                    if (ci_ro.header.objecttype == Typeid.plCoordinateInterface) {
                        ci = (plCoordinateInterface)ci_ro.castTo();
                    } else if (ci_ro.header.objecttype == Typeid.plFilterCoordInterface) {
                        plFilterCoordInterface fci = (plFilterCoordInterface)ci_ro.castTo();
                        ci = fci.parent;
                    } else {
                        throw new uncaughtexception("unexpected");
                    }
                    ChildrenTree parent = (ChildrenTree)parents.get(ro.header.desc);
                    if (parent == null) {
                        parent = root;
                    }
                    ChildrenTree node = new ChildrenTree(ro, parent);
                    handled = true;
                    parent.children.add(node);
                    parents.put(ro.header.desc, parent);
                    for (Uruobjectref ref : ci.children) {
                        Uruobjectdesc desc = ref.xdesc;
                        ChildrenTree curparent = (ChildrenTree)parents.get(desc);
                        if (curparent == null) {
                            parents.put(desc, node);
                            continue;
                        }
                        ChildrenTree child = curparent.RemoveChild(desc);
                        if (child == null) {
                            boolean dummy = false;
                        }
                        node.children.add(child);
                    }
                }
            }
            if (handled || !includeRegularElements) continue;
            ChildrenTree parent = root;
            ChildrenTree node = new ChildrenTree(ro, parent);
            parent.children.add(node);
        }
        return root;
    }

    public void FixObjectOrder() {
        ChildrenTree root = this.GetChildrenTree(true);
        root.OrderElements();
        Vector<PrpRootObject> neworder = root.SerializeElements();
        this.objects2 = neworder;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChildrenTree {
        PrpRootObject ro;
        ArrayList<ChildrenTree> children = new ArrayList();
        ChildrenTree parent;

        public ChildrenTree(PrpRootObject ro2, ChildrenTree parent2) {
            this.ro = ro2;
            this.parent = parent2;
        }

        public boolean isRoot() {
            return this.parent == null;
        }

        public ChildrenTree RemoveChild(Uruobjectdesc desc) {
            for (int i = 0; i < this.children.size(); ++i) {
                ChildrenTree child = this.children.get(i);
                if (!child.ro.header.desc.equals(desc)) continue;
                ChildrenTree r = this.children.remove(i);
                return r;
            }
            return null;
        }

        public void OrderElements() {
            Collections.sort(this.children, new Comparator<ChildrenTree>(){

                @Override
                public int compare(ChildrenTree a, ChildrenTree b2) {
                    int r = a.ro.header.desc.objecttype.compareTo(b2.ro.header.desc.objecttype);
                    if (r != 0) {
                        return r;
                    }
                    r = a.ro.header.desc.objectname.toString().compareTo(b2.ro.header.desc.objectname.toString());
                    if (r != 0) {
                        return r;
                    }
                    return 0;
                }
            });
            for (ChildrenTree child : this.children) {
                child.OrderElements();
            }
        }

        public String toString() {
            if (this.isRoot()) {
                return "(root)";
            }
            return this.ro.toString();
        }

        public Vector<PrpRootObject> SerializeElements() {
            Vector<PrpRootObject> r = new Vector<PrpRootObject>();
            this.SerializeElements(r);
            return r;
        }

        private void SerializeElements(Vector<PrpRootObject> r) {
            for (ChildrenTree child : this.children) {
                r.add(child.ro);
                child.SerializeElements(r);
            }
        }
    }
}

