/*
 * Decompiled with CFR 0.152.
 */
package shared;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import shared.FileUtils;
import shared.StreamUtils;
import shared.m;
import shared.nested;

public class Exec {
    public static void LaunchProgram(String execFile, String name) {
        String folder = new File(execFile).getParent();
        if (!FileUtils.Exists(execFile)) {
            m.err("Unable to launch program: ", execFile, " because it doesn't exist.");
            return;
        }
        String[] command = new String[]{execFile};
        try {
            Process p = Runtime.getRuntime().exec(command, null, new File(folder));
            m.status(name, " launched!");
        }
        catch (IOException e2) {
            m.err("Unable to launch ", name + ".");
        }
    }

    public static void RunAndReturnImmediately(boolean throwexception, String command, String ... commandLineArguments) {
        Exec.RunAndReturnImmediately(throwexception, null, command, commandLineArguments);
    }

    public static void RunAndReturnImmediately(boolean throwexception, String dir, String command, String ... commandsLineArguments) {
        File d = dir == null ? null : new File(dir);
        String[] cmdarray = new String[commandsLineArguments.length + 1];
        cmdarray[0] = command;
        for (int i = 0; i < commandsLineArguments.length; ++i) {
            cmdarray[i + 1] = commandsLineArguments[i];
        }
        try {
            Process p = Runtime.getRuntime().exec(cmdarray, null, d);
        }
        catch (Exception e2) {
            if (throwexception) {
                throw new nested(e2);
            }
            e2.printStackTrace();
        }
    }

    public static int RunAndWait(String command, String ... commandsLineArguments) {
        return Exec.RunAndWait(null, command, commandsLineArguments);
    }

    public static int RunAndWait(String dir, String command, String ... commandsLineArguments) {
        File d = dir == null ? null : new File(dir);
        String[] cmdarray = new String[commandsLineArguments.length + 1];
        cmdarray[0] = command;
        for (int i = 0; i < commandsLineArguments.length; ++i) {
            cmdarray[i + 1] = commandsLineArguments[i];
        }
        try {
            Process p = Runtime.getRuntime().exec(cmdarray, null, d);
            int errorvalue = p.waitFor();
            return errorvalue;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return -1;
        }
    }

    public static ReturnInfo RunAndWaitWithStreams(String dirstr, byte[] stdin_data, String command, String ... commandsLineArguments) {
        ReturnInfo result = new ReturnInfo();
        File dir = dirstr == null ? null : new File(dirstr);
        String[] cmdarray = new String[commandsLineArguments.length + 1];
        cmdarray[0] = command;
        for (int i = 0; i < commandsLineArguments.length; ++i) {
            cmdarray[i + 1] = commandsLineArguments[i];
        }
        try {
            int errorvalue;
            Process p = Runtime.getRuntime().exec(cmdarray, null, dir);
            InputStream stdout = p.getInputStream();
            InputStream stderr = p.getErrorStream();
            OutputStream stdin = p.getOutputStream();
            if (stdin_data != null) {
                stdin.write(stdin_data);
                stdin.close();
            }
            result.stdout = StreamUtils.ReadAll(stdout);
            result.stderr = StreamUtils.ReadAll(stderr);
            result.returnval = errorvalue = p.waitFor();
            return result;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public static class ReturnInfo {
        public byte[] stdout;
        public byte[] stderr;
        public int returnval;
    }
}

