/*
 * Decompiled with CFR 0.152.
 */
package shared;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import shared.IBytestream;
import shared.b;
import shared.m;
import shared.uncaughtexception;

public class SerialBytestream
extends IBytestream {
    BufferedInputStream in;
    int pos = 0;
    int filelength;

    public int getAbsoluteOffset() {
        return this.pos;
    }

    public int getFilelength() {
        return this.filelength;
    }

    public int getBytesRemaining() {
        return this.getFilelength() - this.getAbsoluteOffset();
    }

    public static IBytestream createFromFile(File f) {
        return SerialBytestream.createFromFilename(f.getAbsolutePath());
    }

    public static IBytestream createFromFilename(String filename) {
        return SerialBytestream.createFromFilenameOffset(filename, 0);
    }

    public void close() {
        try {
            if (this.in != null) {
                this.in.close();
                this.in = null;
            }
        }
        catch (Exception e2) {
            m.err("Unable to close SerialBytestream.");
        }
    }

    protected SerialBytestream() {
    }

    public static IBytestream createFromFilenameOffset(String filename, int offset) {
        SerialBytestream result = new SerialBytestream();
        result.sourceName = filename;
        result.openfile();
        result.skip(offset);
        return result;
    }

    public SerialBytestream(String filename) {
        this(filename, 0);
    }

    public SerialBytestream(String filename, int offset) {
        this.sourceName = filename;
        this.openfile();
        this.skip(offset);
    }

    protected int read() {
        try {
            ++this.pos;
            int result = this.in.read();
            return result;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new uncaughtexception("Unable to read byte, probably hit end of file.:" + e2.getMessage());
        }
    }

    public byte readByte() {
        try {
            ++this.pos;
            byte result = (byte)this.in.read();
            return result;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new uncaughtexception("Unable to read byte, probably hit end of file.:" + e2.getMessage());
        }
    }

    public byte[] readBytes(int num) {
        try {
            this.pos += num;
            byte[] result = new byte[num];
            this.in.read(result);
            return result;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new uncaughtexception("Unable to read bytes, probably hit end of file.:" + e2.getMessage());
        }
    }

    public short readShort() {
        try {
            this.pos += 2;
            byte[] buffer = new byte[2];
            this.in.read(buffer);
            short result = b.BytesToInt16(buffer, 0);
            return result;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new uncaughtexception("Unable to read short, probably hit end of file.:" + e2.getMessage());
        }
    }

    public int readInt() {
        try {
            this.pos += 4;
            byte[] buffer = new byte[4];
            this.in.read(buffer);
            int result = b.BytesToInt32(buffer, 0);
            return result;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new uncaughtexception("Unable to read int, probably hit end of file.:" + e2.getMessage());
        }
    }

    private void openfile() {
        File f = new File(this.sourceName);
        this.filelength = (int)f.length();
        if (!f.exists()) {
            throw new uncaughtexception("File doesn't exist:" + this.sourceName);
        }
        try {
            this.in = new BufferedInputStream(new FileInputStream(f));
        }
        catch (FileNotFoundException e2) {
            throw new uncaughtexception("File doesn't exist:" + this.sourceName);
        }
    }

    public IBytestream Fork() {
        return this.Fork(this.pos);
    }

    public IBytestream Fork(long offset) {
        SerialBytestream result = new SerialBytestream();
        result.sourceName = this.sourceName;
        result.openfile();
        result.skip(offset);
        return result;
    }

    public void skip(long n) {
        try {
            this.pos = (int)((long)this.pos + n);
            this.in.skip(n);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new uncaughtexception("Unable to skip bytes.  Probably hit end of file: " + e2.getMessage());
        }
    }

    public String toString() {
        int readahead = 128;
        IBytestream fork = this.Fork();
        String result = "\n(source=" + this.sourceName + ")\n";
        try {
            result = result + "(pos=0x" + Integer.toHexString(fork.getAbsoluteOffset()) + "=" + Integer.toString(fork.getAbsoluteOffset()) + ")\n";
            result = result + "(bytes remaining=" + Integer.toString(this.getBytesRemaining()) + ")\n";
            result = result + "Data:\n";
            if (fork.getBytesRemaining() < readahead) {
                readahead = fork.getBytesRemaining();
            }
            if (fork.getBytesRemaining() < 0) {
                throw new uncaughtexception("We've somehow read past the end of the file.  Fix this now!");
            }
            if (fork.getBytesRemaining() == 0) {
                result = result + "End of File.\n";
            }
            for (int i = 0; i < readahead; ++i) {
                byte by = fork.readByte();
                String hex = Integer.toHexString(b.ByteToInt32(by));
                if (hex.length() == 0) {
                    hex = "00";
                }
                if (hex.length() == 1) {
                    hex = "0" + hex;
                }
                result = result + hex;
                if (i % 4 == 3) {
                    result = result + " ";
                }
                if (i % 16 != 15) continue;
                result = result + "\n";
            }
        }
        catch (Exception e2) {
            result = result + "Error reading ahead in stream.";
        }
        return result;
    }
}

