/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer.tilesources;

import java.awt.Point;
import java.util.Random;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.TileXY;
import org.openstreetmap.gui.jmapviewer.interfaces.ICoordinate;
import org.openstreetmap.gui.jmapviewer.tilesources.TMSTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.TemplatedTMSTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.TileSourceInfo;

public class ScanexTileSource
extends TMSTileSource {
    private static final String DEFAULT_URL = "https://maps.kosmosnimki.ru";
    private static final int DEFAULT_MAXZOOM = 14;
    private static final String API_KEY = "4018C5A9AECAD8868ED5DEB2E41D09F7";
    private static final double RADIUS_E = 6378137.0;
    private static final double EQUATOR = 4.007501668557849E7;
    private static final double E = 0.0818191908426;
    private ScanexLayer layer = ScanexLayer.IRS;
    private TemplatedTMSTileSource templateSource;
    private double cachedLat;

    public ScanexTileSource(TileSourceInfo info) {
        super(info);
        String url = info.getUrl();
        this.tileSize = 256;
        for (ScanexLayer slayer : ScanexLayer.values()) {
            if (!url.equalsIgnoreCase(slayer.getName())) continue;
            this.layer = slayer;
            this.baseUrl = DEFAULT_URL;
            if (this.maxZoom == 0) {
                this.maxZoom = 14;
            }
            return;
        }
        TemplatedTMSTileSource.checkUrl(info.getUrl());
        this.templateSource = new TemplatedTMSTileSource(info);
    }

    @Override
    public String getExtension() {
        return "jpeg";
    }

    @Override
    public String getTileUrl(int zoom, int tilex, int tiley) {
        if (this.templateSource != null) {
            return this.templateSource.getTileUrl(zoom, tilex, tiley);
        }
        return this.getBaseUrl() + this.getTilePath(zoom, tilex, tiley);
    }

    @Override
    public String getTilePath(int zoom, int tilex, int tiley) {
        int tmp = (int)Math.pow(2.0, (double)zoom - 1.0);
        tiley = tmp - tiley - 1;
        return this.layer.getUri() + "&apikey=" + API_KEY + "&x=" + (tilex -= tmp) + "&y=" + tiley + "&z=" + zoom;
    }

    @Override
    public Point latLonToXY(double lat, double lon, int zoom) {
        return new Point((int)Math.round(this.osmMercator.lonToX(lon, zoom)), (int)Math.round(ScanexTileSource.latToTileY(lat, zoom)));
    }

    @Override
    public ICoordinate xyToLatLon(int x, int y, int zoom) {
        return new Coordinate(this.tileYToLat(y, zoom), this.osmMercator.xToLon(x, zoom));
    }

    @Override
    public TileXY latLonToTileXY(double lat, double lon, int zoom) {
        return new TileXY(this.osmMercator.lonToX(lon, zoom) / (double)this.getTileSize(), ScanexTileSource.latToTileY(lat, zoom));
    }

    @Override
    public ICoordinate tileXYToLatLon(int x, int y, int zoom) {
        return new Coordinate(this.tileYToLat(y, zoom), this.osmMercator.xToLon((long)x * (long)this.getTileSize(), zoom));
    }

    private static double latToTileY(double lat, int zoom) {
        double tmp = Math.tan(0.7853981633974483 * (1.0 + lat / 90.0));
        double pow = Math.pow(Math.tan(0.7853981633974483 + Math.asin(0.0818191908426 * Math.sin(Math.toRadians(lat))) / 2.0), 0.0818191908426);
        return (2.0037508342789244E7 - 6378137.0 * Math.log(tmp / pow)) * Math.pow(2.0, zoom) / 4.007501668557849E7;
    }

    private double tileYToLat(double y, int zoom) {
        double lat0;
        double lat = this.cachedLat;
        do {
            lat0 = lat;
            if (!((lat -= Math.toDegrees(ScanexTileSource.nextTerm(Math.toRadians(lat), y, zoom))) > 85.05112877980659) && !(lat < -85.05112877980659)) continue;
            Random r = new Random();
            lat = -85.05112877980659 + (double)r.nextInt(170);
        } while (Math.abs(lat0 - lat) > 1.0E-6);
        this.cachedLat = lat;
        return lat;
    }

    private static double nextTerm(double lat, double y, int zoom) {
        double sinl = Math.sin(lat);
        double cosl = Math.cos(lat);
        zoom = (int)Math.pow(2.0, (double)zoom - 1.0);
        double ec = Math.exp((1.0 - y / (double)zoom) * Math.PI);
        double f = Math.tan(0.7853981633974483 + lat / 2.0) - ec * Math.pow(Math.tan(0.7853981633974483 + Math.asin(0.0818191908426 * sinl) / 2.0), 0.0818191908426);
        double df = 1.0 / (1.0 - sinl) - ec * 0.0818191908426 * cosl / ((1.0 - 0.0818191908426 * sinl) * Math.sqrt(1.0 - 0.0066943799901378 * sinl * sinl));
        return f / df;
    }

    private static enum ScanexLayer {
        IRS("irs", "/TileSender.ashx?ModeKey=tile&MapName=F7B8CF651682420FA1749D894C8AD0F6&LayerName=BAC78D764F0443BD9AF93E7A998C9F5B");

        private final String name;
        private final String uri;

        private ScanexLayer(String name, String uri) {
            this.name = name;
            this.uri = uri;
        }

        public String getName() {
            return this.name;
        }

        public String getUri() {
            return this.uri;
        }
    }
}

