/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.logging.jdbc;

import java.lang.reflect.Method;
import java.sql.Array;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.reflection.ArrayUtil;

public abstract class BaseJdbcLogger {
    protected static final Set<String> SET_METHODS;
    protected static final Set<String> EXECUTE_METHODS;
    private final Map<Object, Object> columnMap = new HashMap<Object, Object>();
    private final List<Object> columnNames = new ArrayList<Object>();
    private final List<Object> columnValues = new ArrayList<Object>();
    protected final Log statementLog;
    protected final int queryStack;

    public BaseJdbcLogger(Log log, int queryStack) {
        this.statementLog = log;
        this.queryStack = queryStack == 0 ? 1 : queryStack;
    }

    protected void setColumn(Object key, Object value) {
        this.columnMap.put(key, value);
        this.columnNames.add(key);
        this.columnValues.add(value);
    }

    protected Object getColumn(Object key) {
        return this.columnMap.get(key);
    }

    protected String getParameterValueString() {
        ArrayList<String> typeList = new ArrayList<String>(this.columnValues.size());
        for (Object value : this.columnValues) {
            if (value == null) {
                typeList.add("null");
                continue;
            }
            typeList.add(this.objectValueString(value) + "(" + value.getClass().getSimpleName() + ")");
        }
        String parameters = ((Object)typeList).toString();
        return parameters.substring(1, parameters.length() - 1);
    }

    protected String objectValueString(Object value) {
        if (value instanceof Array) {
            try {
                return ArrayUtil.toString(((Array)value).getArray());
            }
            catch (SQLException e) {
                return value.toString();
            }
        }
        return value.toString();
    }

    protected String getColumnString() {
        return this.columnNames.toString();
    }

    protected void clearColumnInfo() {
        this.columnMap.clear();
        this.columnNames.clear();
        this.columnValues.clear();
    }

    protected String removeBreakingWhitespace(String original) {
        StringTokenizer whitespaceStripper = new StringTokenizer(original);
        StringBuilder builder = new StringBuilder();
        while (whitespaceStripper.hasMoreTokens()) {
            builder.append(whitespaceStripper.nextToken());
            builder.append(" ");
        }
        return builder.toString();
    }

    protected boolean isDebugEnabled() {
        return this.statementLog.isDebugEnabled();
    }

    protected boolean isTraceEnabled() {
        return this.statementLog.isTraceEnabled();
    }

    protected void debug(String text, boolean input) {
        if (this.statementLog.isDebugEnabled()) {
            this.statementLog.debug(this.prefix(input) + text);
        }
    }

    protected void trace(String text, boolean input) {
        if (this.statementLog.isTraceEnabled()) {
            this.statementLog.trace(this.prefix(input) + text);
        }
    }

    private String prefix(boolean isInput) {
        char[] buffer = new char[this.queryStack * 2 + 2];
        Arrays.fill(buffer, '=');
        buffer[this.queryStack * 2 + 1] = 32;
        if (isInput) {
            buffer[this.queryStack * 2] = 62;
        } else {
            buffer[0] = 60;
        }
        return new String(buffer);
    }

    static {
        EXECUTE_METHODS = new HashSet<String>();
        SET_METHODS = Arrays.stream(PreparedStatement.class.getDeclaredMethods()).filter(method -> method.getName().startsWith("set")).filter(method -> method.getParameterCount() > 1).map(Method::getName).collect(Collectors.toSet());
        EXECUTE_METHODS.add("execute");
        EXECUTE_METHODS.add("executeUpdate");
        EXECUTE_METHODS.add("executeQuery");
        EXECUTE_METHODS.add("addBatch");
    }
}

