/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.seg.HMM;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.corpus.io.ByteArray;
import com.hankcs.hanlp.model.trigram.CharacterBasedGenerativeModel;
import com.hankcs.hanlp.seg.CharacterBasedSegment;
import com.hankcs.hanlp.seg.common.Term;
import com.hankcs.hanlp.utility.GlobalObjectPool;
import com.hankcs.hanlp.utility.Predefine;
import com.hankcs.hanlp.utility.TextUtility;
import java.util.LinkedList;
import java.util.List;

public class HMMSegment
extends CharacterBasedSegment {
    CharacterBasedGenerativeModel model;

    public HMMSegment() {
        this(HanLP.Config.HMMSegmentModelPath);
    }

    public HMMSegment(String modelPath) {
        this.model = (CharacterBasedGenerativeModel)GlobalObjectPool.get(modelPath);
        if (this.model != null) {
            return;
        }
        this.model = new CharacterBasedGenerativeModel();
        long start = System.currentTimeMillis();
        Predefine.logger.info("\u5f00\u59cb\u4ece[ " + modelPath + " ]\u52a0\u8f7d2\u9636HMM\u6a21\u578b");
        try {
            ByteArray byteArray = ByteArray.createByteArray(modelPath);
            if (byteArray == null) {
                throw new IllegalArgumentException("HMM\u5206\u8bcd\u6a21\u578b[ " + modelPath + " ]\u4e0d\u5b58\u5728");
            }
            this.model.load(byteArray);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u53d1\u751f\u4e86\u5f02\u5e38\uff1a" + TextUtility.exceptionToString(e));
        }
        Predefine.logger.info("\u52a0\u8f7d\u6210\u529f\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start) + " ms");
        GlobalObjectPool.put(modelPath, this.model);
    }

    @Override
    protected List<Term> roughSegSentence(char[] sentence) {
        char[] tag = this.model.tag(sentence);
        LinkedList<Term> termList = new LinkedList<Term>();
        int offset = 0;
        for (int i = 0; i < tag.length; ++i) {
            switch (tag[i]) {
                case 'b': {
                    int begin = offset;
                    while (tag[i] != 'e') {
                        ++offset;
                        if (++i != tag.length) continue;
                    }
                    if (i == tag.length) {
                        termList.add(new Term(new String(sentence, begin, offset - begin), null));
                        break;
                    }
                    termList.add(new Term(new String(sentence, begin, offset - begin + 1), null));
                    break;
                }
                default: {
                    termList.add(new Term(new String(sentence, offset, 1), null));
                }
            }
            ++offset;
        }
        return termList;
    }
}

