/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.spelling;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.rules.spelling.CachingWordListLoader;

public class SpellcheckerTest {
    public void runLanguageSpecificTest() throws IOException {
        int totalProhibited = 0;
        if (Languages.get().isEmpty()) {
            throw new RuntimeException("Warning: no languages found in classpath - cannot run any spell check tests");
        }
        for (Language lang : Languages.get()) {
            CachingWordListLoader loader = new CachingWordListLoader();
            List prohibitedWords = loader.loadWords(lang.getShortCode() + "/hunspell/prohibit.txt");
            totalProhibited += prohibitedWords.size();
            List spellingWords = loader.loadWords(lang.getShortCode() + "/hunspell/spelling.txt");
            System.out.println("Testing " + lang + ": " + prohibitedWords.size() + " words from prohibit.txt and " + spellingWords.size() + " words from spelling.txt");
            Set intersection = prohibitedWords.stream().distinct().filter(spellingWords::contains).collect(Collectors.toSet());
            if (intersection.size() <= 0) continue;
            throw new RuntimeException("Word(s) appear in both spelling.txt and prohibit.txt - this doesn't make sense: " + intersection);
        }
        if (Languages.get().size() > 5 && totalProhibited == 0) {
            throw new RuntimeException("No prohibited words at all for " + Languages.get().size() + " languages - is there a bug in this test?!");
        }
    }
}

