/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dictionary;

import com.hankcs.hanlp.corpus.io.IOUtil;
import com.hankcs.hanlp.utility.Predefine;
import java.io.BufferedReader;
import java.io.InputStreamReader;

public abstract class TransformMatrix {
    public int[] states;
    public double[] start_probability;
    public double[][] transititon_probability;
    protected int ordinaryMax;
    int[][] matrix;
    int[] total;
    int totalFrequency;

    public boolean load(String path) {
        try {
            int i;
            int j;
            int i2;
            BufferedReader br = new BufferedReader(new InputStreamReader(IOUtil.newInputStream(path), "UTF-8"));
            String line = br.readLine();
            String[] _param = line.split(",");
            String[] labels = new String[_param.length - 1];
            System.arraycopy(_param, 1, labels, 0, labels.length);
            int[] ordinaryArray = new int[labels.length];
            this.ordinaryMax = 0;
            for (i2 = 0; i2 < ordinaryArray.length; ++i2) {
                ordinaryArray[i2] = this.ordinal(labels[i2]);
                this.ordinaryMax = Math.max(this.ordinaryMax, ordinaryArray[i2]);
            }
            ++this.ordinaryMax;
            this.matrix = new int[this.ordinaryMax][this.ordinaryMax];
            for (i2 = 0; i2 < this.ordinaryMax; ++i2) {
                for (int j2 = 0; j2 < this.ordinaryMax; ++j2) {
                    this.matrix[i2][j2] = 0;
                }
            }
            while ((line = br.readLine()) != null) {
                String[] paramArray = line.split(",");
                int currentOrdinary = this.ordinal(paramArray[0]);
                for (int i3 = 0; i3 < ordinaryArray.length; ++i3) {
                    this.matrix[currentOrdinary][ordinaryArray[i3]] = Integer.valueOf(paramArray[1 + i3]);
                }
            }
            br.close();
            this.total = new int[this.ordinaryMax];
            for (j = 0; j < this.ordinaryMax; ++j) {
                this.total[j] = 0;
                for (i = 0; i < this.ordinaryMax; ++i) {
                    int n = j;
                    this.total[n] = this.total[n] + this.matrix[j][i];
                }
            }
            for (j = 0; j < this.ordinaryMax; ++j) {
                if (this.total[j] != 0) continue;
                for (i = 0; i < this.ordinaryMax; ++i) {
                    int n = j;
                    this.total[n] = this.total[n] + this.matrix[i][j];
                }
            }
            for (j = 0; j < this.ordinaryMax; ++j) {
                this.totalFrequency += this.total[j];
            }
            this.states = ordinaryArray;
            this.start_probability = new double[this.ordinaryMax];
            for (int s : this.states) {
                double frequency = (double)this.total[s] + 1.0E-8;
                this.start_probability[s] = -Math.log(frequency / (double)this.totalFrequency);
            }
            this.transititon_probability = new double[this.ordinaryMax][this.ordinaryMax];
            for (int from : this.states) {
                for (int to : this.states) {
                    double frequency = (double)this.matrix[from][to] + 1.0E-8;
                    this.transititon_probability[from][to] = -Math.log(frequency / (double)this.total[from]);
                }
            }
        }
        catch (Exception e) {
            Predefine.logger.warning("\u8bfb\u53d6" + path + "\u5931\u8d25" + e);
            return false;
        }
        return true;
    }

    public void extend(int ordinaryMax) {
        this.ordinaryMax = ordinaryMax;
        double[][] n_transititon_probability = new double[ordinaryMax][ordinaryMax];
        for (int i = 0; i < this.transititon_probability.length; ++i) {
            System.arraycopy(this.transititon_probability[i], 0, n_transititon_probability[i], 0, this.transititon_probability.length);
        }
        this.transititon_probability = n_transititon_probability;
        int[] n_total = new int[ordinaryMax];
        System.arraycopy(this.total, 0, n_total, 0, this.total.length);
        this.total = n_total;
        double[] n_start_probability = new double[ordinaryMax];
        System.arraycopy(this.start_probability, 0, n_start_probability, 0, this.start_probability.length);
        this.start_probability = n_start_probability;
        int[][] n_matrix = new int[ordinaryMax][ordinaryMax];
        for (int i = 0; i < this.matrix.length; ++i) {
            System.arraycopy(this.matrix[i], 0, n_matrix[i], 0, this.matrix.length);
        }
        this.matrix = n_matrix;
    }

    public abstract int ordinal(String var1);

    public int getTotalFrequency(int ordinal) {
        return this.total[ordinal];
    }
}

