/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.File;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.languagetool.language.FastText;

public class FastTextTest2 {
    private static final List<String> languages = Arrays.asList("en", "es", "de", "fr");
    private static final List<Map.Entry<String, String>> TESTED_ENTRIES = Arrays.asList(new AbstractMap.SimpleImmutableEntry<String, String>("en", "This is an English text."), new AbstractMap.SimpleImmutableEntry<String, String>("de", "Dies ist ein deutscher Text."));
    private static final int THREAD_COUNT = 11;
    private FastText instance;

    @Before
    public void setUp() throws IOException {
        this.instance = new FastText(new File("lid.176.bin"), new File("fasttext"));
    }

    @After
    public void tearDown() {
        this.instance.destroy();
        this.instance = null;
    }

    private Runnable checkLanguage(String text, String expectedLang) {
        return () -> {
            try {
                while (true) {
                    Map detected = this.instance.runFasttext(text, languages);
                    System.out.printf("Detected '%s' as %s%n", text, detected);
                    Map.Entry highest = detected.entrySet().stream().max(Map.Entry.comparingByValue()).get();
                    Assert.assertEquals((String)"Expected language correctly detected", (Object)expectedLang, highest.getKey());
                    Thread.sleep(1L);
                }
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException(e);
            }
        };
    }

    @Test
    @Ignore(value="unable to reproduce bug")
    public void testConcurrentUse() throws InterruptedException {
        ArrayList<Thread> threads = new ArrayList<Thread>(11);
        for (int i = 0; i < 11; ++i) {
            Map.Entry<String, String> entry = TESTED_ENTRIES.get(i % TESTED_ENTRIES.size());
            Thread t = new Thread(this.checkLanguage(entry.getValue(), entry.getKey()), "fasttext-test-" + i);
            threads.add(t);
            System.out.printf("Started thread %d%n", i);
            t.start();
        }
        for (Thread t : threads) {
            t.join();
        }
    }
}

