/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;
import org.languagetool.AnalyzedSentence;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.language.Demo;
import org.languagetool.rules.FakeRule;
import org.languagetool.rules.RemoteRule;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;

public class RemoteRuleOffsetsFixTest {
    private List<Integer> printShifts(String text) {
        int[] shifts = RemoteRule.computeOffsetShifts((String)text);
        for (int i = 0; i < text.length(); ++i) {
        }
        return Arrays.stream(shifts).boxed().collect(Collectors.toList());
    }

    @Test
    public void testShiftCalculation() {
        Assert.assertEquals(Arrays.asList(0, 2, 3, 4, 5, 6), this.printShifts("\ud83d\ude01foo"));
        Assert.assertEquals(Arrays.asList(0, 1, 2, 3, 4, 6, 7, 8, 9, 10, 11), this.printShifts("foo \ud83d\ude01 bar"));
        Assert.assertEquals(Arrays.asList(0, 2, 3, 4, 5, 6, 7, 9, 10, 11, 12, 13, 14, 15), this.printShifts("\ud83d\ude01 foo \ud83d\ude01 bar"));
        Assert.assertEquals((String)"1 code point, length 2 / 1", Arrays.asList(0, 2, 3), this.printShifts("\ud83d\udc6a"));
        Assert.assertEquals((String)"1 code point for each part, length 4 / 2, displayed as 1", Arrays.asList(0, 2, 4, 5, 6), this.printShifts("\ud83d\udc4d\ud83c\udffc"));
        Assert.assertEquals((String)"normal text", Arrays.asList(0, 1), this.printShifts("a"));
    }

    private void testMatch(String text, int from, int to, int fixedFrom, int fixedTo) throws IOException {
        JLanguageTool lt = new JLanguageTool((Language)new Demo());
        AnalyzedSentence s = lt.getAnalyzedSentence(text);
        FakeRule r = new FakeRule();
        List<RuleMatch> matches = Collections.singletonList(new RuleMatch((Rule)r, s, from, to, "test match"));
        RemoteRule.fixMatchOffsets((AnalyzedSentence)s, matches);
        Assert.assertEquals((long)fixedFrom, (long)matches.get(0).getFromPos());
        Assert.assertEquals((long)fixedTo, (long)matches.get(0).getToPos());
    }

    @Test
    public void testMatches() throws IOException {
        JLanguageTool lt = new JLanguageTool((Language)new Demo());
        AnalyzedSentence s = lt.getAnalyzedSentence("\ud83d\ude01foo bar");
        FakeRule r = new FakeRule();
        List<RuleMatch> matches = Arrays.asList(new RuleMatch((Rule)r, s, 0, 1, "Emoji"), new RuleMatch((Rule)r, s, 1, 4, "foo"));
        RemoteRule.fixMatchOffsets((AnalyzedSentence)s, matches);
        Assert.assertEquals((long)matches.get(0).getFromPos(), (long)0L);
        Assert.assertEquals((long)matches.get(0).getToPos(), (long)2L);
        Assert.assertEquals((long)matches.get(1).getFromPos(), (long)2L);
        Assert.assertEquals((long)matches.get(1).getToPos(), (long)5L);
        this.testMatch("\ud83d\ude01foo bar", 0, 1, 0, 2);
        this.testMatch("\ud83d\ude01foo bar", 1, 4, 2, 5);
        this.testMatch("\ud83d\udc6a", 0, 1, 0, 2);
        this.testMatch("\ud83d\udc4d\ud83c\udffc", 0, 2, 0, 4);
    }

    @Test
    public void testException() throws Exception {
        JLanguageTool lt = new JLanguageTool((Language)new Demo());
        AnalyzedSentence s = lt.getAnalyzedSentence("abondoned");
        FakeRule r = new FakeRule();
        List<RuleMatch> matches = Arrays.asList(new RuleMatch((Rule)r, s, 0, 9, "Match"));
        this.printShifts("abondoned");
        RemoteRule.fixMatchOffsets((AnalyzedSentence)s, matches);
    }
}

