/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.Experimental;
import org.languagetool.Language;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.Match;
import org.languagetool.rules.patterns.PatternRuleId;
import org.languagetool.rules.patterns.PatternToken;
import org.languagetool.rules.patterns.RuleFilter;
import org.languagetool.tagging.disambiguation.rules.DisambiguationPatternRule;

public abstract class AbstractPatternRule
extends Rule {
    protected final Language language;
    protected final List<PatternToken> patternTokens;
    protected final boolean testUnification;
    protected final boolean sentStart;
    protected List<Match> suggestionMatches;
    private boolean adjustSuggestionCase = true;
    protected List<Match> suggestionMatchesOutMsg;
    protected List<DisambiguationPatternRule> antiPatterns;
    protected String subId;
    protected int startPositionCorrection;
    protected int endPositionCorrection;
    protected String suggestionsOutMsg;
    protected RuleFilter filter;
    protected String filterArgs;
    protected String message;
    protected String sourceFile = null;
    protected RuleMatch.Type type = null;
    private final String id;
    private final String description;
    private final boolean getUnified;
    private final boolean groupsOrUnification;

    protected AbstractPatternRule(String id, String description, Language language) {
        this(id, description, language, null, false);
    }

    public AbstractPatternRule(String id, String description, Language language, List<PatternToken> patternTokens, boolean getUnified, String message) {
        this(id, description, language, patternTokens, getUnified);
        this.message = message;
    }

    public AbstractPatternRule(String id, String description, Language language, List<PatternToken> patternTokens, boolean getUnified) {
        this.id = Objects.requireNonNull(id, "id cannot be null");
        this.description = Objects.requireNonNull(description, "description ('name' in XML) cannot be null");
        this.language = Objects.requireNonNull(language, "language cannot be null");
        this.getUnified = getUnified;
        if (patternTokens != null) {
            this.patternTokens = new ArrayList<PatternToken>(patternTokens);
            this.testUnification = this.initUnifier();
            boolean bl = this.sentStart = this.patternTokens.size() > 0 && this.patternTokens.get(0).isSentenceStart();
            if (!this.testUnification) {
                boolean found = false;
                for (PatternToken elem : this.patternTokens) {
                    if (!elem.hasAndGroup()) continue;
                    found = true;
                    break;
                }
                this.groupsOrUnification = found;
            } else {
                this.groupsOrUnification = true;
            }
        } else {
            this.patternTokens = null;
            this.groupsOrUnification = false;
            this.sentStart = false;
            this.testUnification = false;
        }
    }

    @Override
    public boolean supportsLanguage(Language language) {
        return language.equalsConsiderVariantsIfSpecified(this.language);
    }

    private boolean initUnifier() {
        for (PatternToken pToken : this.patternTokens) {
            if (!pToken.isUnified()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.id + "[" + this.subId + "]" + (this.sourceFile != null ? "@" + this.sourceFile : "") + ":" + this.patternTokens + ":" + this.description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    @Nullable
    public String getSourceFile() {
        return this.sourceFile;
    }

    void setSourceFile(String sourceFile) {
        this.sourceFile = sourceFile;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        return null;
    }

    public final Language getLanguage() {
        return this.language;
    }

    public final void setStartPositionCorrection(int startPositionCorrection) {
        this.startPositionCorrection = startPositionCorrection;
    }

    public final int getStartPositionCorrection() {
        return this.startPositionCorrection;
    }

    public final void setEndPositionCorrection(int endPositionCorrection) {
        this.endPositionCorrection = endPositionCorrection;
    }

    public final int getEndPositionCorrection() {
        return this.endPositionCorrection;
    }

    @Override
    public String getFullId() {
        if (this.subId != null) {
            return this.id + "[" + this.subId + "]";
        }
        return this.id;
    }

    public PatternRuleId getPatternRuleId() {
        if (this.subId != null) {
            return new PatternRuleId(this.id, this.subId);
        }
        return new PatternRuleId(this.id);
    }

    @Override
    public final String getSubId() {
        return this.subId;
    }

    public final void setSubId(String subId) {
        this.subId = subId;
    }

    public boolean isGroupsOrUnification() {
        return this.groupsOrUnification;
    }

    public boolean isGetUnified() {
        return this.getUnified;
    }

    public boolean isSentStart() {
        return this.sentStart;
    }

    public boolean isTestUnification() {
        return this.testUnification;
    }

    public List<PatternToken> getPatternTokens() {
        return this.patternTokens;
    }

    public final void addSuggestionMatch(Match m) {
        if (this.suggestionMatches == null) {
            this.suggestionMatches = new ArrayList<Match>(0);
        }
        this.suggestionMatches.add(m);
    }

    public final void addSuggestionMatchOutMsg(Match m) {
        if (this.suggestionMatchesOutMsg == null) {
            this.suggestionMatchesOutMsg = new ArrayList<Match>(0);
        }
        this.suggestionMatchesOutMsg.add(m);
    }

    List<Match> getSuggestionMatches() {
        return this.suggestionMatches == null ? Collections.emptyList() : this.suggestionMatches;
    }

    List<Match> getSuggestionMatchesOutMsg() {
        return this.suggestionMatchesOutMsg == null ? Collections.emptyList() : this.suggestionMatchesOutMsg;
    }

    @NotNull
    public final String getSuggestionsOutMsg() {
        return this.suggestionsOutMsg;
    }

    public final String getMessage() {
        return this.message;
    }

    public final void setMessage(String message) {
        this.message = message;
    }

    public void setFilter(RuleFilter filter) {
        this.filter = filter;
    }

    @Nullable
    public RuleFilter getFilter() {
        return this.filter;
    }

    public void setFilterArguments(String filterArgs) {
        this.filterArgs = filterArgs;
    }

    @Nullable
    public String getFilterArguments() {
        return this.filterArgs;
    }

    public void setAntiPatterns(List<DisambiguationPatternRule> antiPatterns) {
        if (this.antiPatterns == null) {
            this.antiPatterns = new ArrayList<DisambiguationPatternRule>(0);
        }
        this.antiPatterns.addAll(antiPatterns);
    }

    @Override
    public final List<DisambiguationPatternRule> getAntiPatterns() {
        return this.antiPatterns == null ? Collections.emptyList() : Collections.unmodifiableList(this.antiPatterns);
    }

    String getShortMessage() {
        return "";
    }

    @Nullable
    @Experimental
    public RuleMatch.Type getType() {
        if (this.type == null) {
            ITSIssueType issueType = this.getLocQualityIssueType();
            if (issueType == ITSIssueType.Style || issueType == ITSIssueType.LocaleViolation || issueType == ITSIssueType.Register) {
                return RuleMatch.Type.Hint;
            }
            return RuleMatch.Type.Other;
        }
        return this.type;
    }

    @Experimental
    public void setType(RuleMatch.Type type) {
        this.type = type;
    }

    @Experimental
    public boolean isAdjustSuggestionCase() {
        return this.adjustSuggestionCase;
    }

    @Experimental
    public void setAdjustSuggestionCase(boolean adjustSuggestionCase) {
        this.adjustSuggestionCase = adjustSuggestionCase;
    }
}

