/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.ResourceBundle;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.SuggestionWithMessage;
import org.languagetool.tools.StringTools;
import org.languagetool.tools.Tools;

public abstract class AbstractSimpleReplaceRule2
extends Rule {
    private final Language language;
    protected boolean subRuleSpecificIds;
    private static final LoadingCache<PathsAndLanguage, List<Map<String, SuggestionWithMessage>>> cache = CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<PathsAndLanguage, List<Map<String, SuggestionWithMessage>>>(){

        public List<Map<String, SuggestionWithMessage>> load(@NotNull PathsAndLanguage lap) throws IOException {
            ArrayList<Map<String, SuggestionWithMessage>> maps = new ArrayList<Map<String, SuggestionWithMessage>>();
            for (String path : lap.paths) {
                List l = AbstractSimpleReplaceRule2.loadWords(path, lap.lang, lap.caseSensitive, lap.checkingCase);
                maps.addAll(l);
            }
            return maps;
        }
    });

    public abstract List<String> getFileNames();

    @Override
    public abstract String getId();

    @Override
    public abstract String getDescription();

    public abstract String getShort();

    public abstract String getMessage();

    public String getSuggestionsSeparator() {
        return ", ";
    }

    public abstract Locale getLocale();

    public AbstractSimpleReplaceRule2(ResourceBundle messages, Language language) {
        super(messages);
        this.language = Objects.requireNonNull(language);
        super.setCategory(Categories.MISC.getCategory(messages));
    }

    public void useSubRuleSpecificIds() {
        this.subRuleSpecificIds = true;
    }

    public CaseSensitivy getCaseSensitivy() {
        return CaseSensitivy.CI;
    }

    public List<Map<String, SuggestionWithMessage>> getWrongWords(boolean checkingCase) {
        try {
            boolean caseSen = this.getCaseSensitivy() == CaseSensitivy.CS || this.getCaseSensitivy() == CaseSensitivy.CSExceptAtSentenceStart;
            return (List)cache.get((Object)new PathsAndLanguage(this.getFileNames(), this.language, caseSen, checkingCase));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<Map<String, SuggestionWithMessage>> loadWords(String filename, Language lang, boolean caseSensitive, boolean checkingCase) throws IOException {
        ArrayList list = new ArrayList();
        InputStream stream = JLanguageTool.getDataBroker().getFromRulesDirAsStream(filename);
        InputStreamReader isr = new InputStreamReader(stream, StandardCharsets.UTF_8);
        Object object = null;
        try (BufferedReader bufferedReader = new BufferedReader(isr);){
            String line;
            int msgCount = 0;
            int lineCount = 0;
            while ((line = bufferedReader.readLine()) != null) {
                String[] wrongForms;
                String msg;
                String[] parts;
                if ((line = line.trim()).isEmpty() || line.charAt(0) == '#') continue;
                if (!line.contains("  ") || !lang.getShortCode().equals("ar")) {
                    // empty if block
                }
                if (checkingCase) {
                    parts = line.split("=");
                    line = parts[0].toLowerCase().trim() + "=" + parts[0].trim();
                    if (parts.length == 2) {
                        line = line + "\t" + parts[1].trim();
                    }
                }
                parts = line.split("\t");
                String confPair = parts[0];
                ++lineCount;
                if (parts.length == 1) {
                    msg = null;
                } else if (parts.length == 2) {
                    msg = parts[1];
                    ++msgCount;
                } else {
                    throw new IOException("Format error in file " + JLanguageTool.getDataBroker().getFromRulesDirAsUrl(filename) + ". Expected at most 1 '=' character and at most 1 tab character. Line: " + line);
                }
                String[] confPairParts = confPair.split("=");
                for (String wrongForm : wrongForms = confPairParts[0].split("\\|")) {
                    String searchToken;
                    int wordCount = AbstractSimpleReplaceRule2.getWordCount(lang, wrongForm);
                    for (int i = list.size(); i < wordCount; ++i) {
                        list.add(new HashMap());
                    }
                    String string = searchToken = caseSensitive ? wrongForm : wrongForm.toLowerCase();
                    if (!checkingCase && searchToken.equals(confPairParts[1])) {
                        throw new IOException("Format error in file " + JLanguageTool.getDataBroker().getFromRulesDirAsUrl(filename) + ". Found same word on left and right side of '='. Line: " + line);
                    }
                    SuggestionWithMessage sugg = new SuggestionWithMessage(confPairParts[1], msg);
                    ((Map)list.get(wordCount - 1)).put(searchToken, sugg);
                }
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (isr != null) {
                if (object != null) {
                    try {
                        isr.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    isr.close();
                }
            }
        }
        ArrayList result = new ArrayList();
        for (Map map : list) {
            result.add(Collections.unmodifiableMap(map));
        }
        return Collections.unmodifiableList(result);
    }

    private static int getWordCount(Language lang, String wrongForm) {
        int wordCount = 0;
        List<String> tokens = lang.getWordTokenizer().tokenize(wrongForm);
        for (String token : tokens) {
            if (StringTools.isWhitespace(token)) continue;
            ++wordCount;
        }
        return wordCount;
    }

    protected void addToQueue(AnalyzedTokenReadings token, Queue<AnalyzedTokenReadings> prevTokens) {
        boolean inserted = prevTokens.offer(token);
        if (!inserted) {
            prevTokens.poll();
            prevTokens.offer(token);
        }
    }

    public String getDescription(String details) {
        return null;
    }

    @Override
    public RuleMatch[] match(AnalyzedSentence sentence) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
        List<Map<String, SuggestionWithMessage>> wrongWords = this.getWrongWords(false);
        if (wrongWords.size() == 0) {
            return this.toRuleMatchArray(ruleMatches);
        }
        ArrayBlockingQueue<AnalyzedTokenReadings> prevTokens = new ArrayBlockingQueue<AnalyzedTokenReadings>(wrongWords.size());
        block0: for (int i = 1; i < tokens.length; ++i) {
            this.addToQueue(tokens[i], prevTokens);
            StringBuilder sb = new StringBuilder();
            ArrayList<String> variants = new ArrayList<String>();
            List<AnalyzedTokenReadings> prevTokensList = Arrays.asList(prevTokens.toArray(new AnalyzedTokenReadings[0]));
            for (int j = prevTokensList.size() - 1; j >= 0; --j) {
                if (j != prevTokensList.size() - 1 && prevTokensList.get(j + 1).isWhitespaceBefore()) {
                    sb.insert(0, " ");
                }
                sb.insert(0, prevTokensList.get(j).getToken());
                variants.add(0, sb.toString());
            }
            if (this.isTokenException(tokens[i])) continue;
            int len = variants.size();
            for (int j = 0; j < len; ++j) {
                RuleMatch lastRuleMatch;
                SuggestionWithMessage crtMatch;
                String crt = (String)variants.get(j);
                int crtWordCount = len - j;
                if (this.getCaseSensitivy() == CaseSensitivy.CSExceptAtSentenceStart && i - crtWordCount == 0) {
                    crtMatch = wrongWords.get(crtWordCount - 1).get(crt.toLowerCase(this.getLocale()));
                } else {
                    boolean caseSen = this.getCaseSensitivy() == CaseSensitivy.CS || this.getCaseSensitivy() == CaseSensitivy.CSExceptAtSentenceStart;
                    SuggestionWithMessage suggestionWithMessage = crtMatch = caseSen ? wrongWords.get(crtWordCount - 1).get(crt) : wrongWords.get(crtWordCount - 1).get(crt.toLowerCase(this.getLocale()));
                }
                if (crtMatch == null) continue;
                List<String> replacements = Arrays.asList(crtMatch.getSuggestion().split("\\|"));
                String msgSuggestions = "";
                for (int k = 0; k < replacements.size(); ++k) {
                    if (k > 0) {
                        msgSuggestions = msgSuggestions + (k == replacements.size() - 1 ? this.getSuggestionsSeparator() : ", ");
                    }
                    msgSuggestions = msgSuggestions + "<suggestion>" + replacements.get(k) + "</suggestion>";
                }
                String msg = this.getMessage().replaceFirst("\\$match", crt).replaceFirst("\\$suggestions", msgSuggestions);
                if (crtMatch.getMessage() != null && !crtMatch.getMessage().startsWith("http://") && !crtMatch.getMessage().startsWith("https://")) {
                    msg = crtMatch.getMessage();
                }
                int startPos = prevTokensList.get(len - crtWordCount).getStartPos();
                int endPos = prevTokensList.get(len - 1).getEndPos();
                RuleMatch ruleMatch = new RuleMatch(this, sentence, startPos, endPos, msg, this.getShort());
                if (crtMatch.getMessage() != null && (crtMatch.getMessage().startsWith("http://") || crtMatch.getMessage().startsWith("https://"))) {
                    ruleMatch.setUrl(Tools.getUrl(crtMatch.getMessage()));
                }
                if (this.subRuleSpecificIds) {
                    ruleMatch.setSpecificRuleId(StringTools.toId(this.getId() + "_" + crt));
                }
                if ((this.getCaseSensitivy() != CaseSensitivy.CS || this.getCaseSensitivy() == CaseSensitivy.CSExceptAtSentenceStart) && StringTools.startsWithUppercase(crt)) {
                    for (int k = 0; k < replacements.size(); ++k) {
                        replacements.set(k, StringTools.uppercaseFirstChar(replacements.get(k)));
                    }
                }
                ruleMatch.setSuggestedReplacements(replacements);
                if (this.isException(sentence.getText().substring(startPos, endPos))) continue block0;
                if (ruleMatches.size() > 0 && (lastRuleMatch = (RuleMatch)ruleMatches.get(ruleMatches.size() - 1)).getFromPos() == ruleMatch.getFromPos() && lastRuleMatch.getToPos() < ruleMatch.getToPos()) {
                    ruleMatches.remove(ruleMatches.size() - 1);
                }
                ruleMatches.add(ruleMatch);
                continue block0;
            }
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    protected boolean isException(String matchedText) {
        return false;
    }

    protected boolean isTokenException(AnalyzedTokenReadings atr) {
        return false;
    }

    static class PathsAndLanguage {
        final List<String> paths;
        final Language lang;
        final boolean caseSensitive;
        final boolean checkingCase;

        PathsAndLanguage(List<String> fileNames, Language language, boolean caseSensitive, boolean checkingCase) {
            this.paths = Objects.requireNonNull(fileNames);
            this.lang = Objects.requireNonNull(language);
            this.caseSensitive = caseSensitive;
            this.checkingCase = checkingCase;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PathsAndLanguage that = (PathsAndLanguage)o;
            return this.paths.equals(that.paths) && this.lang.equals(that.lang) && this.caseSensitive == that.caseSensitive;
        }

        public int hashCode() {
            return Objects.hash(this.paths, this.lang, this.caseSensitive);
        }
    }

    public static enum CaseSensitivy {
        CS,
        CI,
        CSExceptAtSentenceStart;

    }
}

