/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.annotations.VisibleForTesting;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.JsonUtil;
import io.grpc.internal.PickFirstLeafLoadBalancer;
import io.grpc.internal.PickFirstLoadBalancer;
import java.util.Map;

public final class PickFirstLoadBalancerProvider
extends LoadBalancerProvider {
    public static final String GRPC_PF_USE_HAPPY_EYEBALLS = "GRPC_PF_USE_HAPPY_EYEBALLS";
    private static final String SHUFFLE_ADDRESS_LIST_KEY = "shuffleAddressList";
    private static boolean enableNewPickFirst = GrpcUtil.getFlag("GRPC_EXPERIMENTAL_ENABLE_NEW_PICK_FIRST", true);

    public static boolean isEnabledHappyEyeballs() {
        return GrpcUtil.getFlag(GRPC_PF_USE_HAPPY_EYEBALLS, false);
    }

    public boolean isAvailable() {
        return true;
    }

    public int getPriority() {
        return 5;
    }

    public String getPolicyName() {
        return "pick_first";
    }

    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        if (enableNewPickFirst) {
            return new PickFirstLeafLoadBalancer(helper);
        }
        return new PickFirstLoadBalancer(helper);
    }

    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawLbPolicyConfig) {
        try {
            Object config = PickFirstLoadBalancerProvider.getLbPolicyConfig(rawLbPolicyConfig);
            return NameResolver.ConfigOrError.fromConfig((Object)config);
        }
        catch (RuntimeException e) {
            return NameResolver.ConfigOrError.fromError((Status)Status.UNAVAILABLE.withCause((Throwable)e).withDescription("Failed parsing configuration for " + this.getPolicyName()));
        }
    }

    private static Object getLbPolicyConfig(Map<String, ?> rawLbPolicyConfig) {
        Boolean shuffleAddressList = JsonUtil.getBoolean(rawLbPolicyConfig, SHUFFLE_ADDRESS_LIST_KEY);
        if (enableNewPickFirst) {
            return new PickFirstLeafLoadBalancer.PickFirstLeafLoadBalancerConfig(shuffleAddressList);
        }
        return new PickFirstLoadBalancer.PickFirstLoadBalancerConfig(shuffleAddressList);
    }

    @VisibleForTesting
    public static boolean isEnabledNewPickFirst() {
        return enableNewPickFirst;
    }
}

