#import <Cocoa/Cocoa.h>


#define REMIX_RATING_COUNT 7

@interface SPRemixKwedOrgController : NSObject
{
	BOOL databaseAvailable;
	NSMutableDictionary* remixKwedOrgDatabase;
	NSMutableData* databaseDownloadData;
	NSURLConnection* databaseDownloadConnection;
	NSMutableArray* foundRemixes;
	NSWindow* ownerWindow;
	NSImage* ratingImages[REMIX_RATING_COUNT];
	
	IBOutlet NSPanel* remixSelectionPanel;
	IBOutlet NSTextField* remixSelectionCaption;
	IBOutlet NSTableView* remixTableView;
}

- (void) acquireDatabase;
- (void) setOwnerWindow:(NSWindow*)owner;
- (void) findRemixesForHvscPath:(NSString*)path withTitle:(NSString*)title;

- (IBAction) cancelRemixSheet:(id)sender;
- (IBAction) confirmRemixSheet:(id)sender;
- (IBAction) showRemix64Page:(id)sender;

@end


@interface SPRemixKwedOrgDatabaseEntry : NSObject
{
	NSInteger identifier;
	NSString* hvscPath;
	NSInteger subtuneIndex;
	NSString* title;
	NSString* arranger;
	NSInteger rating;
}

@property (assign) NSInteger identifier;
@property (assign) NSString* hvscPath;
@property (assign) NSInteger subtuneIndex;
@property (assign) NSString* title;
@property (assign) NSString* arranger;
@property (assign) NSInteger rating;

@end

