#import "SPInfoContainerView.h"
#import "SPTuneInfoView.h"
#import "SPColorProvider.h"
#import "SPPlayerWindow.h"
#import "PlayerLibSidplay.h"
#import "SPPreferencesController.h"


@implementation SPTuneInfoView

// ----------------------------------------------------------------------------
- (void) awakeFromNib
// ----------------------------------------------------------------------------
{
	[super awakeFromNib];

	index = TUNEINFO_CONTAINER_INDEX;
	height = 158.0f;
	[self setCollapsed:gPreferences.mTuneInfoCollapsed];
	
	[container addInfoView:self atIndex:index];
}

@end


#pragma mark -
@implementation SPTuneInfoContentView

#define TUNE_INFO_ITEMS 10

// ----------------------------------------------------------------------------
- (id)initWithFrame:(NSRect)frame
// ----------------------------------------------------------------------------
{
    self = [super initWithFrame:frame];
    if (self)
	{
		tuneInfoHeaders = [NSMutableArray arrayWithCapacity:TUNE_INFO_ITEMS];
		tuneInfoStrings = [NSMutableArray arrayWithCapacity:TUNE_INFO_ITEMS];
		
		player = NULL;
	}
    return self;
}


// ----------------------------------------------------------------------------
- (void) awakeFromNib
// ----------------------------------------------------------------------------
{
	[tuneInfoHeaders addObject:@"Title"];
	[tuneInfoHeaders addObject:@"Author"];
	[tuneInfoHeaders addObject:@"Released"];
	[tuneInfoHeaders addObject:@"Songs"];
	[tuneInfoHeaders addObject:@"Load Address"];
	[tuneInfoHeaders addObject:@"Init Address"];
	[tuneInfoHeaders addObject:@"Play Address"];
	[tuneInfoHeaders addObject:@"Format"];
	[tuneInfoHeaders addObject:@"File size"];
	[tuneInfoHeaders addObject:@"SID Chip"];
	
	for (int i = 0; i < TUNE_INFO_ITEMS; i++)
		[tuneInfoStrings addObject:@""];
	
	[[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(updateTuneInfo:) name:SPTuneChangedNotification object:nil];
	[[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(containerBackgroundChanged:) name:SPInfoContainerBackgroundChangedNotification object:nil];

	[tuneInfoTableView setGridColor:[[SPColorProvider sharedInstance] gridColor]];
	[tuneInfoTableView reloadData];
}


// ----------------------------------------------------------------------------
- (void) updateTuneInfo:(NSNotification *)aNotification
// ----------------------------------------------------------------------------
{
	if (player == NULL)
	{
		SPInfoContainerView* container = [[self enclosingScrollView] documentView];
		player = (PlayerLibSidplay*) [[container ownerWindow] player];
	}
	
	if (player != NULL)
	{
		[tuneInfoStrings removeAllObjects];
		
		if (player->isTuneLoaded() && player->hasTuneInformationStrings())
		{
			[tuneInfoStrings addObject:[NSString stringWithCString:player->getCurrentTitle() encoding:NSISOLatin1StringEncoding]];
			[tuneInfoStrings addObject:[NSString stringWithCString:player->getCurrentAuthor() encoding:NSISOLatin1StringEncoding]];
			[tuneInfoStrings addObject:[NSString stringWithCString:player->getCurrentReleaseInfo() encoding:NSISOLatin1StringEncoding]];
			[tuneInfoStrings addObject:[NSString stringWithFormat:@"%d (default: %d)", player->getSubtuneCount(), player->getDefaultSubtune()]];
			[tuneInfoStrings addObject:[NSString stringWithFormat:@"$%04x", player->getCurrentLoadAddress()]];
			[tuneInfoStrings addObject:[NSString stringWithFormat:@"$%04x", player->getCurrentInitAddress()]];
			[tuneInfoStrings addObject:[NSString stringWithFormat:@"$%04x", player->getCurrentPlayAddress()]];
			[tuneInfoStrings addObject:[NSString stringWithCString:player->getCurrentFormat() encoding:NSISOLatin1StringEncoding]];
			[tuneInfoStrings addObject:[NSString stringWithFormat:@"%d bytes", player->getCurrentFileSize()]];
			[tuneInfoStrings addObject:[NSString stringWithCString:player->getCurrentChipModel() encoding:NSASCIIStringEncoding]];
		}
		else
		{
			for (int i = 0; i < TUNE_INFO_ITEMS; i++)
				[tuneInfoStrings addObject:@""];
		}
		
		[tuneInfoTableView reloadData];
	}
}


// ----------------------------------------------------------------------------
- (void) containerBackgroundChanged:(NSNotification *)aNotification
// ----------------------------------------------------------------------------
{
	[tuneInfoTableView setGridColor:[[SPColorProvider sharedInstance] gridColor]];
}


#pragma mark -
#pragma mark data source methods

// ----------------------------------------------------------------------------
- (int)numberOfRowsInTableView:(NSTableView*)tableView
// ----------------------------------------------------------------------------
{
    return [tuneInfoHeaders count];
}


// ----------------------------------------------------------------------------
- (id)tableView:(NSTableView*)tableView objectValueForTableColumn:(NSTableColumn*)tableColumn row:(int)index
// ----------------------------------------------------------------------------
{
	if ([[tableColumn identifier] isEqualToString:@"header"])
		return [tuneInfoHeaders objectAtIndex:index];
	else if ([[tableColumn identifier] isEqualToString:@"info"])
		return [tuneInfoStrings objectAtIndex:index];
		
	return @"";
}


#pragma mark -
#pragma mark delegate methods

// ----------------------------------------------------------------------------
- (BOOL)tableView:(NSTableView *)aTableView shouldSelectRow:(NSInteger)rowIndex
// ----------------------------------------------------------------------------
{
	return NO;
}

@end
