/*
HMAppKitUtil.m

Author: Makoto Kinoshita

Copyright 2004-2006 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import "HMAppKitUtil.h"

//--------------------------------------------------------------//
#pragma mark -- View operations --
//--------------------------------------------------------------//

NSView* HMCopyView(
        NSView* view)
{
    NSData* data;
    data = [NSArchiver archivedDataWithRootObject:view];
    return [NSUnarchiver unarchiveObjectWithData:data];
}

id HMViewWithClass(
        NSView* view, 
        Class viewClass)
{
    if ([view isKindOfClass:viewClass]) {
        return view;
    }
    
    NSEnumerator*   enumerator;
    NSView*         subview;
    enumerator = [[view subviews] objectEnumerator];
    while (subview = [enumerator nextObject]) {
        id  foundView;
        foundView = HMViewWithClass(subview, viewClass);
        if (foundView) {
            return foundView;
        }
    }
    
    return nil;
}

//--------------------------------------------------------------//
#pragma mark -- Menu operations --
//--------------------------------------------------------------//

NSMenu* HMCopyMenuWithTags(
        NSMenu* menu, 
        NSArray* tags, 
        id target)
{
    // Create menu
    NSMenu* newMenu;
    newMenu = [[NSMenu alloc] init];
    [newMenu autorelease];
    
    // Check menu items
    int i;
    for (i = 0; i < [menu numberOfItems]; i++) {
        // Get menu item
        id<NSMenuItem>  menuItem;
        menuItem = [menu itemAtIndex:i];
        
        // Case of separator item
        if ([menuItem isSeparatorItem]) {
            int numberOfItems;
            numberOfItems = [newMenu numberOfItems];
            
            // If no menu items, do not add separator
            if (numberOfItems == 0) {
                continue;
            }
            
            // If last item is separator, do not add separtor
            id<NSMenuItem>  lastItem;
            lastItem = [newMenu itemAtIndex:numberOfItems - 1];
            if ([lastItem isSeparatorItem]) {
                continue;
            }
            
            [newMenu addItem:[NSMenuItem separatorItem]];
            continue;
        }
        
        // Check tag is conteind
        if ([tags containsObject:[NSNumber numberWithInt:[menuItem tag]]]) {
            // Copy menu item
            NSMenuItem* newMenuItem;
            newMenuItem = [[NSMenuItem alloc] 
                    initWithTitle:[menuItem title] 
                            action:[menuItem action] 
                            keyEquivalent:[menuItem keyEquivalent]];
            [newMenuItem autorelease];
            [newMenuItem setTag:[menuItem tag]];
            [newMenuItem setTarget:target];
            
            [newMenu addItem:newMenuItem];
        }
    }
    
    // Get number of items
    int numberOfItems;
    numberOfItems = [newMenu numberOfItems];
    
    // If no items, return nil
    if (numberOfItems == 0) {
        return nil;
    }
    
    // If last item is separator, remove it
    id<NSMenuItem>  lastItem;
    lastItem = [newMenu itemAtIndex:numberOfItems - 1];
    if ([lastItem isSeparatorItem]) {
        [newMenu removeItemAtIndex:numberOfItems - 1];
    }
    
    return newMenu;
}

NSMenuItem* HMCopyMenuItemWithTag(
        NSMenu* menu, 
        int tag, 
        id target)
{
    // Get menu item
    id<NSMenuItem>  menuItem;
    menuItem = [menu itemWithTag:tag];
    if (!menuItem) {
        return nil;
    }
    
    // Copy menu item
    NSMenuItem* newMenuItem;
    newMenuItem = [[NSMenuItem alloc] 
            initWithTitle:[menuItem title] 
                    action:[menuItem action] 
                    keyEquivalent:[menuItem keyEquivalent]];
    [newMenuItem autorelease];
    [newMenuItem setTag:[menuItem tag]];
    [newMenuItem setTarget:target];
    
    return newMenuItem;
}

void HMInsertMenuItemAfterTag(
        NSMenuItem* menuItem, 
        NSMutableArray* items, 
        int tag)
{
    NSEnumerator*   enumerator;
    NSMenuItem*     item;
    enumerator = [items objectEnumerator];
    while (item = [enumerator nextObject]) {
        if ([item tag] == tag) {
            break;
        }
    }
    
    if (item) {
        [items insertObject:menuItem atIndex:[items indexOfObject:item] + 1];
    }
    else {
        [items addObject:menuItem];
    }
}

void HMRemoveMenuItemWithTag(
        NSMenuItem* menuItem, 
        NSMutableArray* items, 
        int tag)
{
    NSEnumerator*   enumerator;
    NSMenuItem*     item;
    enumerator = [items objectEnumerator];
    while (item = [enumerator nextObject]) {
        if ([item tag] == tag) {
            break;
        }
    }
    
    if (item) {
        [items removeObject:item];
    }
}

void HMCopyMenuWithTagsAndMenu(
        NSMenu* srcMenu, 
        NSArray* tags, 
        id target, 
        NSMenu* destMenu)
{
    // Remove all menu of dest menu
    int i;
    for (i = [destMenu numberOfItems] - 1; i >= 0; i--) {
        [destMenu removeItemAtIndex:i];
    }
    
    // Add menu item
    NSEnumerator*   enumerator;
    NSMenuItem*     menuItem;
    enumerator = [[srcMenu itemArray] objectEnumerator];
    while (menuItem = [enumerator nextObject]) {
        // For separator
        if ([menuItem isSeparatorItem]) {
            if ([destMenu numberOfItems] > 0 && 
                ![[destMenu itemAtIndex:[destMenu numberOfItems] - 1] isSeparatorItem])
            {
                [destMenu addItem:[NSMenuItem separatorItem]];
            }
            continue;
        }
        
        // Check tag
        int tag;
        tag = [menuItem tag];
        if ([tags containsObject:[NSNumber numberWithInt:tag]]) {
            // Copy menu item
            NSMenuItem *newMenuItem;
            newMenuItem = [[[NSMenuItem alloc] init] autorelease];
            [newMenuItem setTitle:[menuItem title]];
            [newMenuItem setTarget:target];
            [newMenuItem setAction:[menuItem action]];
            [newMenuItem setKeyEquivalent:[menuItem keyEquivalent]];
            [newMenuItem setKeyEquivalentModifierMask:[menuItem keyEquivalentModifierMask]];
            [newMenuItem setTag:[menuItem tag]];
            [destMenu addItem:newMenuItem];
        }
    }
    
    // Check last item
    if ([destMenu numberOfItems] > 0) {
        NSMenuItem* lastItem;
        lastItem = [destMenu itemAtIndex:[destMenu numberOfItems] - 1];
        if ([lastItem isSeparatorItem]) {
            [destMenu removeItem:lastItem];
        }
    }
}
