/*
HMWebTextRenderer.m

Author: Makoto Kinoshita

Copyright 2004-2006 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import "HMWebKitDefaultKeys.h"
#import "HMWebKitEx.h"
#import "HMWebTextRenderer.h"

static IMP  _drawRun_style_geometry_ = NULL;
static IMP  _drawLineForCharacters_yOffset_width_color_thickness_ = NULL;
static IMP  _drawHighlightForRun_style_geometry_ = NULL;

//--------------------------------------------------------------//
#pragma mark -- Drawing --
//--------------------------------------------------------------//

static id drawRun_style_geometry_(
        id self, SEL _cmd, 
        struct WebCoreTextRun* run, 
        struct WebCoreTextStyle* style, 
        struct WebCoreTextGeometry* geometry)
{
    // Invoke old method
    return _drawRun_style_geometry_(
            self, _cmd, run, style, geometry);
}

static id drawLineForCharacters_yOffset_width_color_thickness_(
        id self, SEL _cmd, NSPoint point, float yOffset, int width, NSColor* color, float thickness)
{
    // Invoke old method
    return _drawLineForCharacters_yOffset_width_color_thickness_(
            self, _cmd, point, yOffset, width, color, thickness);
}

static id drawHighlightForRun_style_geometry_(
        id self, SEL _cmd, 
        struct WebCoreTextRun* run, 
        struct WebCoreTextStyle* style, 
        struct WebCoreTextGeometry* geometry)
{
    NSUserDefaults* defaults;
    defaults = [NSUserDefaults standardUserDefaults];
    
    // Use alt color
#if 0
    if ([defaults boolForKey:HMUseAltHighlightColor]) {
        NSColor*     color;
        color = [NSUnarchiver unarchiveObjectWithData:[defaults dataForKey:HMAltHighlightColor]];
        if (color) {
            style->backgroundColor = [NSColor yellowColor];
        }
        
        [defaults setBool:NO forKey:HMUseAltHighlightColor];
    }
#endif
    
    // Invoke old method
    return _drawHighlightForRun_style_geometry_(
            self, _cmd, run, style, geometry);
}

//--------------------------------------------------------------//
#pragma mark -- Posing --
//--------------------------------------------------------------//

void HMWebTextRendererLoad()
{
    static BOOL _isInitialized = NO;
    if (_isInitialized) {
        return;
    }
    _isInitialized = YES;
    
    // Get WebTextRenderer class
    Class   klass;
    klass = NSClassFromString(@"WebTextRenderer");
    
    // Swap methods
//    HMSwapMethod(klass, @selector(drawRun:style:geometry:), 
//            (IMP)drawRun_style_geometry_, &_drawRun_style_geometry_);
//    HMSwapMethod(klass, @selector(drawLineForCharacters:yOffset:width:color:thickness:), 
//            (IMP)drawLineForCharacters_yOffset_width_color_thickness_, 
//            &_drawLineForCharacters_yOffset_width_color_thickness_);
    HMSwapMethod(klass, @selector(drawHighlightForRun:style:geometry:), 
            (IMP)drawHighlightForRun_style_geometry_, &_drawHighlightForRun_style_geometry_);
}
