/*
SRSourcePref.m

Author: Makoto Kinoshita

Copyright 2004-2006 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import "SRSourcePref.h"

#import "SRPrefDefaultKeys.h"

@interface SRSourcePref (private)
- (NSFont*)_sourceFont;
- (void)_updateFontName;
@end

@implementation SRSourcePref

//--------------------------------------------------------------//
#pragma mark -- Initialize --
//--------------------------------------------------------------//

- (void)awakeFromNib
{
    // Update font name
    [self _updateFontName];
}

//--------------------------------------------------------------//
#pragma mark -- Font management --
//--------------------------------------------------------------//

- (NSFont*)_sourceFont
{
    NSUserDefaults* defaults;
    defaults = [NSUserDefaults standardUserDefaults];
    
    // Get source font
    NSString*   fontName;
    int         fontSize;
    NSFont*     font;
    fontName = [defaults stringForKey:SRSourceFontName];
    fontSize = [defaults integerForKey:SRSourceFontSize];
    font = [NSFont fontWithName:fontName size:fontSize];
    if (!font) {
        font = [NSFont fontWithName:@"Monaco" size:10.0f];
    }
    
    return font;
}

- (void)_updateFontName
{
    // Set source font name and size
    NSFont* font;
    font = [self _sourceFont];
    [[_objectController content] setValue:[NSString stringWithFormat:@"%@ %d", [font fontName], (int)[font pointSize]] 
            forKey:SRSourceFontNameAndSize];
}

//--------------------------------------------------------------//
#pragma mark -- Action --
//--------------------------------------------------------------//

- (void)showFontPanelAction:(id)sender
{
    // Get font
    NSFont* font;
    font = [self _sourceFont];
    
    // Set font font manager
    NSFontManager*  fontMgr;
    fontMgr = [NSFontManager sharedFontManager];
	[fontMgr setSelectedFont:font isMultiple:NO];
    
    // Show font panel
	NSFontPanel*	fontPanel;
	fontPanel = [fontMgr fontPanel:YES];
	if (![fontPanel isVisible]) {
		[fontPanel orderFront:self];
	}
}

- (void)changeFont:(id)sender
{
    NSUserDefaults* defaults;
    defaults = [NSUserDefaults standardUserDefaults];
    
    // Convert font
	NSFont* font;
	NSFont* convertedFont;
	font = [self _sourceFont];
    convertedFont = [sender convertFont:font];
	
    // Set font to default
    [defaults setObject:[convertedFont fontName] forKey:SRSourceFontName];
    [defaults setInteger:(int)[convertedFont pointSize] forKey:SRSourceFontSize];
    
    // Update font name
    [self _updateFontName];
}

@end
