//
//  ClickableText.m
//
//  Created by Ben Haller on Tue Jul 15 2003.
//
//  This code is hereby released into the public domain.  Do with it as you wish.
//

#import "ClickableTextGreen.h"

@implementation ClickableTextGreen

- (void)finishInitialization
{
	[self setBordered:NO];
	[self setBezeled:NO];
	[self setDrawsBackground:NO];
	[self setEditable:NO];
	[self setSelectable:NO];
	[self setEnabled:YES];
	[self setTextColor:[NSColor blackColor]];
}

- (id)initWithCoder:(NSCoder *)decoder
{
	if (self = [super initWithCoder:decoder])
	{
		[self finishInitialization];
	}
	
	return self;
}

- (id)initWithFrame:(NSRect)frame
{
	if (self = [super initWithFrame:frame])
	{
		[self finishInitialization];
	}
	
	return self;
}

- (void)awakeFromNib
{
        [[[self window] contentView] addTrackingRect:[self frame] owner:self userData:nil assumeInside:NO];
}

- (void)mouseDown:(NSEvent *)event
{
	BOOL mouseInside = YES;
	
	beingClicked = YES;
	[self setTextColor:[NSColor colorWithCalibratedRed:0.0 green:0.7 blue:0.0 alpha:1.0]];
	
	while (beingClicked && (event = [[self window] nextEventMatchingMask:(NSLeftMouseUpMask | NSLeftMouseDraggedMask)]))
	{
		NSEventType type = [event type];
		NSPoint location = [event locationInWindow];
		
		location = [self convertPoint:location fromView:nil];
		mouseInside = NSPointInRect(location, [self bounds]);
		
		if (mouseInside)
			[self setTextColor:[NSColor blackColor]];
		else if (beenClicked)
			[self setTextColor:[NSColor blackColor]];
		else
			[self setTextColor:[NSColor blackColor]];
		
		if (type == NSLeftMouseUp)
			beingClicked = NO;
	}
	
	if (mouseInside)
	{
		beenClicked = YES;
		[self setTextColor:[NSColor blackColor]];
		[self sendAction:[self action] to:[self target]];
	}
}

- (void)mouseEntered:(NSEvent *)theEvent
{
    [self setTextColor:[NSColor colorWithCalibratedRed:0.0 green:0.7 blue:0.0 alpha:1.0]];
    return;
}

- (void)mouseExited:(NSEvent *)theEvent
{
    [self setTextColor:[NSColor blackColor]];
    return;
}



@end
