//
//  Tree.m
//  X-MasTree
//
//  Created by John Schilling on 11/8/04.
//  Copyright 2004 John Schilling. All rights reserved.
//

#import "Tree.h"
#import "AppController.h"

/*
#define MIN_BLINK           6
#define MAX_BLINK           12
#define MIN_FADEOFF         2
#define MAX_FADEOFF         6
#define MIN_FADEON          16
#define MAX_FADEON          24
*/

#define MIN_BLINK           2
#define MAX_BLINK           5
#define MIN_FADEOFF         1
#define MAX_FADEOFF         2
#define MIN_FADEON          3
#define MAX_FADEON          6


#define FADE_INCREMENT      0.10

#define DEFAULT_FONT_SIZE   12


@implementation Tree

#pragma mark
#pragma mark INSTANCE METHODS
#pragma mark

- (id)initNewTreeWithSize:(int)treeSize 
                    color:(int)treeColor 
               withShadow:(BOOL)withShadow 
              windowLevel:(int)windowLevel
{
    self = [super init];
    if (!self) return nil;
    
    _hasShadow          = withShadow;
    
    _sizes[0]           = NSMakeSize( 110, 151 );
    _sizes[1]           = NSMakeSize( 150, 206 );
    _sizes[2]           = NSMakeSize( 200, 275 );
    _sizes[3]           = NSMakeSize( 275, 378 );
        
    [self loadTreeForSize:treeSize color:treeColor];
    [self loadBadgers];
    
    NSRect tempRect = NSMakeRect( 0.0, 0.0, [_treeImage size].width, [_treeImage size].height );
    
    _treeWindow = [[ShapedWindow allocWithZone:[self zone]]
                        initWithContentRect:tempRect
                        styleMask:NSBorderlessWindowMask
                        backing:NSBackingStoreBuffered
                        defer:YES];
    [_treeWindow setReleasedWhenClosed: NO];

    ShapedView *treeView = [[ShapedView alloc] initWithFrame:tempRect];
    [_treeWindow setContentView: treeView];
    [treeView release];
    
    [[_treeWindow contentView] setAutoresizingMask: (NSViewHeightSizable | NSViewWidthSizable)];
    [[_treeWindow contentView] setImage: _treeImage];
    [_treeWindow setHasShadow: _hasShadow];
    [self setWindowLevel: windowLevel];
    
    if (![_treeWindow setFrameUsingName:@"TreeWindow"]) {
        [_treeWindow center];
    }
    
    NSFont *font = nil;
    font = [NSFont fontWithName:@"Lucida Grande Bold" size:DEFAULT_FONT_SIZE];
    if (font == nil) font = [NSFont boldSystemFontOfSize:DEFAULT_FONT_SIZE];
    
    _fontAttributes = [[NSMutableDictionary alloc] init];
    [_fontAttributes setObject:font forKey:NSFontAttributeName];
    [_fontAttributes setObject:[NSColor whiteColor] forKey:NSForegroundColorAttributeName];
    
    [self clearStateVariables];
    [self displayTree];
    
    return self;
}

- (void)dealloc
{
    [_fontAttributes release];
    _fontAttributes = nil;
    
    [_treeWindow release];
    _treeWindow = nil;

    [super dealloc];
}










- (void)loadTreeForSize:(int)treeSize color:(int)treeColor
{
    _currentSize = treeSize;
    _treeImage = [NSImage imageNamed:[NSString stringWithFormat:@"Tree%d", treeColor]];
    [_treeImage setScalesWhenResized: YES];
    [_treeImage setSize: _sizes[treeSize]];
    [self loadLightsForSize: treeSize];
    [self loadOrnamentsForSize: treeSize];
    [self loadPopcornAndTinselForSize: treeSize];
    [self loadStarsForSize: treeSize];
    [self loadCustomOrnamentsForSize: treeSize];
    //[self loadBadgers]; only need once, they never change size. do it when initilizing
}

- (void)loadLightsForSize:(int)size
{
    _redLights0     = [self lightsForColor:@"Red" style:0 density:0 size:size];
    _redLights1     = [self lightsForColor:@"Red" style:0 density:1 size:size];
    _greenLights0   = [self lightsForColor:@"Green" style:0 density:0 size:size];
    _greenLights1   = [self lightsForColor:@"Green" style:0 density:1 size:size];
    _blueLights0    = [self lightsForColor:@"Blue" style:0 density:0 size:size];
    _blueLights1    = [self lightsForColor:@"Blue" style:0 density:1 size:size];
    _purpleLights0  = [self lightsForColor:@"Purple" style:0 density:0 size:size];
    _purpleLights1  = [self lightsForColor:@"Purple" style:0 density:1 size:size];
    
    _oldredLights0     = [self lightsForColor:@"Red" style:1 density:0 size:size];
    _oldredLights1     = [self lightsForColor:@"Red" style:1 density:1 size:size];
    _oldgreenLights0   = [self lightsForColor:@"Green" style:1 density:0 size:size];
    _oldgreenLights1   = [self lightsForColor:@"Green" style:1 density:1 size:size];
    _oldblueLights0    = [self lightsForColor:@"Blue" style:1 density:0 size:size];
    _oldblueLights1    = [self lightsForColor:@"Blue" style:1 density:1 size:size];
    _oldpurpleLights0  = [self lightsForColor:@"Purple" style:1 density:0 size:size];
    _oldpurpleLights1  = [self lightsForColor:@"Purple" style:1 density:1 size:size];
}


- (NSImage *)lightsForColor:(NSString *)color style:(int)style density:(int)density size:(int)size
{
    NSString *lightsString;
    if (style == 1) {
        lightsString = [NSString stringWithFormat:@"OldLights%@%d", color, density];
    } else {
        lightsString = [NSString stringWithFormat:@"Lights%@%d", color, density];
    }
    NSImage *lights = [NSImage imageNamed:lightsString];
    [lights setScalesWhenResized: YES];
    [lights setSize: _sizes[size]];
    return lights;
}

- (void)loadOrnamentsForSize:(int)size
{
    _ornamentsRed       = [self ornamentsForColor:@"Red" size:size];
    _ornamentsGreen     = [self ornamentsForColor:@"Green" size:size];
    _ornamentsBlue      = [self ornamentsForColor:@"Blue" size:size];
    _ornamentsPurple    = [self ornamentsForColor:@"Purple" size:size];
}

- (NSImage *)ornamentsForColor:(NSString *)color size:(int)size
{
    NSImage *ornaments = [NSImage imageNamed:[NSString stringWithFormat:@"Ornaments%@", color]];
    [ornaments setScalesWhenResized: YES];
    [ornaments setSize: _sizes[size]];
    return ornaments;
}

- (void)loadPopcornAndTinselForSize:(int)size
{
    _popcorn = [NSImage imageNamed:@"Popcorn"];
    [_popcorn setScalesWhenResized: YES];
    [_popcorn setSize: _sizes[size]];
    
    _tinsel = [NSImage imageNamed:@"Tinsel"];
    [_tinsel setScalesWhenResized: YES];
    [_tinsel setSize: _sizes[size]];
}

- (void)loadStarsForSize:(int)size
{
    _starOff = [NSImage imageNamed:@"Star0"];
    [_starOff setScalesWhenResized: YES];
    [_starOff setSize: _sizes[size]];

    _starOn = [NSImage imageNamed:@"Star1"];
    [_starOn setScalesWhenResized: YES];
    [_starOn setSize: _sizes[size]];
}



- (void)loadBadgers
{
    _badgerRed      = [NSImage imageNamed:@"BadgerRed"];
    _badgerGreen    = [NSImage imageNamed:@"BadgerGreen"];
}

- (void)loadCustomOrnamentsForSize:(int)size
{
    NSImage *cb = [NSImage imageNamed:@"CustomBottom"];
    if (cb != nil) {
        _customBottom = [NSImage imageNamed:@"CustomBottom"];
        [_customBottom setScalesWhenResized: YES];
        [_customBottom setSize: _sizes[size]];
    } else {
        _customBottom = nil;
    }
    NSImage *ct = [NSImage imageNamed:@"CustomTop"];
    if (ct != nil) {
        _customTop = [NSImage imageNamed:@"CustomTop"];
        [_customTop setScalesWhenResized: YES];
        [_customTop setSize: _sizes[size]];
    } else {
        _customTop = nil;
    }
}













#pragma mark
#pragma mark TREE WINDOW METHODS
#pragma mark

- (NSWindow *)treeWindow
{
    return _treeWindow;
}

- (void)setWindowLevel:(int)windowLevel
{
    if (windowLevel == 0) {
        [_treeWindow setLevel: NSNormalWindowLevel];
    } else if (windowLevel == 1) {
        [_treeWindow setLevel: NSFloatingWindowLevel];
    } else if (windowLevel == 2) {
        [_treeWindow setLevel: CGWindowLevelForKey(kCGDesktopWindowLevelKey)];
    } else if (windowLevel == 3) {
        [_treeWindow setLevel: CGWindowLevelForKey(kCGDesktopIconWindowLevelKey)];
    }
}

- (void)setHasShadow:(BOOL)hasShadow
{
    _hasShadow = hasShadow;
    [_treeWindow setHasShadow:_hasShadow];
    [self resetShadow];
}

- (void)resetShadow
{
    if (!_hasShadow) return;
    [self drawTree];
    [_treeWindow invalidateShadow];
    [_treeWindow update];
}

- (void)saveTreeFrame
{
    [_treeWindow saveFrameUsingName:@"TreeWindow"];
}

- (void)displayTree
{
    [_treeWindow makeKeyAndOrderFront:nil];
    [self resetShadow]; //draws tree, too.
}

- (void)updateTreeForSize:(int)treeSize treeColor:(int)treeColor
{
    [self loadTreeForSize:treeSize color:treeColor];
    [[_treeWindow contentView] setImage: _treeImage];
    [self resetShadow];
}




#pragma mark
#pragma mark DRAWIN THE TREE
#pragma mark

- (void)drawTree
{
    NSRect sRect                = NSMakeRect(0.0,0.0,[_treeWindow frame].size.width, [_treeWindow frame].size.height);
    int treeSize                = [SharedAppController treeSize];
    int treeColor               = [SharedAppController treeColor];
    int drawRedLights           = [SharedAppController drawRedLights];
    int drawGreenLights         = [SharedAppController drawGreenLights];
    int drawBlueLights          = [SharedAppController drawBlueLights];
    int drawPurpleLights        = [SharedAppController drawPurpleLights];
    int lightsRedMode           = [SharedAppController lightsRedMode];
    int lightsGreenMode         = [SharedAppController lightsGreenMode];
    int lightsBlueMode          = [SharedAppController lightsBlueMode];
    int lightsPurpleMode        = [SharedAppController lightsPurpleMode];
    BOOL drawRedOrnaments       = [SharedAppController drawRedOrnaments];
    BOOL drawGreenOrnaments     = [SharedAppController drawGreenOrnaments];
    BOOL drawBlueOrnaments      = [SharedAppController drawBlueOrnaments];
    BOOL drawPurpleOrnaments    = [SharedAppController drawPurpleOrnaments];
    BOOL drawTinsel             = [SharedAppController drawTinsel];
    BOOL drawPopcorn            = [SharedAppController drawPopcorn];
    int drawStar                = [SharedAppController drawStar];
    BOOL drawBadger             = [SharedAppController drawBadger];
    BOOL drawCustomObjects      = [SharedAppController drawCustomObjects];
    BOOL oldStyleLights         = [SharedAppController useOldStyleLights];
        
    _starBlinkTicks++;
    if (_starBlinkTicks >= _starBlinkTicksMax) {
        _starBlinkTicks = 0;
        _starBlinkTicksMax = [self randBetween:(float)MIN_BLINK And:(float)MAX_BLINK];
        _starLit = !_starLit;
    }
    
    _lightsRedBlinkTicks++;
    if ( _lightsRedBlinkTicks >= _lightsRedBlinkTicksMax) {
        _lightsRedBlinkTicks = 0;
        _lightsRedBlinkTicksMax = [self randBetween:(float)MIN_BLINK And:(float)MAX_BLINK];
        _lightsRedBlinkOn = !_lightsRedBlinkOn;
    }
    _lightsGreenBlinkTicks++;
    if ( _lightsGreenBlinkTicks >= _lightsGreenBlinkTicksMax) {
        _lightsGreenBlinkTicks = 0;
        _lightsGreenBlinkTicksMax = [self randBetween:(float)MIN_BLINK And:(float)MAX_BLINK];
        _lightsGreenBlinkOn = !_lightsGreenBlinkOn;
    }
    _lightsBlueBlinkTicks++;
    if ( _lightsBlueBlinkTicks >= _lightsBlueBlinkTicksMax) {
        _lightsBlueBlinkTicks = 0;
        _lightsBlueBlinkTicksMax = [self randBetween:(float)MIN_BLINK And:(float)MAX_BLINK];
        _lightsBlueBlinkOn = !_lightsBlueBlinkOn;
    }
    _lightsPurpleBlinkTicks++;
    if ( _lightsPurpleBlinkTicks >= _lightsPurpleBlinkTicksMax) {
        _lightsPurpleBlinkTicks = 0;
        _lightsPurpleBlinkTicksMax = [self randBetween:(float)MIN_BLINK And:(float)MAX_BLINK];
        _lightsPurpleBlinkOn = !_lightsPurpleBlinkOn;
    }
    
    if (_lightsRedFadingUp) {
        if (_lightsRedAlpha < 1.0) {
            _lightsRedAlpha += FADE_INCREMENT;
        } else {
            _lightsRedFadeOnTicks++;
            if (_lightsRedFadeOnTicks >= _lightsRedFadeOnMaxTicks) {
                _lightsRedFadingUp = NO;
                _lightsRedFadeOnTicks = 0;
                _lightsRedFadeOnMaxTicks = [self randBetween:(float)MIN_FADEOFF And:(float)MAX_FADEOFF];
            }
        }
    } else {
        if (_lightsRedAlpha > FADE_INCREMENT) {
            _lightsRedAlpha -= FADE_INCREMENT;
        } else {
            _lightsRedFadeOnTicks++;
            if (_lightsRedFadeOnTicks >= _lightsRedFadeOnMaxTicks) {
                _lightsRedFadingUp = YES;
                _lightsRedFadeOnTicks = 0;
                _lightsRedFadeOnMaxTicks = [self randBetween:(float)MIN_FADEON And:(float)MAX_FADEON];
            }
        }
    }

    if (_lightsGreenFadingUp) {
        if (_lightsGreenAlpha < 1.0) {
            _lightsGreenAlpha += FADE_INCREMENT;
        } else {
            _lightsGreenFadeOnTicks++;
            if (_lightsGreenFadeOnTicks >= _lightsGreenFadeOnMaxTicks) {
                _lightsGreenFadingUp = NO;
                _lightsGreenFadeOnTicks = 0;
                _lightsGreenFadeOnMaxTicks = [self randBetween:(float)MIN_FADEOFF And:(float)MAX_FADEOFF];
            }
        }
    } else {
        if (_lightsGreenAlpha > FADE_INCREMENT) {
            _lightsGreenAlpha -= FADE_INCREMENT;
        } else {
            _lightsGreenFadeOnTicks++;
            if (_lightsGreenFadeOnTicks >= _lightsGreenFadeOnMaxTicks) {
                _lightsGreenFadingUp = YES;
                _lightsGreenFadeOnTicks = 0;
                _lightsGreenFadeOnMaxTicks = [self randBetween:(float)MIN_FADEON And:(float)MAX_FADEON];
            }
        }
    }
    
    if (_lightsBlueFadingUp) {
        if (_lightsBlueAlpha < 1.0) {
            _lightsBlueAlpha += FADE_INCREMENT;
        } else {
            _lightsBlueFadeOnTicks++;
            if (_lightsBlueFadeOnTicks >= _lightsBlueFadeOnMaxTicks) {
                _lightsBlueFadingUp = NO;
                _lightsBlueFadeOnTicks = 0;
                _lightsBlueFadeOnMaxTicks = [self randBetween:(float)MIN_FADEOFF And:(float)MAX_FADEOFF];
            }
        }
    } else {
        if (_lightsBlueAlpha > FADE_INCREMENT) {
            _lightsBlueAlpha -= FADE_INCREMENT;
        } else {
            _lightsBlueFadeOnTicks++;
            if (_lightsBlueFadeOnTicks >= _lightsBlueFadeOnMaxTicks) {
                _lightsBlueFadingUp = YES;
                _lightsBlueFadeOnTicks = 0;
                _lightsBlueFadeOnMaxTicks = [self randBetween:(float)MIN_FADEON And:(float)MAX_FADEON];
            }
        }
    }
    
    if (_lightsPurpleFadingUp) {
        if (_lightsPurpleAlpha < 1.0) {
            _lightsPurpleAlpha += FADE_INCREMENT;
        } else {
            _lightsPurpleFadeOnTicks++;
            if (_lightsPurpleFadeOnTicks >= _lightsPurpleFadeOnMaxTicks) {
                _lightsPurpleFadingUp = NO;
                _lightsPurpleFadeOnTicks = 0;
                _lightsPurpleFadeOnMaxTicks = [self randBetween:(float)MIN_FADEOFF And:(float)MAX_FADEOFF];
            }
        }
    } else {
        if (_lightsPurpleAlpha > FADE_INCREMENT) {
            _lightsPurpleAlpha -= FADE_INCREMENT;
        } else {
            _lightsPurpleFadeOnTicks++;
            if (_lightsPurpleFadeOnTicks >= _lightsPurpleFadeOnMaxTicks) {
                _lightsPurpleFadingUp = YES;
                _lightsPurpleFadeOnTicks = 0;
                _lightsPurpleFadeOnMaxTicks = [self randBetween:(float)MIN_FADEON And:(float)MAX_FADEON];
            }
        }
    }

    [_treeWindow disableFlushWindow];
    [[_treeWindow contentView] lockFocus];

    [[NSColor clearColor] set];
    NSRectFill(sRect);

        /* TREE */
        
        [_treeImage compositeToPoint:NSZeroPoint operation:NSCompositeSourceOver fraction:1.0];
        
        /* ORNAMENTS */
        
        /* Any customs? */
        if (drawCustomObjects) {
            if (_customBottom != nil) [_customBottom compositeToPoint:NSZeroPoint operation:NSCompositeSourceOver fraction:1.0];
        }
        
        if (drawRedOrnaments) {
            [_ornamentsRed compositeToPoint:NSZeroPoint operation:NSCompositeSourceOver fraction:1.0];
        }
        
        if (drawGreenOrnaments) {
            [_ornamentsGreen compositeToPoint:NSZeroPoint operation:NSCompositeSourceOver fraction:1.0];
        }
        
        if (drawBlueOrnaments) {
            [_ornamentsBlue compositeToPoint:NSZeroPoint operation:NSCompositeSourceOver fraction:1.0];
        }
        
        if (drawPurpleOrnaments) {
            [_ornamentsPurple compositeToPoint:NSZeroPoint operation:NSCompositeSourceOver fraction:1.0];
        }
        
        /*
        // Draw above lights. Looks better.
        if (drawPopcorn) {
            [[NSImage imageNamed:[NSString stringWithFormat:@"%@Popcorn", imgPrefix]] 
                compositeToPoint:NSZeroPoint operation:NSCompositeSourceOver fraction:1.0];
        }
        */
        
        /* LIGHTS */
        
        if (drawRedLights != -1) {
            if (lightsRedMode == 0 || (lightsRedMode == 1 && _lightsRedBlinkOn)) {
                if (drawRedLights == 0 && !oldStyleLights) [_redLights0 compositeToPoint:NSZeroPoint operation:NSCompositeSourceOver fraction:1.0];
                if (drawRedLights == 1 && !oldStyleLights) [_redLights1 compositeToPoint:NSZeroPoint operation:NSCompositeSourceOver fraction:1.0];
                if (drawRedLights == 0 && oldStyleLights)  [_oldredLights0 compositeToPoint:NSZeroPoint operation:NSCompositeSourceOver fraction:1.0];
                if (drawRedLights == 1 && oldStyleLights)  [_oldredLights1 compositeToPoint:NSZeroPoint operation:NSCompositeSourceOver fraction:1.0];
            } else if (lightsRedMode == 2) {
                if (drawRedLights == 0 && !oldStyleLights) [_redLights0 compositeToPoint:NSZeroPoint operation:NSCompositeSourceOver fraction:_lightsRedAlpha];
                if (drawRedLights == 1 && !oldStyleLights) [_redLights1 compositeToPoint:NSZeroPoint operation:NSCompositeSourceOver fraction:_lightsRedAlpha];
                if (drawRedLights == 0 && oldStyleLights)  [_oldredLights0 compositeToPoint:NSZeroPoint operation:NSCompositeSourceOver fraction:_lightsRedAlpha];
                if (drawRedLights == 1 && oldStyleLights)  [_oldredLights1 compositeToPoint:NSZeroPoint operation:NSCompositeSourceOver fraction:_lightsRedAlpha];
            }
        }
        
        if (drawGreenLights != -1) {
            if (lightsGreenMode == 0 || (lightsGreenMode == 1 && _lightsGreenBlinkOn)) {
                if (drawGreenLights == 0 && !oldStyleLights) [_greenLights0 compositeToPoint:NSZeroPoint operation:NSCompositeSourceOver fraction:1.0];
                if (drawGreenLights == 1 && !oldStyleLights) [_greenLights1 compositeToPoint:NSZeroPoint operation:NSCompositeSourceOver fraction:1.0];
                if (drawGreenLights == 0 && oldStyleLights)  [_oldgreenLights0 compositeToPoint:NSZeroPoint operation:NSCompositeSourceOver fraction:1.0];
                if (drawGreenLights == 1 && oldStyleLights)  [_oldgreenLights1 compositeToPoint:NSZeroPoint operation:NSCompositeSourceOver fraction:1.0];
            } else if (lightsGreenMode == 2) {
                if (drawGreenLights == 0 && !oldStyleLights) [_greenLights0 compositeToPoint:NSZeroPoint operation:NSCompositeSourceOver fraction:_lightsGreenAlpha];
                if (drawGreenLights == 1 && !oldStyleLights) [_greenLights1 compositeToPoint:NSZeroPoint operation:NSCompositeSourceOver fraction:_lightsGreenAlpha];
                if (drawGreenLights == 0 && oldStyleLights)  [_oldgreenLights0 compositeToPoint:NSZeroPoint operation:NSCompositeSourceOver fraction:_lightsGreenAlpha];
                if (drawGreenLights == 1 && oldStyleLights)  [_oldgreenLights1 compositeToPoint:NSZeroPoint operation:NSCompositeSourceOver fraction:_lightsGreenAlpha];
            }
        }
        
        if (drawBlueLights != -1) {
            if (lightsBlueMode == 0 || (lightsBlueMode == 1 && _lightsBlueBlinkOn)) {
                if (drawBlueLights == 0 && !oldStyleLights) [_blueLights0 compositeToPoint:NSZeroPoint operation:NSCompositeSourceOver fraction:1.0];
                if (drawBlueLights == 1 && !oldStyleLights) [_blueLights1 compositeToPoint:NSZeroPoint operation:NSCompositeSourceOver fraction:1.0];
                if (drawBlueLights == 0 && oldStyleLights)  [_oldblueLights0 compositeToPoint:NSZeroPoint operation:NSCompositeSourceOver fraction:1.0];
                if (drawBlueLights == 1 && oldStyleLights)  [_oldblueLights1 compositeToPoint:NSZeroPoint operation:NSCompositeSourceOver fraction:1.0];
            } else if (lightsBlueMode == 2) {
                if (drawBlueLights == 0 && !oldStyleLights) [_blueLights0 compositeToPoint:NSZeroPoint operation:NSCompositeSourceOver fraction:_lightsBlueAlpha];
                if (drawBlueLights == 1 && !oldStyleLights) [_blueLights1 compositeToPoint:NSZeroPoint operation:NSCompositeSourceOver fraction:_lightsBlueAlpha];
                if (drawBlueLights == 0 && oldStyleLights)  [_oldblueLights0 compositeToPoint:NSZeroPoint operation:NSCompositeSourceOver fraction:_lightsBlueAlpha];
                if (drawBlueLights == 1 && oldStyleLights)  [_oldblueLights1 compositeToPoint:NSZeroPoint operation:NSCompositeSourceOver fraction:_lightsBlueAlpha];
            }
        }
        
        if (drawPurpleLights != -1) {
            if (lightsPurpleMode == 0 || (lightsPurpleMode == 1 && _lightsPurpleBlinkOn)) {
                if (drawPurpleLights == 0 && !oldStyleLights) [_purpleLights0 compositeToPoint:NSZeroPoint operation:NSCompositeSourceOver fraction:1.0];
                if (drawPurpleLights == 1 && !oldStyleLights) [_purpleLights1 compositeToPoint:NSZeroPoint operation:NSCompositeSourceOver fraction:1.0];
                if (drawPurpleLights == 0 && oldStyleLights)  [_oldpurpleLights0 compositeToPoint:NSZeroPoint operation:NSCompositeSourceOver fraction:1.0];
                if (drawPurpleLights == 1 && oldStyleLights)  [_oldpurpleLights1 compositeToPoint:NSZeroPoint operation:NSCompositeSourceOver fraction:1.0];
            } else if (lightsPurpleMode == 2) {
                if (drawPurpleLights == 0 && !oldStyleLights) [_purpleLights0 compositeToPoint:NSZeroPoint operation:NSCompositeSourceOver fraction:_lightsPurpleAlpha];
                if (drawPurpleLights == 1 && !oldStyleLights) [_purpleLights1 compositeToPoint:NSZeroPoint operation:NSCompositeSourceOver fraction:_lightsPurpleAlpha];
                if (drawPurpleLights == 0 && oldStyleLights)  [_oldpurpleLights0 compositeToPoint:NSZeroPoint operation:NSCompositeSourceOver fraction:_lightsPurpleAlpha];
                if (drawPurpleLights == 1 && oldStyleLights)  [_oldpurpleLights1 compositeToPoint:NSZeroPoint operation:NSCompositeSourceOver fraction:_lightsPurpleAlpha];
            }
        }
                
        if (drawPopcorn) {
            [_popcorn compositeToPoint:NSZeroPoint operation:NSCompositeSourceOver fraction:1.0];
        }
    
        /* TINSEL */
        if (drawTinsel) {
            [_tinsel compositeToPoint:NSZeroPoint operation:NSCompositeSourceOver fraction:1.0];
        }
    
        /* STAR */
        if (drawStar != -1) {
            if (drawStar == 0) {
                [_starOff compositeToPoint:NSZeroPoint operation:NSCompositeSourceOver fraction:1.0];
            } else if (drawStar == 1) {
                [_starOn compositeToPoint:NSZeroPoint operation:NSCompositeSourceOver fraction:1.0];
            } else {
                if (_starLit) [_starOn compositeToPoint:NSZeroPoint operation:NSCompositeSourceOver fraction:1.0];
                if (!_starLit) [_starOff compositeToPoint:NSZeroPoint operation:NSCompositeSourceOver fraction:1.0];
            }
        }
        
        /* Any customs? */
        if (drawCustomObjects) {
            if (_customTop != nil) [_customTop compositeToPoint:NSZeroPoint operation:NSCompositeSourceOver fraction:1.0];
        }
    
        /* BADGER */
        if (drawBadger) {
            int daysTillXmas = [SharedAppController daysUntilChristmas];
            
            if (daysTillXmas != 0) {
                NSPoint badgerPoint = NSMakePoint((_sizes[treeSize].width - [_badgerRed size].width), 0);
                [_badgerRed compositeToPoint: badgerPoint operation:NSCompositeSourceOver fraction:1.0];
                NSString *daysTillXmasString = [NSString stringWithFormat:@"%d", daysTillXmas];
                NSRect srect;
                NSRect vrect = [[_treeWindow contentView] bounds];
                NSSize vsize = vrect.size;
                NSSize bsize;
                NSSize fsize;
                
                bsize.width = [_badgerRed size].width;
                bsize.height = [_badgerRed size].height;
                
                fsize = [daysTillXmasString sizeWithAttributes:_fontAttributes];
                srect.origin.x = (((vrect.origin.x + vsize.width) - bsize.width) + ((bsize.width / 2) - (fsize.width / 2)));
                srect.origin.y = (vrect.origin.y + (fsize.height / 2) - 4);
                srect.size = fsize;
                [daysTillXmasString drawInRect:srect withAttributes:_fontAttributes];
            } else {
                NSPoint badgerPoint = NSMakePoint((_sizes[treeSize].width - [_badgerGreen size].width), 0);
                [_badgerGreen compositeToPoint: badgerPoint operation:NSCompositeSourceOver fraction:1.0];
            }
        }
    
    [[_treeWindow contentView] unlockFocus];
    [_treeWindow enableFlushWindow];
    [_treeWindow flushWindow];
    
    if (_hasShadow) [_treeWindow invalidateShadow];
    
    [self drawDockIcon];
}

- (void)drawDockIcon
{
    if ( ![SharedAppController drawDockIcon]) return;
    
    NSView *winView = [_treeWindow contentView];
    
    [winView lockFocus];
    NSBitmapImageRep *bits = [[NSBitmapImageRep alloc] initWithFocusedViewRect:[winView bounds]];
    [winView unlockFocus];
    
    NSImage *image = [[NSImage alloc] initWithSize:[winView bounds].size];
    [image addRepresentation:bits];
    
    NSSize iSize = NSMakeSize([image size].height, [image size].height);
    NSRect iRect = NSMakeRect(0,0,[image size].height,[image size].height);
    float pX = ((iSize.width / 2) - ([image size].width / 2));
    
    NSImage *icon = [[NSImage alloc] initWithSize:iSize];
    
    [icon lockFocus];
    [[NSColor clearColor] set];
    NSRectFill(iRect);
    [image compositeToPoint:NSMakePoint(pX, 0) operation:NSCompositeSourceOver fraction:1.0];
    [icon unlockFocus];
        
    [NSApp setApplicationIconImage: icon];
    
    [bits release];
    [image release];
    [icon release];
}


- (void)clearStateVariables
{

    _starBlinkTicks             = 0;
    _starLit                    = YES;
    _starBlinkTicksMax          = [self randBetween:(float)MIN_BLINK And:(float)MAX_BLINK];
    
    _lightsRedBlinkTicks        = 0;
    _lightsRedBlinkOn           = YES;
    _lightsRedBlinkTicksMax     = [self randBetween:(float)MIN_BLINK And:(float)MAX_BLINK];
    _lightsRedFadeOnTicks       = 0;
    _lightsRedFadeOnMaxTicks    = [self randBetween:(float)MIN_FADEON And:(float)MAX_FADEON];
    _lightsRedFadingUp          = YES;
    _lightsRedAlpha             = 0.1;
    
    _lightsGreenBlinkTicks      = 0;
    _lightsGreenBlinkOn         = YES;
    _lightsGreenBlinkTicksMax   = [self randBetween:(float)MIN_BLINK And:(float)MAX_BLINK];
    _lightsGreenFadeOnTicks     = 0;
    _lightsGreenFadeOnMaxTicks  = [self randBetween:(float)MIN_FADEOFF And:(float)MAX_FADEOFF];
    _lightsGreenFadingUp        = NO;
    _lightsGreenAlpha           = 1.0;
    
    _lightsBlueBlinkTicks       = 0;
    _lightsBlueBlinkOn          = YES;
    _lightsBlueBlinkTicksMax    = [self randBetween:(float)MIN_BLINK And:(float)MAX_BLINK];
    _lightsBlueFadeOnTicks      = 0;
    _lightsBlueFadeOnMaxTicks   = [self randBetween:(float)MIN_FADEON And:(float)MAX_FADEON];
    _lightsBlueFadingUp         = YES;
    _lightsBlueAlpha            = 0.5;
    
    _lightsPurpleBlinkTicks     = 0;
    _lightsPurpleBlinkOn        = YES;
    _lightsPurpleBlinkTicksMax  = [self randBetween:(float)MIN_BLINK And:(float)MAX_BLINK];
    _lightsPurpleFadeOnTicks    = 0;
    _lightsPurpleFadeOnMaxTicks = [self randBetween:(float)MIN_FADEOFF And:(float)MAX_FADEOFF];
    _lightsPurpleFadingUp       = NO;
    _lightsPurpleAlpha          = 0.5;
    
}


- (float)randBetween:(float)x And:(float)y
{
    float s;

    s = (float)random() / (float)LONG_MAX;
    s *= fabs( x - y );
    s += (x > y) ? y : x;

    return s;
}

@end
