# [devil.utils.markdown](https://github.com/catapult-project/catapult/blob/master/devil/devil/utils/markdown.py)

*This page was autogenerated. Run `devil/bin/generate_md_docs` to update*

## MarkdownHelpAction

### MarkdownHelpAction.\_\_call\_\_

### MarkdownHelpAction.\_\_init\_\_

## MarkdownHelpFormatter

A really bare-bones argparse help formatter that generates valid markdown.
```
  This will generate something like:

  usage

  # **section heading**:

  ## **--argument-one**

  \`\`\`
  argument-one help text
  \`\`\`

```


### MarkdownHelpFormatter.format\_help

### MarkdownHelpFormatter.start\_section

### add\_md\_help\_argument

Adds --md-help to the given argparse.ArgumentParser.
```
  Running a script with --md-help will print the help text for that script
  as valid markdown.

  Args:
    parser: The ArgumentParser to which --md-help should be added.
```


### load\_module\_from\_path

Load a module given only the path name.
```
  Also loads package modules as necessary.

  Args:
    module_path: An absolute path to a python module.
  Returns:
    The module object for the given path.
```


### main

Write markdown documentation for the module at the provided path.
```
  Args:
    raw_args: the raw command-line args. Usually sys.argv[1:].
  Returns:
    An integer exit code. 0 for success, non-zero for failure.
```


### md\_bold

Returns markdown-formatted bold text.
### md\_class

Write markdown documentation for a class.
```
  Documents public methods. Does not currently document subclasses.

  Args:
    class_obj: a types.TypeType object for the class that should be
      documented.
  Returns:
    A list of markdown-formatted lines.
```


### md\_code

Returns a markdown-formatted code block in the given language.
### md\_docstring

Write a markdown-formatted docstring.
```
  Returns:
    A list of markdown-formatted lines.
```


### md\_escape

Escapes \* and \_.
### md\_function

Write markdown documentation for a function.
```
  Args:
    func_obj: a types.FunctionType object for the function that should be
      documented.
  Returns:
    A list of markdown-formatted lines.
```


### md\_heading

Returns markdown-formatted heading.
### md\_inline\_code

Returns markdown-formatted inline code.
### md\_italic

Returns markdown-formatted italic text.
### md\_link

returns a markdown-formatted link.
### md\_module

Write markdown documentation for a module.
```
  Documents public classes and functions.

  Args:
    module_obj: a module object that should be documented.
  Returns:
    A list of markdown-formatted lines.
```


