/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development.testing;

import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.base.Splitter;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.Iterables;
import com.google.appengine.repackaged.com.google.common.collect.LinkedListMultimap;
import com.google.appengine.repackaged.com.google.common.collect.ListMultimap;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

class FakeHttpServletRequest
implements HttpServletRequest {
    private final Map<String, Object> attributes = Maps.newConcurrentMap();
    private final ListMultimap<String, String> headers = LinkedListMultimap.create();
    private final ListMultimap<String, String> parameters = LinkedListMultimap.create();
    private String hostName = "localhost";
    private int port = 443;
    private String contextPath = "";
    private String servletPath = "";
    private String pathInfo;
    private String method;
    private static final Function<Collection<String>, String[]> STRING_COLLECTION_TO_ARRAY = new Function<Collection<String>, String[]>(){

        @Override
        public String[] apply(Collection<String> values) {
            return values.toArray(new String[0]);
        }
    };

    FakeHttpServletRequest() {
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.attributes.keySet());
    }

    public String getCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public int getContentLength() {
        return -1;
    }

    public String getContentType() {
        return null;
    }

    public ServletInputStream getInputStream() {
        throw new UnsupportedOperationException();
    }

    public String getLocalAddr() {
        return "1.2.3.4";
    }

    public String getLocalName() {
        return this.hostName;
    }

    public int getLocalPort() {
        return this.port;
    }

    public Locale getLocale() {
        return Locale.US;
    }

    public Enumeration<Locale> getLocales() {
        return Collections.enumeration(Collections.singleton(Locale.US));
    }

    public String getParameter(String name) {
        return Iterables.getFirst(this.parameters.get((Object)name), null);
    }

    public Map<String, String[]> getParameterMap() {
        return Collections.unmodifiableMap(Maps.transformValues(this.parameters.asMap(), STRING_COLLECTION_TO_ARRAY));
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.parameters.keySet());
    }

    public String[] getParameterValues(String name) {
        return STRING_COLLECTION_TO_ARRAY.apply(this.parameters.get((Object)name));
    }

    public String getProtocol() {
        return "HTTP/1.1";
    }

    public BufferedReader getReader() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public String getRealPath(String path) {
        throw new UnsupportedOperationException();
    }

    public String getRemoteAddr() {
        return "5.6.7.8";
    }

    public String getRemoteHost() {
        return "remotehost";
    }

    public int getRemotePort() {
        return 1234;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        throw new UnsupportedOperationException();
    }

    public String getScheme() {
        return this.port == 443 ? "https" : "http";
    }

    public String getServerName() {
        return this.hostName;
    }

    public int getServerPort() {
        return this.port;
    }

    public boolean isSecure() {
        return this.port == 443;
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void setCharacterEncoding(String env) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public String getAuthType() {
        return null;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public Cookie[] getCookies() {
        return new Cookie[0];
    }

    public long getDateHeader(String name) {
        throw new UnsupportedOperationException();
    }

    public String getHeader(String name) {
        return Iterables.getFirst(this.headers.get((Object)name), null);
    }

    public Enumeration<String> getHeaderNames() {
        return Collections.enumeration(this.headers.keySet());
    }

    public Enumeration<String> getHeaders(String name) {
        return Collections.enumeration(this.headers.get((Object)name));
    }

    public int getIntHeader(String name) {
        return Integer.parseInt(this.getHeader(name));
    }

    public String getMethod() {
        if (this.method == null) {
            return "GET";
        }
        return this.method;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getPathTranslated() {
        return this.pathInfo;
    }

    public String getQueryString() {
        if (this.parameters.isEmpty() || !this.getMethod().equals("GET")) {
            return null;
        }
        return FakeHttpServletRequest.paramsToString(this.parameters);
    }

    public String getRemoteUser() {
        return null;
    }

    public String getRequestURI() {
        String string = this.contextPath;
        String string2 = this.servletPath;
        String string3 = this.pathInfo == null ? "" : this.pathInfo;
        return new StringBuilder(String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string).append(string2).append(string3).toString();
    }

    public StringBuffer getRequestURL() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getScheme());
        sb.append("://");
        sb.append(this.getServerName());
        sb.append(":");
        sb.append(this.getServerPort());
        sb.append(this.contextPath);
        sb.append(this.servletPath);
        if (this.pathInfo != null) {
            sb.append(this.pathInfo);
        }
        return sb;
    }

    public String getRequestedSessionId() {
        return null;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public HttpSession getSession() {
        throw new UnsupportedOperationException();
    }

    public HttpSession getSession(boolean create) {
        throw new UnsupportedOperationException();
    }

    public Principal getUserPrincipal() {
        throw new UnsupportedOperationException();
    }

    public boolean isRequestedSessionIdFromCookie() {
        throw new UnsupportedOperationException();
    }

    public boolean isRequestedSessionIdFromURL() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public boolean isRequestedSessionIdFromUrl() {
        throw new UnsupportedOperationException();
    }

    public boolean isRequestedSessionIdValid() {
        throw new UnsupportedOperationException();
    }

    public boolean isUserInRole(String role) {
        throw new UnsupportedOperationException();
    }

    private static String paramsToString(ListMultimap<String, String> params) {
        try {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (Map.Entry e : params.entries()) {
                if (!first) {
                    sb.append('&');
                } else {
                    first = false;
                }
                sb.append(URLEncoder.encode((String)e.getKey(), StandardCharsets.UTF_8.name()));
                if ("".equals(e.getValue())) continue;
                sb.append('=').append(URLEncoder.encode((String)e.getValue(), StandardCharsets.UTF_8.name()));
            }
            return sb.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public void setParametersFromQueryString(String qs) {
        this.parameters.clear();
        if (qs != null) {
            for (String entry : Splitter.on('&').split(qs)) {
                ImmutableList<String> kv = ImmutableList.copyOf(Splitter.on('=').limit(2).split(entry));
                try {
                    this.parameters.put(URLDecoder.decode((String)kv.get(0), StandardCharsets.UTF_8.name()), kv.size() == 2 ? URLDecoder.decode((String)kv.get(1), StandardCharsets.UTF_8.name()) : "");
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setHeader(String key, String value) {
        this.headers.put(key, value);
    }

    public void addParameter(String key, String value) {
        this.parameters.put(key, value);
    }

    public void setMethod(String name) {
        this.method = name;
    }

    void setSerletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    void setPathInfo(String pathInfo) {
        this.pathInfo = "".equals(pathInfo) ? null : pathInfo;
    }
}

