/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.api.utils.SystemProperty;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.AppEngineWebXml;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.concurrent.GuardedBy;

public class SystemPropertiesManager {
    private static final Logger logger = Logger.getLogger(SystemPropertiesManager.class.getName());
    @GuardedBy(value="this")
    private final Map<String, File> propertyNameToFileMap = new HashMap<String, File>();
    @GuardedBy(value="this")
    private final Properties originalSystemProperties = new Properties();

    SystemPropertiesManager() {
        this.originalSystemProperties.putAll((Map<?, ?>)System.getProperties());
    }

    synchronized Properties getOriginalSystemProperties() {
        Properties result = new Properties();
        result.putAll((Map<?, ?>)this.originalSystemProperties);
        return result;
    }

    public void setAppengineSystemProperties(String release, String applicationId, String majorVersionId) {
        SystemProperty.environment.set(SystemProperty.Environment.Value.Development);
        if (release == null) {
            release = "null";
        }
        SystemProperty.version.set(release);
        SystemProperty.applicationId.set(applicationId);
        SystemProperty.applicationVersion.set(String.valueOf(majorVersionId).concat(".1"));
    }

    public synchronized void setSystemProperties(AppEngineWebXml appEngineWebXml, File appengineWebXmlFile) throws AppEngineConfigException {
        Map<String, String> originalSystemProperties = SystemPropertiesManager.copySystemProperties();
        for (Map.Entry<String, String> entry : appEngineWebXml.getSystemProperties().entrySet()) {
            if (this.propertyNameToFileMap.containsKey(entry.getKey()) && !entry.getValue().equals(System.getProperty(entry.getKey())) && !this.propertyNameToFileMap.get(entry.getKey()).equals(appengineWebXmlFile)) {
                String template = "Property %s is defined in %s and in %s with different values. Currently Java Development Server requires matching values.";
                String message = String.format(template, entry.getKey(), appengineWebXmlFile.getAbsolutePath(), this.propertyNameToFileMap.get(entry.getKey()));
                logger.logp(Level.SEVERE, "com.google.appengine.tools.development.SystemPropertiesManager", "setSystemProperties", message);
                throw new AppEngineConfigException(message);
            }
            if (!originalSystemProperties.containsKey(entry.getKey())) continue;
            String message = String.format("Overwriting system property key '%s', value '%s' with value '%s' from '%s'", entry.getKey(), originalSystemProperties.get(entry.getKey()), entry.getValue(), appengineWebXmlFile.getAbsolutePath());
            logger.logp(Level.INFO, "com.google.appengine.tools.development.SystemPropertiesManager", "setSystemProperties", message);
        }
        Iterator<Map.Entry<String, File>> iterator = this.propertyNameToFileMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, File> entry = iterator.next();
            if (!entry.getValue().equals(appengineWebXmlFile)) continue;
            iterator.remove();
        }
        for (Map.Entry<String, String> entry : appEngineWebXml.getSystemProperties().entrySet()) {
            this.propertyNameToFileMap.put(entry.getKey(), appengineWebXmlFile);
        }
        System.getProperties().putAll(appEngineWebXml.getSystemProperties());
    }

    public synchronized void restoreSystemProperties() {
        for (String key : this.propertyNameToFileMap.keySet()) {
            System.clearProperty(key);
        }
        this.propertyNameToFileMap.clear();
        System.getProperties().putAll((Map<?, ?>)this.originalSystemProperties);
    }

    @VisibleForTesting
    static Map<String, String> copySystemProperties() {
        HashMap<String, String> copy = new HashMap<String, String>();
        for (String key : System.getProperties().stringPropertyNames()) {
            copy.put(key, System.getProperties().getProperty(key));
        }
        return copy;
    }
}

