/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.tools;

import com.google.api.server.spi.IoUtil;
import com.google.api.server.spi.ObjectMapperUtil;
import com.google.api.server.spi.tools.CloudDiscoveryDocGenerator;
import com.google.api.server.spi.tools.DiscoveryDocGenerator;
import com.google.api.server.spi.tools.EndpointsToolAction;
import com.google.appengine.repackaged.com.google.common.io.FileWriteMode;
import com.google.appengine.repackaged.com.google.common.io.Files;
import com.google.appengine.repackaged.org.codehaus.jackson.JsonParseException;
import com.google.appengine.repackaged.org.codehaus.jackson.map.JsonMappingException;
import com.google.appengine.tools.util.Option;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;

public class GenDiscoveryDocAction
extends EndpointsToolAction {
    public static final String NAME = "gen-discovery-doc";
    public static final String DISCOVERY_GEN_ROOT = "https://webapis-discovery.appspot.com/_ah/api";
    private Option formatOption = this.makeFormatOption();
    private Option outputOption = this.makeOutputOption();

    public GenDiscoveryDocAction() {
        super(NAME);
        this.setOptions(Arrays.asList(this.formatOption, this.outputOption));
        this.setShortDescription("Generates API Discovery document");
        this.setHelpDisplayNeeded(false);
    }

    @Override
    public boolean execute() throws JsonParseException, JsonMappingException, IOException {
        if (this.getArgs().size() != 1) {
            return false;
        }
        DiscoveryDocGenerator.Format format = DiscoveryDocGenerator.Format.valueOf(this.getFormat(this.formatOption).toUpperCase());
        this.genDiscoveryDocFromFile(format, this.getOutputPath(this.outputOption), (String)this.getArgs().get(0), true);
        return true;
    }

    public String genDiscoveryDocFromFile(DiscoveryDocGenerator.Format format, String outputDirPath, String apiConfigFilePath, boolean outputToDisk) throws JsonParseException, JsonMappingException, IOException {
        String apiConfigJson = IoUtil.readFile((File)new File(apiConfigFilePath));
        return this.genDiscoveryDoc(format, outputDirPath, apiConfigJson, outputToDisk);
    }

    public String genDiscoveryDoc(DiscoveryDocGenerator.Format format, String outputDirPath, String apiConfigJson, boolean outputToDisk) throws JsonParseException, JsonMappingException, IOException {
        File outputDir = new File(outputDirPath);
        if (!outputDir.isDirectory()) {
            throw new IllegalArgumentException(String.valueOf(outputDirPath).concat(" is not a directory"));
        }
        Map apiConfig = ObjectMapperUtil.createStandardObjectMapper().readValue(apiConfigJson, Map.class);
        String name = GenDiscoveryDocAction.getNonNullValue(apiConfig, "name");
        String version = GenDiscoveryDocAction.getNonNullValue(apiConfig, "version");
        DiscoveryDocGenerator generator = CloudDiscoveryDocGenerator.using(this.getDiscoveryGenRoot());
        String discoveryDoc = generator.generateDiscoveryDoc(apiConfigJson, format);
        if (outputToDisk) {
            String string = String.valueOf(outputDir);
            String string2 = format.toString().toLowerCase();
            String discoveryDocFilePath = new StringBuilder(13 + String.valueOf(string).length() + String.valueOf(name).length() + String.valueOf(version).length() + String.valueOf(string2).length()).append(string).append("/").append(name).append("-").append(version).append("-").append(string2).append(".discovery").toString();
            Files.asCharSink(new File(discoveryDocFilePath), StandardCharsets.UTF_8, new FileWriteMode[0]).write(discoveryDoc);
            String string3 = String.valueOf(discoveryDocFilePath);
            System.out.println(string3.length() != 0 ? "API Discovery Document written to ".concat(string3) : new String("API Discovery Document written to "));
        }
        return discoveryDoc;
    }

    private String getDiscoveryGenRoot() {
        String discoveryGenRoot = System.getenv("DISCOVERY_GEN_ROOT");
        return discoveryGenRoot == null ? DISCOVERY_GEN_ROOT : discoveryGenRoot;
    }

    private static String getNonNullValue(Map<String, ?> apiConfig, String name) {
        String value = (String)apiConfig.get(name);
        if (value == null) {
            throw new IllegalArgumentException(new StringBuilder(19 + String.valueOf(name).length()).append("API ").append(name).append(" cannot be null").toString());
        }
        return value;
    }

    @Override
    public String getUsageString() {
        return "gen-discovery-doc <options> <api config file>";
    }
}

