/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.tools.devserver;

import com.google.api.server.spi.tools.devserver.ApiConfig;
import com.google.api.server.spi.tools.devserver.DevApiUtil;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.org.codehaus.jackson.node.ObjectNode;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PathTrie {
    private static final Pattern PATH_SEPARATOR_PATTERN = Pattern.compile("/");
    private final PathTrieNode triePath = new PathTrieNode();

    public PathTrie(List<ApiConfig> apiConfigs) {
        for (ApiConfig apiConfig : apiConfigs) {
            for (Map.Entry<String, ApiConfig.Method> methodEntry : apiConfig.methods.entrySet()) {
                ApiConfig.Method method = methodEntry.getValue();
                method.api = apiConfig;
                this.add(apiConfig.name, apiConfig.version, method);
            }
        }
    }

    @VisibleForTesting
    void add(String name, String version, ApiConfig.Method method) {
        try {
            this.triePath.add(PathTrie.splitIntoSegments(method.httpMethod.toLowerCase(), name, version, method.path), 0, new ArrayList(), method);
        }
        catch (IllegalArgumentException exception) {
            throw new IllegalArgumentException(String.format("Error while processing method %s in API %s VERSION %s", method.path, name, version), exception);
        }
    }

    public ApiConfig.Method get(String verb, String path, ObjectNode userParams) {
        return this.triePath.find(PathTrie.splitIntoSegments(verb.toLowerCase(), path), 0, userParams, new ArrayList());
    }

    private static List<String> splitIntoSegments(String ... paths) {
        ArrayList<String> pathSegments = new ArrayList<String>();
        for (String path : paths) {
            String[] splitSegments = PATH_SEPARATOR_PATTERN.split(DevApiUtil.stripLeadingSlash(path));
            pathSegments.addAll(Arrays.asList(splitSegments));
        }
        return pathSegments;
    }

    private static class PathTrieNode {
        private static final Pattern PARAMETER_NAME_PATTERN = Pattern.compile("[a-zA-Z_][a-zA-Z_\\d]*");
        private static final Pattern PARAMETER_VALUE_PATTERN = Pattern.compile("[^/?#\\[\\]{}]+");
        private static final String WILDCARD_PATH_SEGMENT = "";
        private final Map<String, PathTrieNode> childNodeFromPathSegment = new HashMap<String, PathTrieNode>();
        private List<String> parameterNames;
        private ApiConfig.Method method;

        private PathTrieNode() {
        }

        private static String buildWildcardPath(List<String> pathSegments) {
            StringBuilder builder = new StringBuilder();
            for (String segment : pathSegments) {
                builder.append('/').append(WILDCARD_PATH_SEGMENT.equals(segment) ? "*" : segment);
            }
            return builder.toString();
        }

        private void add(List<String> pathSegments, int index, List<String> parameterNames, ApiConfig.Method method) {
            if (index >= pathSegments.size()) {
                if (this.method != null) {
                    throw new IllegalArgumentException(String.format("Path '%s' is already mapped", PathTrieNode.buildWildcardPath(pathSegments)));
                }
                this.parameterNames = Collections.unmodifiableList(parameterNames);
                this.method = method;
                return;
            }
            String parameterName = PathTrieNode.getParameterName(pathSegments.get(index));
            if (parameterName != null) {
                parameterNames.add(parameterName);
                pathSegments.set(index, WILDCARD_PATH_SEGMENT);
            } else if (!PARAMETER_VALUE_PATTERN.matcher(pathSegments.get(index)).matches()) {
                throw new IllegalArgumentException(String.format("'%s' not a valid path segment", pathSegments.get(index)));
            }
            this.getOrInsertChildNode(pathSegments.get(index)).add(pathSegments, index + 1, parameterNames, method);
        }

        private static String getParameterName(String name) {
            if (!name.startsWith("{") || !name.endsWith("}")) {
                return null;
            }
            Matcher matcher = PARAMETER_NAME_PATTERN.matcher(name = name.substring(1, name.length() - 1));
            if (!matcher.matches()) {
                throw new IllegalArgumentException(String.format("'%s' not a valid path variable name", name));
            }
            return name;
        }

        private PathTrieNode getOrInsertChildNode(String pathSegment) {
            PathTrieNode childNode = this.childNodeFromPathSegment.get(pathSegment);
            if (childNode == null) {
                childNode = new PathTrieNode();
                this.childNodeFromPathSegment.put(pathSegment, childNode);
            }
            return childNode;
        }

        private ApiConfig.Method find(List<String> pathSegments, int index, ObjectNode userParams, List<String> values) {
            ApiConfig.Method m;
            if (index >= pathSegments.size()) {
                return this.method != null ? this.storeParameterValues(userParams, values) : null;
            }
            String pathSegment = pathSegments.get(index);
            PathTrieNode node = this.childNodeFromPathSegment.get(pathSegment);
            if (node != null && (m = node.find(pathSegments, index + 1, userParams, values)) != null) {
                return m;
            }
            PathTrieNode pathTrieNode = node = PARAMETER_VALUE_PATTERN.matcher(pathSegments.get(index)).matches() ? this.childNodeFromPathSegment.get(WILDCARD_PATH_SEGMENT) : null;
            if (node != null) {
                values.add(pathSegment);
                m = node.find(pathSegments, index + 1, userParams, values);
                if (m != null) {
                    return m;
                }
                values.remove(values.size() - 1);
            }
            return null;
        }

        private ApiConfig.Method storeParameterValues(ObjectNode userParams, List<String> values) {
            if (this.parameterNames == null) {
                throw new AssertionError((Object)"Not a valid path endpoint.");
            }
            if (values.size() != this.parameterNames.size()) {
                throw new AssertionError((Object)String.format("Traveled should have read in %d parameter values. %d were read instead.", values.size(), this.parameterNames.size()));
            }
            for (int i = 0; i < values.size(); ++i) {
                userParams.put(this.parameterNames.get(i), PathTrieNode.decodeUri(values.get(i)));
            }
            return this.method;
        }

        private static String decodeUri(String value) {
            try {
                return URLDecoder.decode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                return value;
            }
        }
    }
}

