/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.labs.command;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Suppliers;
import com.google.appengine.repackaged.com.google.common.flogger.GoogleLogger;
import com.google.appengine.repackaged.com.google.common.io.ByteStreams;
import com.google.appengine.repackaged.com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.appengine.repackaged.com.google.common.util.concurrent.Uninterruptibles;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Supplier;

final class AsyncCopier {
    private static final GoogleLogger logger = GoogleLogger.forInjectedClassName("com/google/appengine/repackaged/com/google/common/labs/command/AsyncCopier");
    @VisibleForTesting
    static final CopyStrategy REAL_COPY_STRATEGY = ByteStreams::copy;
    @VisibleForTesting
    static final Supplier<ExecutorService> realExecutorService = Suppliers.memoize(() -> Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("async-copy-%d").setDaemon(true).build()))::get;
    private final InputStream source;
    private final OutputStream sink;
    private final Consumer<IOException> ioExceptionHandler;
    private final CopyStrategy copyStrategy;
    private final Future<?> copyFuture;
    private final CountDownLatch copyStarted = new CountDownLatch(1);
    private final CountDownLatch copyTerminated = new CountDownLatch(1);

    static AsyncCopier start(InputStream from, OutputStream to, Consumer<IOException> ioExceptionHandler) {
        return new AsyncCopier(from, to, ioExceptionHandler, REAL_COPY_STRATEGY, realExecutorService.get());
    }

    @VisibleForTesting
    AsyncCopier(InputStream source, OutputStream sink, Consumer<IOException> ioExceptionHandler, CopyStrategy copyStrategy, ExecutorService executorService) {
        this.source = source;
        this.sink = sink;
        this.ioExceptionHandler = ioExceptionHandler;
        this.copyStrategy = copyStrategy;
        this.copyFuture = executorService.submit(this::copy);
        Uninterruptibles.awaitUninterruptibly(this.copyStarted);
    }

    private void copy() {
        this.copyStarted.countDown();
        try {
            try {
                this.copyStrategy.copy(this.source, this.sink);
            }
            catch (IOException e) {
                this.ioExceptionHandler.accept(e);
            }
            finally {
                this.closeStreams();
            }
        }
        catch (RuntimeException e) {
            ((GoogleLogger.Api)((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withCause(e)).withInjectedLogSite("com/google/appengine/repackaged/com/google/common/labs/command/AsyncCopier", "copy", 104, "AsyncCopier.java")).log();
        }
        finally {
            this.copyTerminated.countDown();
        }
    }

    void awaitUninterruptibly() {
        Uninterruptibles.awaitUninterruptibly(this.copyTerminated);
    }

    void stopUninterruptibly() {
        this.copyFuture.cancel(true);
        this.closeStreams();
        this.awaitUninterruptibly();
    }

    private void closeStreams() {
        try {
            try {
                this.source.close();
            }
            finally {
                this.sink.close();
            }
        }
        catch (IOException e) {
            this.ioExceptionHandler.accept(e);
        }
    }

    @VisibleForTesting
    static interface CopyStrategy {
        public void copy(InputStream var1, OutputStream var2) throws IOException;
    }
}

