/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.labs.command;

import com.google.appengine.repackaged.com.google.common.base.MoreObjects;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.io.ByteSink;
import com.google.appengine.repackaged.com.google.common.labs.command.AutoValue_OutputSink;
import com.google.appengine.repackaged.com.google.common.labs.command.ForwardingOutputStream;
import com.google.appengine.repackaged.com.google.errorprone.annotations.Immutable;
import com.google.auto.value.AutoValue;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Optional;

@Immutable
@AutoValue
@AutoValue.CopyAnnotations
public abstract class OutputSink {
    private static final OutputSink TO_JVM_ERR = OutputSink.create(Kind.JVM_ERR, Optional.empty());
    private static final OutputSink TO_JVM_OUT = OutputSink.create(Kind.JVM_OUT, Optional.empty());
    private static final OutputSink TO_PROCESS_ERR = OutputSink.create(Kind.PROCESS_ERR, Optional.empty());
    private static final OutputSink TO_PROCESS_OUT = OutputSink.create(Kind.PROCESS_OUT, Optional.empty());

    public static OutputSink toFile(Path file) {
        return OutputSink.create(Kind.FILE, Optional.of(file));
    }

    public static OutputSink toFileAppend(Path file) {
        return OutputSink.create(Kind.FILE_APPEND, Optional.of(file));
    }

    public static OutputSink toJvmErr() {
        return TO_JVM_ERR;
    }

    public static OutputSink toJvmOut() {
        return TO_JVM_OUT;
    }

    public static OutputSink toProcessErr() {
        return TO_PROCESS_ERR;
    }

    public static OutputSink toProcessOut() {
        return TO_PROCESS_OUT;
    }

    public static OutputSink toStream(ByteSink streamSupplier) {
        return OutputSink.create(Kind.STREAM, Optional.of(streamSupplier));
    }

    private static OutputSink create(Kind kind, Optional<Object> parameter) {
        return new AutoValue_OutputSink(kind, parameter);
    }

    OutputSink() {
    }

    public abstract Kind kind();

    public final Path file() {
        Preconditions.checkState(this.kind().equals((Object)Kind.FILE) || this.kind().equals((Object)Kind.FILE_APPEND), "Sink is %s, not a file.", (Object)this.kind());
        return (Path)this.parameter().get();
    }

    public final ByteSink streamSupplier() {
        Preconditions.checkState(this.kind().equals((Object)Kind.STREAM), "Sink is %s, not a stream.", (Object)this.kind());
        return (ByteSink)this.parameter().get();
    }

    abstract Optional<Object> parameter();

    public final String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(OutputSink.class).add("kind", (Object)this.kind());
        if (this.parameter().isPresent()) {
            helper.addValue(this.parameter().get());
        }
        return helper.toString();
    }

    final OutputStream openStream() throws IOException {
        switch (this.kind()) {
            case FILE: {
                return Files.newOutputStream(this.file(), new OpenOption[0]);
            }
            case FILE_APPEND: {
                return Files.newOutputStream(this.file(), StandardOpenOption.APPEND);
            }
            case JVM_ERR: {
                return new ForwardingOutputStream(this, new FileOutputStream(FileDescriptor.err)){

                    @Override
                    public void close() {
                    }
                };
            }
            case JVM_OUT: {
                return new ForwardingOutputStream(this, new FileOutputStream(FileDescriptor.out)){

                    @Override
                    public void close() {
                    }
                };
            }
            case PROCESS_ERR: 
            case PROCESS_OUT: {
                throw new IllegalStateException("No output stream available when writing to a process stream");
            }
            case STREAM: {
                return this.streamSupplier().openStream();
            }
        }
        throw new AssertionError((Object)this.kind());
    }

    public static enum Kind {
        FILE,
        FILE_APPEND,
        JVM_ERR,
        JVM_OUT,
        PROCESS_ERR,
        PROCESS_OUT,
        STREAM;

    }
}

