/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development.gwt;

import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.tools.development.DevAppServer;
import com.google.appengine.tools.development.DevAppServerFactory;
import com.google.appengine.tools.info.AppengineSdk;
import com.google.appengine.tools.info.UpdateCheck;
import com.google.appengine.tools.util.Logging;
import com.google.gwt.core.ext.ServletContainer;
import com.google.gwt.core.ext.ServletContainerLauncher;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.util.Properties;

public class AppEngineLauncher
extends ServletContainerLauncher {
    private static final String ADDRESS = "0.0.0.0";

    public ServletContainer start(TreeLogger logger, int port, File appRootDir) throws UnableToCompleteException {
        Properties properties;
        Logging.initializeLogging();
        this.checkStartParams(logger, port, appRootDir);
        TreeLogger branch = logger.branch(TreeLogger.INFO, "Initializing App Engine server");
        this.maybePerformUpdateCheck(branch);
        boolean installSecurityManager = false;
        DevAppServer server = new DevAppServerFactory().createDevAppServer(appRootDir, null, null, ADDRESS, port, true, installSecurityManager, ImmutableMap.of(), false);
        server.setThrowOnEnvironmentVariableMismatch(false);
        Properties stringProperties = properties = System.getProperties();
        server.setServiceProperties(stringProperties);
        try {
            server.start();
            return new AppEngineServletContainer(logger, server);
        }
        catch (Exception e) {
            branch.log(TreeLogger.ERROR, "Unable to start App Engine server", (Throwable)e);
            throw new UnableToCompleteException();
        }
    }

    protected void maybePerformUpdateCheck(TreeLogger logger) {
        ByteArrayOutputStream baos;
        UpdateCheck updateCheck = new UpdateCheck(AppengineSdk.getSdk().getDefaultServer());
        if (updateCheck.allowedToCheckForUpdates() && updateCheck.maybePrintNagScreen(new PrintStream(baos = new ByteArrayOutputStream()))) {
            logger.log(TreeLogger.WARN, new String(baos.toByteArray()));
        }
        if (updateCheck.checkJavaVersion(new PrintStream(baos = new ByteArrayOutputStream()))) {
            logger.log(TreeLogger.WARN, new String(baos.toByteArray()));
        }
    }

    private void checkStartParams(TreeLogger logger, int port, File appRootDir) {
        if (logger == null) {
            throw new NullPointerException("logger cannot be null");
        }
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("port must be either 0 (for auto) or less than 65536");
        }
        if (appRootDir == null) {
            throw new NullPointerException("app root directory cannot be null");
        }
    }

    private static class AppEngineServletContainer
    extends ServletContainer {
        private final TreeLogger logger;
        private final DevAppServer server;

        public AppEngineServletContainer(TreeLogger logger, DevAppServer server) {
            this.logger = logger;
            this.server = server;
        }

        public int getPort() {
            return this.server.getPort();
        }

        public void refresh() throws UnableToCompleteException {
            TreeLogger branch = this.logger.branch(TreeLogger.INFO, "Reloading App Engine server");
            try {
                this.server.restart();
            }
            catch (Exception e) {
                branch.log(TreeLogger.ERROR, "Unable to reload AppEngine server", (Throwable)e);
                throw new UnableToCompleteException();
            }
            branch.log(TreeLogger.INFO, "Reload completed successfully");
        }

        public void stop() throws UnableToCompleteException {
            TreeLogger branch = this.logger.branch(TreeLogger.INFO, "Stopping App Engine server");
            try {
                this.server.shutdown();
            }
            catch (Exception e) {
                branch.log(TreeLogger.ERROR, "Unable to stop App Engine server", (Throwable)e);
                throw new UnableToCompleteException();
            }
            branch.log(TreeLogger.INFO, "Stopped successfully");
        }
    }
}

