/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.util;

import com.google.appengine.tools.util.JarSplitter;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;

abstract class JarMaker {
    protected static final String EXT = ".jar";
    private static final int READ_BUFFER_SIZE_BYTES = 8192;
    private static final int FILE_BUFFER_INITIAL_SIZE_BYTES = 524288;
    private static Logger logger = Logger.getLogger(JarSplitter.class.getName());
    private final String baseName;
    private final File outputDirectory;
    private final int maximumSize;
    private final Set<String> excludes;
    private final boolean closeEachInputStream;
    private int nextFileIndex = 0;
    private long currentSize = 0L;
    private JarOutputStream currentStream;
    private int outputDigits;

    public JarMaker(String baseName, int outputDigits, File outputDirectory, int maximumSize, Set<String> excludes, boolean closeEachInputStream) {
        this.baseName = baseName;
        this.outputDirectory = outputDirectory;
        this.maximumSize = maximumSize;
        this.outputDigits = outputDigits;
        this.excludes = excludes;
        this.closeEachInputStream = closeEachInputStream;
    }

    protected abstract JarEntryData getNextJarEntry() throws IOException;

    protected abstract Manifest getManifest();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws IOException {
        this.outputDirectory.mkdirs();
        Manifest manifest = this.getManifest();
        long manifestSize = manifest != null ? this.getManifestSize(manifest) : 0L;
        byte[] readBuffer = new byte[8192];
        ByteArrayOutputStream fileBuffer = new ByteArrayOutputStream(524288);
        try {
            JarEntryData entryData;
            this.beginNewOutputStream(manifest, manifestSize);
            while ((entryData = this.getNextJarEntry()) != null) {
                long size;
                JarEntry entry = entryData.jarEntry;
                InputStream inputStream = entryData.inputStream;
                String name = entry.getName();
                if (!this.shouldIncludeFile(name)) continue;
                fileBuffer.reset();
                this.readIntoBuffer(inputStream, readBuffer, fileBuffer);
                if (this.closeEachInputStream) {
                    inputStream.close();
                }
                if (this.currentSize + (size = (long)fileBuffer.size()) >= (long)this.maximumSize) {
                    this.beginNewOutputStream(manifest, manifestSize);
                }
                logger.logp(Level.FINE, "com.google.appengine.tools.util.JarMaker", "run", new StringBuilder(44 + String.valueOf(name).length()).append("Copying entry: ").append(name).append(" (").append(size).append(" bytes)").toString());
                this.currentStream.putNextEntry(entry);
                fileBuffer.writeTo(this.currentStream);
                this.currentSize += size;
            }
        }
        finally {
            this.currentStream.close();
        }
    }

    protected boolean shouldIncludeFile(String fileName) {
        if (this.excludes == null) {
            return true;
        }
        for (String suffix : this.excludes) {
            if (!fileName.endsWith(suffix)) continue;
            logger.logp(Level.FINE, "com.google.appengine.tools.util.JarMaker", "shouldIncludeFile", new StringBuilder(43 + String.valueOf(suffix).length() + String.valueOf(fileName).length()).append("Skipping file matching excluded suffix '").append(suffix).append("': ").append(fileName).toString());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getManifestSize(Manifest manifest) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            manifest.write(baos);
            long l = baos.size();
            return l;
        }
    }

    private JarOutputStream newJarOutputStream(Manifest manifest) throws IOException {
        if (manifest == null) {
            return new JarOutputStream(this.createOutFile(this.nextFileIndex++));
        }
        return new JarOutputStream(this.createOutFile(this.nextFileIndex++), manifest);
    }

    private void beginNewOutputStream(Manifest manifest, long manifestSize) throws IOException {
        if (this.currentStream != null) {
            this.currentStream.close();
        }
        this.currentStream = this.newJarOutputStream(manifest);
        this.currentSize = manifestSize;
    }

    private void readIntoBuffer(InputStream inputStream, byte[] readBuffer, ByteArrayOutputStream out) throws IOException {
        int count;
        while ((count = inputStream.read(readBuffer)) != -1) {
            out.write(readBuffer, 0, count);
        }
    }

    private OutputStream createOutFile(int index) throws IOException {
        int n = this.outputDigits;
        String formatString = new StringBuilder(19).append("%s-%0").append(n).append("d%s").toString();
        String newName = String.format(formatString, this.baseName, index, EXT);
        File newFile = new File(this.outputDirectory, newName);
        String string = String.valueOf(newFile);
        logger.logp(Level.FINE, "com.google.appengine.tools.util.JarMaker", "createOutFile", new StringBuilder(18 + String.valueOf(string).length()).append("Opening new file: ").append(string).toString());
        return new BufferedOutputStream(new FileOutputStream(newFile));
    }

    protected static class JarEntryData {
        public JarEntry jarEntry;
        public InputStream inputStream;

        public JarEntryData(JarEntry jarEntry, InputStream inputStream) {
            this.jarEntry = jarEntry;
            this.inputStream = inputStream;
        }
    }
}

