/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.response;

import com.google.api.server.spi.ConfiguredObjectMapper;
import com.google.api.server.spi.ServiceException;
import com.google.api.server.spi.config.ApiSerializationConfig;
import com.google.api.server.spi.response.ResponseUtil;
import com.google.api.server.spi.response.ResultWriter;
import com.google.api.server.spi.types.DateAndTime;
import com.google.api.server.spi.types.SimpleDate;
import com.google.appengine.api.datastore.Blob;
import com.google.appengine.repackaged.com.google.api.client.util.DateTime;
import com.google.appengine.repackaged.org.codehaus.jackson.JsonGenerationException;
import com.google.appengine.repackaged.org.codehaus.jackson.JsonGenerator;
import com.google.appengine.repackaged.org.codehaus.jackson.JsonProcessingException;
import com.google.appengine.repackaged.org.codehaus.jackson.Version;
import com.google.appengine.repackaged.org.codehaus.jackson.map.JsonMappingException;
import com.google.appengine.repackaged.org.codehaus.jackson.map.JsonSerializer;
import com.google.appengine.repackaged.org.codehaus.jackson.map.ObjectWriter;
import com.google.appengine.repackaged.org.codehaus.jackson.map.SerializerProvider;
import com.google.appengine.repackaged.org.codehaus.jackson.map.module.SimpleModule;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;

public final class ServletResponseResultWriter
implements ResultWriter {
    private static final Set<SimpleModule> WRITER_MODULES;
    private final HttpServletResponse servletResponse;
    private final ObjectWriter objectWriter;

    public ServletResponseResultWriter(HttpServletResponse servletResponse, ApiSerializationConfig serializationConfig) {
        this.servletResponse = servletResponse;
        LinkedHashSet<SimpleModule> modules = new LinkedHashSet<SimpleModule>();
        modules.addAll(WRITER_MODULES);
        this.objectWriter = ConfiguredObjectMapper.builder().apiSerializationConfig(serializationConfig).addRegisteredModules(modules).build().writer();
    }

    @Override
    public void write(Object response) throws IOException {
        if (response == null) {
            this.write(204, null, null);
        } else {
            this.write(200, null, ServletResponseResultWriter.writeValueAsString(this.objectWriter, ResponseUtil.wrapCollection(response)));
        }
    }

    @Override
    public void writeError(ServiceException e) throws IOException {
        HashMap<String, String> errors = new HashMap<String, String>();
        errors.put("error_message", e.getMessage());
        this.write(e.getStatusCode(), e.getHeaders(), ServletResponseResultWriter.writeValueAsString(this.objectWriter, errors));
    }

    private void write(int status, Map<String, String> headers, String content) throws IOException {
        this.servletResponse.setStatus(status);
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                this.servletResponse.addHeader(entry.getKey(), entry.getValue());
            }
        }
        if (content != null) {
            this.servletResponse.setContentType("application/json; charset=UTF-8");
            this.servletResponse.setContentLength(content.getBytes(StandardCharsets.UTF_8).length);
            this.servletResponse.getWriter().write(content);
        }
    }

    private static SimpleModule getWriteLongAsStringModule() {
        JsonSerializer<Long> longSerializer = new JsonSerializer<Long>(){

            @Override
            public void serialize(Long value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
                jgen.writeString(value.toString());
            }
        };
        SimpleModule writeLongAsStringModule = new SimpleModule("writeLongAsStringModule", new Version(1, 0, 0, null));
        writeLongAsStringModule.addSerializer(Long.TYPE, longSerializer);
        writeLongAsStringModule.addSerializer(Long.class, longSerializer);
        return writeLongAsStringModule;
    }

    private static SimpleModule getWriteDateAndTimeAsStringModule() {
        JsonSerializer<DateAndTime> dateAndTimeSerializer = new JsonSerializer<DateAndTime>(){

            @Override
            public void serialize(DateAndTime value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
                jgen.writeString(value.toRfc3339String());
            }
        };
        SimpleModule writeDateAsStringModule = new SimpleModule("writeDateAsStringModule", new Version(1, 0, 0, null));
        writeDateAsStringModule.addSerializer(DateAndTime.class, dateAndTimeSerializer);
        return writeDateAsStringModule;
    }

    private static SimpleModule getWriteSimpleDateAsStringModule() {
        JsonSerializer<SimpleDate> simpleDateSerializer = new JsonSerializer<SimpleDate>(){

            @Override
            public void serialize(SimpleDate value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
                jgen.writeString(String.format("%04d-%02d-%02d", value.getYear(), value.getMonth(), value.getDay()));
            }
        };
        SimpleModule writeSimpleDateAsModule = new SimpleModule("writeSimpleDateAsModule", new Version(1, 0, 0, null));
        writeSimpleDateAsModule.addSerializer(SimpleDate.class, simpleDateSerializer);
        return writeSimpleDateAsModule;
    }

    private static SimpleModule getWriteDateAsStringModule() {
        JsonSerializer<Date> dateSerializer = new JsonSerializer<Date>(){

            @Override
            public void serialize(Date value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
                jgen.writeString(new DateTime(value).toStringRfc3339());
            }
        };
        SimpleModule writeDateAsStringModule = new SimpleModule("writeDateAsStringModule", new Version(1, 0, 0, null));
        writeDateAsStringModule.addSerializer(Date.class, dateSerializer);
        return writeDateAsStringModule;
    }

    private static SimpleModule getWriteBlobAsBase64Module() {
        JsonSerializer<Blob> dateSerializer = new JsonSerializer<Blob>(){

            @Override
            public void serialize(Blob value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
                byte[] bytes = value.getBytes();
                jgen.writeBinary(bytes, 0, bytes.length);
            }
        };
        SimpleModule writeBlobAsBase64Module = new SimpleModule("writeBlobAsBase64Module", new Version(1, 0, 0, null));
        writeBlobAsBase64Module.addSerializer(Blob.class, dateSerializer);
        return writeBlobAsBase64Module;
    }

    private static String writeValueAsString(ObjectWriter objectMapper, Object value) throws IOException {
        try {
            return objectMapper.writeValueAsString(value);
        }
        catch (JsonGenerationException e) {
            throw new IOException(e);
        }
        catch (JsonMappingException e) {
            throw new IOException(e);
        }
    }

    static {
        LinkedHashSet<SimpleModule> modules = new LinkedHashSet<SimpleModule>();
        modules.add(ServletResponseResultWriter.getWriteLongAsStringModule());
        modules.add(ServletResponseResultWriter.getWriteDateAsStringModule());
        modules.add(ServletResponseResultWriter.getWriteDateAndTimeAsStringModule());
        modules.add(ServletResponseResultWriter.getWriteSimpleDateAsStringModule());
        modules.add(ServletResponseResultWriter.getWriteBlobAsBase64Module());
        WRITER_MODULES = Collections.unmodifiableSet(modules);
    }
}

