/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.enhancer;

import java.util.Arrays;
import org.datanucleus.enhancer.ClassEnhancer;
import org.datanucleus.enhancer.DataNucleusEnhancer;
import org.datanucleus.util.Localiser;

public abstract class ClassMethod {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.enhancer.Localisation", (ClassLoader)ClassEnhancer.class.getClassLoader());
    protected ClassEnhancer enhancer;
    protected String methodName;
    protected int access;
    protected Object returnType;
    protected Object[] argTypes;
    protected String[] argNames;
    protected String[] exceptions;

    public ClassMethod(ClassEnhancer enhancer, String name, int access, Object returnType, Object[] argTypes, String[] argNames) {
        this(enhancer, name, access, returnType, argTypes, argNames, null);
    }

    public ClassMethod(ClassEnhancer enhancer, String name, int access, Object returnType, Object[] argTypes, String[] argNames, String[] exceptions) {
        this.enhancer = enhancer;
        this.methodName = name;
        this.access = access;
        this.returnType = returnType;
        this.argTypes = argTypes;
        this.argNames = argNames;
        this.exceptions = exceptions;
    }

    public String getName() {
        return this.methodName;
    }

    public int getAccess() {
        return this.access;
    }

    public abstract void initialise();

    public abstract void execute();

    public void close() {
        if (DataNucleusEnhancer.LOGGER.isDebugEnabled()) {
            String msg = ClassMethod.getMethodAdditionMessage(this.methodName, this.returnType, this.argTypes, this.argNames);
            DataNucleusEnhancer.LOGGER.debug((Object)LOCALISER.msg("Enhancer.AddMethod", (Object)msg));
        }
    }

    public int hashCode() {
        return this.methodName.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof ClassMethod) {
            ClassMethod cb = (ClassMethod)o;
            if (cb.methodName.equals(this.methodName)) {
                return Arrays.equals(cb.argTypes, this.argTypes);
            }
        }
        return false;
    }

    public static String getMethodAdditionMessage(String methodName, Object returnType, Object[] argTypes, String[] argNames) {
        StringBuffer sb = new StringBuffer();
        if (returnType != null) {
            if (returnType instanceof Class) {
                sb.append(((Class)returnType).getName()).append(" ");
            } else {
                sb.append(returnType).append(" ");
            }
        } else {
            sb.append("void ");
        }
        sb.append(methodName).append("(");
        if (argTypes != null) {
            for (int i = 0; i < argTypes.length; ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(argTypes[i]).append(" ").append(argNames[i]);
            }
        }
        sb.append(")");
        return sb.toString();
    }
}

