/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.flags.ext;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Supplier;
import com.google.appengine.repackaged.com.google.common.flags.Flag;
import com.google.appengine.repackaged.com.google.common.flags.InvalidFlagValueException;
import com.google.appengine.repackaged.org.joda.time.DateTime;
import com.google.appengine.repackaged.org.joda.time.DateTimeZone;
import com.google.appengine.repackaged.org.joda.time.MutableDateTime;
import com.google.appengine.repackaged.org.joda.time.Period;
import com.google.appengine.repackaged.org.joda.time.format.ISODateTimeFormat;
import com.google.appengine.repackaged.org.joda.time.format.ISOPeriodFormat;

public final class JodaRelativeDateTimeFlag
extends Flag<DateTime> {
    private static final String PERIOD_PREFIX = "P";
    private RoundingMode roundingMode;
    private static final Supplier<Long> SYSTEM_CLOCK = new Supplier<Long>(){

        @Override
        public Long get() {
            return System.currentTimeMillis();
        }
    };

    private JodaRelativeDateTimeFlag(DateTime date, RoundingMode roundingMode) {
        super(roundingMode.round(date));
        this.roundingMode = roundingMode;
    }

    @Override
    protected DateTime parse(String text) throws InvalidFlagValueException {
        return this.roundingMode.round(JodaRelativeDateTimeFlag.parseDate(SYSTEM_CLOCK, text));
    }

    @VisibleForTesting
    static DateTime parseDate(Supplier<Long> clock, String text) {
        if (text == null || text.isEmpty()) {
            return new DateTime(clock.get());
        }
        if (!text.contains("/")) {
            return ISODateTimeFormat.dateTimeParser().parseDateTime(text);
        }
        String[] parts = text.split("/", 2);
        boolean p0IsPeriod = parts[0].startsWith(PERIOD_PREFIX);
        boolean p1IsPeriod = parts[1].startsWith(PERIOD_PREFIX);
        if (p0IsPeriod && p1IsPeriod || !p0IsPeriod && !p1IsPeriod) {
            String string = String.valueOf(text);
            throw new IllegalArgumentException(string.length() != 0 ? "At least one part of a relative date must be an ISO8601 period\n".concat(string) : new String("At least one part of a relative date must be an ISO8601 period\n"));
        }
        String dateStr = p1IsPeriod ? parts[0] : parts[1];
        String periodStr = p0IsPeriod ? parts[0] : parts[1];
        DateTime date = dateStr.isEmpty() ? new DateTime(clock.get()) : ISODateTimeFormat.dateTimeParser().parseDateTime(dateStr);
        Period period = ISOPeriodFormat.standard().parsePeriod(periodStr);
        if (p0IsPeriod) {
            return date.minus(period);
        }
        return date.plus(period);
    }

    public static JodaRelativeDateTimeFlag newFlag(String text) {
        return JodaRelativeDateTimeFlag.newFlag(text, RoundingMode.NONE);
    }

    public static JodaRelativeDateTimeFlag newFlag(String text, RoundingMode roundingMode) {
        return new JodaRelativeDateTimeFlag(JodaRelativeDateTimeFlag.parseDate(SYSTEM_CLOCK, text), roundingMode);
    }

    public static enum RoundingMode {
        NONE{

            @Override
            DateTime round(DateTime in) {
                return in;
            }
        }
        ,
        UTC_DAY{

            @Override
            DateTime round(DateTime in) {
                MutableDateTime mutableDate = in.toMutableDateTime(DateTimeZone.UTC);
                mutableDate.setMillisOfDay(0);
                return mutableDate.toDateTime(in.getZone());
            }
        };


        abstract DateTime round(DateTime var1);
    }
}

