/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.datanucleus.FetchGroup;
import org.datanucleus.NucleusContext;
import org.datanucleus.util.MultiMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FetchGroupManager {
    private MultiMap fetchGroupByName;
    private NucleusContext nucleusCtx;

    public FetchGroupManager(NucleusContext ctx) {
        this.nucleusCtx = ctx;
    }

    public synchronized void addFetchGroup(FetchGroup grp) {
        Collection coll;
        if (this.fetchGroupByName == null) {
            this.fetchGroupByName = new MultiMap();
        }
        if ((coll = (Collection)this.fetchGroupByName.get(grp.getName())) != null) {
            Iterator iter = coll.iterator();
            while (iter.hasNext()) {
                FetchGroup existingGrp = (FetchGroup)iter.next();
                if (!existingGrp.getName().equals(grp.getName()) || !existingGrp.getType().getName().equals(grp.getType().getName())) continue;
                existingGrp.disconnectFromListeners();
                iter.remove();
            }
        }
        this.fetchGroupByName.put(grp.getName(), grp);
    }

    public synchronized void removeFetchGroup(FetchGroup grp) {
        Collection coll;
        if (this.fetchGroupByName != null && (coll = (Collection)this.fetchGroupByName.get(grp.getName())) != null) {
            Iterator iter = coll.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                FetchGroup existingGrp = (FetchGroup)obj;
                if (existingGrp.getType() != grp.getType()) continue;
                existingGrp.disconnectFromListeners();
                iter.remove();
            }
        }
    }

    public synchronized FetchGroup getFetchGroup(Class cls, String name) {
        Collection coll;
        if (this.fetchGroupByName != null && (coll = (Collection)this.fetchGroupByName.get(name)) != null) {
            for (FetchGroup grp : coll) {
                if (grp.getType() != cls) continue;
                return grp;
            }
        }
        FetchGroup grp = this.createFetchGroup(cls, name);
        this.addFetchGroup(grp);
        return grp;
    }

    public FetchGroup createFetchGroup(Class cls, String name) {
        return new FetchGroup(this.nucleusCtx, name, cls);
    }

    public synchronized Set<FetchGroup> getFetchGroupsWithName(String name) {
        Collection coll;
        if (this.fetchGroupByName != null && (coll = (Collection)this.fetchGroupByName.get(name)) != null) {
            return new HashSet<FetchGroup>(coll);
        }
        return null;
    }

    public synchronized void clearFetchGroups() {
        if (this.fetchGroupByName != null) {
            Collection fetchGroups = this.fetchGroupByName.values();
            for (FetchGroup grp : fetchGroups) {
                grp.disconnectFromListeners();
            }
            this.fetchGroupByName.clear();
        }
    }
}

