/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.rdbms.dev;

import com.google.appengine.api.rdbms.dev.LocalRdbmsProperties;
import com.google.cloud.sql.jdbc.internal.ConnectionProperty;
import com.google.cloud.sql.jdbc.internal.DataTypeConverter;
import com.google.cloud.sql.jdbc.internal.JdbcType;
import com.google.protos.cloud.sql.Client;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Util {
    private static final Logger logger = Logger.getLogger(Util.class.getCanonicalName());

    private Util() {
    }

    static Map<String, String> getConnectionProperties(LocalRdbmsProperties properties, Map<String, String> originalMap) {
        String password;
        String user;
        Map<String, String> overridden = Util.overrideConnectionProperties(properties, originalMap);
        HashMap<String, String> result = new HashMap<String, String>();
        String database = overridden.get(ConnectionProperty.DATABASE.key());
        if (database != null) {
            result.put(ConnectionProperty.DATABASE.key(), database);
        }
        if ((user = overridden.get(ConnectionProperty.USER.key())) != null) {
            result.put(ConnectionProperty.USER.key(), user);
        }
        if ((password = overridden.get(ConnectionProperty.PASSWORD.key())) != null) {
            result.put(ConnectionProperty.PASSWORD.key(), password);
        }
        return result;
    }

    static Map<String, String> overrideConnectionProperties(LocalRdbmsProperties properties, Map<String, String> original) {
        String overridePassword;
        String overrideUserName;
        HashMap<String, String> map = new HashMap<String, String>(original);
        String overrideDatabase = properties.getDatabase();
        if (overrideDatabase != null) {
            map.put(ConnectionProperty.DATABASE.key(), overrideDatabase);
        }
        if ((overrideUserName = properties.getUser()) != null) {
            map.put(ConnectionProperty.USER.key(), overrideUserName);
        }
        if ((overridePassword = properties.getPassword()) != null) {
            map.put(ConnectionProperty.PASSWORD.key(), overridePassword);
        }
        return map;
    }

    static String getDatabase(Map<String, String> map) {
        return map.get(ConnectionProperty.DATABASE.key());
    }

    static Map<String, String> toPropertyMap(List<Client.Property> properties) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Client.Property p : properties) {
            map.put(p.getKey(), p.getValue());
        }
        return map;
    }

    static Map<String, String> concat(Map<String, String> map1, Map<String, String> map2) {
        HashMap<String, String> result = new HashMap<String, String>(map1);
        result.putAll(map2);
        return result;
    }

    static Properties asProperties(Map<String, String> map) {
        Properties props = new Properties();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            props.setProperty(entry.getKey(), entry.getValue());
        }
        return props;
    }

    static Client.SqlException toClientSqlException(SQLException e) {
        Client.SqlException.Builder builder = Client.SqlException.newBuilder();
        builder.setCode(e.getErrorCode());
        if (e.getSQLState() != null) {
            builder.setSqlState(e.getSQLState());
        }
        if (e.getMessage() != null) {
            builder.setMessage(e.getMessage());
        }
        return builder.build();
    }

    static <T> T bindVariableToObject(Client.BindVariableProto bv, Class<T> clazz) throws SQLException {
        DataTypeConverter converter = JdbcType.fromCode((int)bv.getType()).getConverter();
        if (bv.hasValue()) {
            return clazz.cast(converter.toObject(bv.getValue()));
        }
        return null;
    }

    static SQLException closeAll(Statement statement, ResultSet rs) {
        SQLException exception = Util.close(rs);
        SQLException closeException = Util.close(statement);
        if (exception == null) {
            exception = closeException;
        }
        return exception;
    }

    static SQLException close(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                logger.logp(Level.SEVERE, "com.google.appengine.api.rdbms.dev.Util", "close", "Could not close the ResultSet", e);
                return e;
            }
        }
        return null;
    }

    static SQLException close(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                logger.logp(Level.SEVERE, "com.google.appengine.api.rdbms.dev.Util", "close", "Could not close the Statement", e);
                return e;
            }
        }
        return null;
    }
}

