/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.lucene.analysis.el;

import com.google.appengine.repackaged.org.apache.lucene.analysis.TokenFilter;
import com.google.appengine.repackaged.org.apache.lucene.analysis.TokenStream;
import com.google.appengine.repackaged.org.apache.lucene.analysis.el.GreekCharsets;
import com.google.appengine.repackaged.org.apache.lucene.analysis.tokenattributes.TermAttribute;
import java.io.IOException;

public final class GreekLowerCaseFilter
extends TokenFilter {
    char[] charset;
    private TermAttribute termAtt;

    public GreekLowerCaseFilter(TokenStream in, char[] charset) {
        super(in);
        this.charset = charset;
        this.termAtt = (TermAttribute)this.addAttribute(TermAttribute.class);
    }

    public GreekLowerCaseFilter(TokenStream in) {
        this(in, GreekCharsets.UnicodeGreek);
    }

    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            char[] chArray = this.termAtt.termBuffer();
            int chLen = this.termAtt.termLength();
            for (int i = 0; i < chLen; ++i) {
                chArray[i] = GreekCharsets.toLowerCase(chArray[i], this.charset);
            }
            return true;
        }
        return false;
    }
}

