/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.lucene.analysis.position;

import com.google.appengine.repackaged.org.apache.lucene.analysis.Token;
import com.google.appengine.repackaged.org.apache.lucene.analysis.TokenFilter;
import com.google.appengine.repackaged.org.apache.lucene.analysis.TokenStream;
import com.google.appengine.repackaged.org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import java.io.IOException;

public class PositionFilter
extends TokenFilter {
    private int positionIncrement = 0;
    private boolean firstTokenPositioned = false;
    private PositionIncrementAttribute posIncrAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);

    public PositionFilter(TokenStream input) {
        super(input);
    }

    public PositionFilter(TokenStream input, int positionIncrement) {
        this(input);
        this.positionIncrement = positionIncrement;
    }

    public final boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            if (this.firstTokenPositioned) {
                this.posIncrAtt.setPositionIncrement(this.positionIncrement);
            } else {
                this.firstTokenPositioned = true;
            }
            return true;
        }
        return false;
    }

    public final Token next(Token reusableToken) throws IOException {
        return super.next(reusableToken);
    }

    public final Token next() throws IOException {
        return super.next();
    }

    public void reset() throws IOException {
        super.reset();
        this.firstTokenPositioned = false;
    }
}

