/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.lucene.analysis.ru;

import com.google.appengine.repackaged.org.apache.lucene.analysis.TokenFilter;
import com.google.appengine.repackaged.org.apache.lucene.analysis.TokenStream;
import com.google.appengine.repackaged.org.apache.lucene.analysis.ru.RussianCharsets;
import com.google.appengine.repackaged.org.apache.lucene.analysis.ru.RussianStemmer;
import com.google.appengine.repackaged.org.apache.lucene.analysis.tokenattributes.TermAttribute;
import java.io.IOException;

public final class RussianStemFilter
extends TokenFilter {
    private RussianStemmer stemmer = null;
    private TermAttribute termAtt;

    public RussianStemFilter(TokenStream in, char[] charset) {
        super(in);
        this.stemmer = new RussianStemmer(charset);
        this.termAtt = (TermAttribute)this.addAttribute(TermAttribute.class);
    }

    public RussianStemFilter(TokenStream in) {
        this(in, RussianCharsets.UnicodeRussian);
    }

    public final boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            String term = this.termAtt.term();
            String s = this.stemmer.stem(term);
            if (s != null && !s.equals(term)) {
                this.termAtt.setTermBuffer(s);
            }
            return true;
        }
        return false;
    }

    public void setStemmer(RussianStemmer stemmer) {
        if (stemmer != null) {
            this.stemmer = stemmer;
        }
    }
}

