/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.lucene.search;

import com.google.appengine.repackaged.org.apache.lucene.search.FieldComparator;
import com.google.appengine.repackaged.org.apache.lucene.search.FieldDoc;
import com.google.appengine.repackaged.org.apache.lucene.search.SortField;
import com.google.appengine.repackaged.org.apache.lucene.util.PriorityQueue;
import java.io.IOException;

public abstract class FieldValueHitQueue
extends PriorityQueue {
    protected final SortField[] fields;
    protected final FieldComparator[] comparators;
    protected final int[] reverseMul;
    static /* synthetic */ Class class$org$apache$lucene$search$FieldValueHitQueue;

    private FieldValueHitQueue(SortField[] fields) {
        this.fields = fields;
        int numComparators = fields.length;
        this.comparators = new FieldComparator[numComparators];
        this.reverseMul = new int[numComparators];
    }

    public static FieldValueHitQueue create(SortField[] fields, int size) throws IOException {
        if (fields.length == 0) {
            throw new IllegalArgumentException("Sort must contain at least one field");
        }
        if (fields.length == 1) {
            return new OneComparatorFieldValueHitQueue(fields, size);
        }
        return new MultiComparatorsFieldValueHitQueue(fields, size);
    }

    FieldComparator[] getComparators() {
        return this.comparators;
    }

    int[] getReverseMul() {
        return this.reverseMul;
    }

    protected abstract boolean lessThan(Object var1, Object var2);

    FieldDoc fillFields(Entry entry) {
        int n = this.comparators.length;
        Comparable[] fields = new Comparable[n];
        for (int i = 0; i < n; ++i) {
            fields[i] = this.comparators[i].value(entry.slot);
        }
        return new FieldDoc(entry.docID, entry.score, fields);
    }

    SortField[] getFields() {
        return this.fields;
    }

    private static final class MultiComparatorsFieldValueHitQueue
    extends FieldValueHitQueue {
        static final /* synthetic */ boolean $assertionsDisabled;

        public MultiComparatorsFieldValueHitQueue(SortField[] fields, int size) throws IOException {
            super(fields);
            int numComparators = this.comparators.length;
            for (int i = 0; i < numComparators; ++i) {
                SortField field = fields[i];
                if (!$assertionsDisabled && field.getType() == 2) {
                    throw new AssertionError();
                }
                this.reverseMul[i] = field.reverse ? -1 : 1;
                this.comparators[i] = field.getComparator(size, i);
            }
            this.initialize(size);
        }

        protected boolean lessThan(Object a, Object b) {
            Entry hitA = (Entry)a;
            Entry hitB = (Entry)b;
            if (!$assertionsDisabled && hitA == hitB) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && hitA.slot == hitB.slot) {
                throw new AssertionError();
            }
            int numComparators = this.comparators.length;
            for (int i = 0; i < numComparators; ++i) {
                int c = this.reverseMul[i] * this.comparators[i].compare(hitA.slot, hitB.slot);
                if (c == 0) continue;
                return c > 0;
            }
            return hitA.docID > hitB.docID;
        }

        static {
            $assertionsDisabled = !(class$org$apache$lucene$search$FieldValueHitQueue == null ? (class$org$apache$lucene$search$FieldValueHitQueue = FieldValueHitQueue.class$("com.google.appengine.repackaged.org.apache.lucene.search.FieldValueHitQueue")) : class$org$apache$lucene$search$FieldValueHitQueue).desiredAssertionStatus();
        }
    }

    private static final class OneComparatorFieldValueHitQueue
    extends FieldValueHitQueue {
        private final FieldComparator comparator;
        private final int oneReverseMul;
        static final /* synthetic */ boolean $assertionsDisabled;

        public OneComparatorFieldValueHitQueue(SortField[] fields, int size) throws IOException {
            super(fields);
            if (fields.length == 0) {
                throw new IllegalArgumentException("Sort must contain at least one field");
            }
            SortField field = fields[0];
            if (!$assertionsDisabled && field.getType() == 2) {
                throw new AssertionError();
            }
            this.comparator = field.getComparator(size, 0);
            this.oneReverseMul = field.reverse ? -1 : 1;
            this.comparators[0] = this.comparator;
            this.reverseMul[0] = this.oneReverseMul;
            this.initialize(size);
        }

        protected boolean lessThan(Object a, Object b) {
            Entry hitA = (Entry)a;
            Entry hitB = (Entry)b;
            if (!$assertionsDisabled && hitA == hitB) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && hitA.slot == hitB.slot) {
                throw new AssertionError();
            }
            int c = this.oneReverseMul * this.comparator.compare(hitA.slot, hitB.slot);
            if (c != 0) {
                return c > 0;
            }
            return hitA.docID > hitB.docID;
        }

        static {
            $assertionsDisabled = !(class$org$apache$lucene$search$FieldValueHitQueue == null ? (class$org$apache$lucene$search$FieldValueHitQueue = FieldValueHitQueue.class$("com.google.appengine.repackaged.org.apache.lucene.search.FieldValueHitQueue")) : class$org$apache$lucene$search$FieldValueHitQueue).desiredAssertionStatus();
        }
    }

    static final class Entry {
        int slot;
        int docID;
        float score;

        Entry(int slot, int docID, float score) {
            this.slot = slot;
            this.docID = docID;
            this.score = score;
        }

        public String toString() {
            return "slot:" + this.slot + " docID:" + this.docID + " score=" + this.score;
        }
    }
}

