/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.appengv3;

import com.google.appengine.repackaged.com.google.common.base.Optional;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.Iterables;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.cloud.datastore.core.exception.DatastoreException;
import com.google.cloud.datastore.core.exception.DatastoreExceptionHelper;
import com.google.storage.onestore.v3.OnestoreEntity;

public class PropertyHelper {
    private static OnestoreEntity.PropertyValue addRawProperty(OnestoreEntity.EntityProto proto, String propertyName) {
        return proto.addRawProperty().setName(propertyName).setMultiple(false).getMutableValue();
    }

    public static void addRawProperty(OnestoreEntity.EntityProto proto, String propertyName, long value) {
        OnestoreEntity.PropertyValue newValue = PropertyHelper.addRawProperty(proto, propertyName);
        newValue.setInt64Value(value);
    }

    public static void addRawProperty(OnestoreEntity.EntityProto proto, String propertyName, String value) {
        OnestoreEntity.PropertyValue newValue = PropertyHelper.addRawProperty(proto, propertyName);
        newValue.setStringValue(value);
    }

    public static void addRawProperty(OnestoreEntity.EntityProto proto, String propertyName, byte[] value) {
        proto.addRawProperty().setName(propertyName).setMultiple(false).setMeaning(OnestoreEntity.Property.Meaning.BLOB).getMutableValue().setStringValueAsBytes(value);
    }

    private static OnestoreEntity.PropertyValue addProperty(OnestoreEntity.EntityProto proto, String propertyName) {
        return proto.addProperty().setName(propertyName).setMultiple(false).getMutableValue();
    }

    public static void addProperty(OnestoreEntity.EntityProto proto, String propertyName, boolean value) {
        OnestoreEntity.PropertyValue newValue = PropertyHelper.addProperty(proto, propertyName);
        newValue.setBooleanValue(value);
    }

    public static void addProperty(OnestoreEntity.EntityProto proto, String propertyName, long value) {
        OnestoreEntity.PropertyValue newValue = PropertyHelper.addProperty(proto, propertyName);
        newValue.setInt64Value(value);
    }

    public static void addProperty(OnestoreEntity.EntityProto proto, String propertyName, OnestoreEntity.PropertyValue value) {
        PropertyHelper.addProperty(proto, propertyName).copyFrom((ProtocolMessage)value);
    }

    public static void addProperty(OnestoreEntity.EntityProto proto, String propertyName, OnestoreEntity.EntityProto embedded) {
        proto.addProperty().setName(propertyName).setMultiple(false).setMeaning(OnestoreEntity.Property.Meaning.ENTITY_PROTO).getMutableValue().setStringValueAsBytes(embedded.toByteArray());
    }

    public static OnestoreEntity.Property findProperty(OnestoreEntity.EntityProto proto, String propertyName) throws DatastoreException {
        Optional<OnestoreEntity.Property> result = PropertyHelper.tryFindProperty(proto, propertyName);
        if (!result.isPresent()) {
            String string = String.valueOf(propertyName);
            throw DatastoreExceptionHelper.internalError(string.length() != 0 ? "Cannot find property: ".concat(string) : new String("Cannot find property: "), new Throwable());
        }
        return (OnestoreEntity.Property)result.get();
    }

    private static OnestoreEntity.Property findRawProperty(OnestoreEntity.EntityProto proto, String propertyName) throws DatastoreException {
        Optional<OnestoreEntity.Property> result = PropertyHelper.tryFindRawProperty(proto, propertyName);
        if (!result.isPresent()) {
            String string = String.valueOf(propertyName);
            throw DatastoreExceptionHelper.internalError(string.length() != 0 ? "Cannot find property: ".concat(string) : new String("Cannot find property: "), new Throwable());
        }
        return (OnestoreEntity.Property)result.get();
    }

    public static Optional<OnestoreEntity.Property> tryFindProperty(OnestoreEntity.EntityProto proto, String propertyName) {
        return Iterables.tryFind((Iterable)proto.propertys(), input -> input.getName().equals(propertyName));
    }

    public static Optional<OnestoreEntity.Property> tryFindRawProperty(OnestoreEntity.EntityProto proto, String propertyName) {
        return Iterables.tryFind((Iterable)proto.rawPropertys(), input -> input.getName().equals(propertyName));
    }

    public static Optional<Long> tryGetLongProperty(OnestoreEntity.EntityProto proto, String propertyName) throws DatastoreException {
        Optional<OnestoreEntity.Property> result = PropertyHelper.tryFindRawProperty(proto, propertyName);
        if (!result.isPresent()) {
            return Optional.absent();
        }
        Preconditions.checkState((boolean)((OnestoreEntity.Property)result.get()).getValue().hasInt64Value(), (String)"Property %s should have a Int64Value", (Object)propertyName);
        return Optional.of((Object)((OnestoreEntity.Property)result.get()).getValue().getInt64Value());
    }

    public static Optional<byte[]> tryGetBlobProperty(OnestoreEntity.EntityProto proto, String propertyName) {
        Optional<OnestoreEntity.Property> result = PropertyHelper.tryFindRawProperty(proto, propertyName);
        if (!result.isPresent()) {
            return Optional.absent();
        }
        OnestoreEntity.Property property = (OnestoreEntity.Property)result.get();
        Preconditions.checkState((property.getMeaningEnum() == OnestoreEntity.Property.Meaning.BLOB ? 1 : 0) != 0, (String)"Property %s should have the meaning BLOB", (Object)propertyName);
        OnestoreEntity.PropertyValue value = property.getValue();
        Preconditions.checkState((boolean)value.hasStringValue(), (String)"Property %s should have a StringValue", (Object)propertyName);
        return Optional.of((Object)value.getStringValueAsBytes());
    }

    public static long getLongProperty(OnestoreEntity.EntityProto proto, String propertyName) throws DatastoreException {
        return (Long)PropertyHelper.tryGetLongProperty(proto, propertyName).get();
    }

    public static String getStringProperty(OnestoreEntity.EntityProto proto, String propertyName) throws DatastoreException {
        OnestoreEntity.Property result = PropertyHelper.findRawProperty(proto, propertyName);
        Preconditions.checkState((boolean)result.getValue().hasStringValue(), (String)"Property %s should have a StringValue", (Object)propertyName);
        return result.getValue().getStringValue();
    }
}

