/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.common.collect.UnmodifiableIterator;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.type.LatLng;
import com.google.cloud.datastore.core.common.UnicodeComparator;
import com.google.cloud.datastore.core.rep.DatabaseRef;
import com.google.cloud.datastore.core.rep.IndexValue;
import java.util.Comparator;
import java.util.Map;

public abstract class BaseIndexValueComparator
implements Comparator<IndexValue> {
    protected static final Comparator<ByteString> BYTE_STRING_COMPARATOR = ByteString.unsignedLexicographicalComparator();

    protected int compareEntityRefWithoutTruncated(IndexValue.EntityRef left, IndexValue.EntityRef right) {
        DatabaseRef leftDatabaseRef = left.databaseRef();
        DatabaseRef rightDatabaseRef = right.databaseRef();
        int comparison = UnicodeComparator.INSTANCE.compare(leftDatabaseRef.projectId(), rightDatabaseRef.projectId());
        if (comparison != 0) {
            return comparison;
        }
        comparison = UnicodeComparator.INSTANCE.compare(leftDatabaseRef.databaseId(), rightDatabaseRef.databaseId());
        if (comparison != 0) {
            return comparison;
        }
        comparison = this.compare(left.namespaceId(), right.namespaceId());
        if (comparison != 0) {
            return comparison;
        }
        if (left.segments().isAbsent() && right.segments().equals(IndexValue.EMPTY_ARRAY)) {
            return 1;
        }
        if (right.segments().isAbsent() && left.segments().equals(IndexValue.EMPTY_ARRAY)) {
            return -1;
        }
        return this.compare(left.segments(), right.segments());
    }

    protected int compareGeoPoint(LatLng left, LatLng right) {
        int latComparison = Double.compare(left.getLatitude(), right.getLatitude());
        if (latComparison != 0) {
            return latComparison;
        }
        return Double.compare(left.getLongitude(), right.getLongitude());
    }

    protected int compareArrayWithoutTruncated(ImmutableList<IndexValue> left, ImmutableList<IndexValue> right) {
        int leftSize = left.size();
        int rightSize = right.size();
        int minSize = Math.min(leftSize, rightSize);
        for (int index = 0; index < minSize; ++index) {
            int elementComparison = this.compare((IndexValue)left.get(index), (IndexValue)right.get(index));
            if (elementComparison == 0) continue;
            return elementComparison;
        }
        return Integer.compare(leftSize, rightSize);
    }

    protected int compareMapWithoutTruncated(ImmutableMap<IndexValue, IndexValue> left, ImmutableMap<IndexValue, IndexValue> right) {
        boolean rightHasNext;
        block2: {
            block3: {
                Map.Entry rightEntry;
                IndexValue rightValue;
                Map.Entry leftEntry;
                IndexValue leftValue;
                int valueComparison;
                UnmodifiableIterator leftIterator = left.entrySet().iterator();
                UnmodifiableIterator rightIterator = right.entrySet().iterator();
                do {
                    IndexValue rightKey;
                    boolean leftHasNext = leftIterator.hasNext();
                    rightHasNext = rightIterator.hasNext();
                    if (!leftHasNext) break block2;
                    if (!rightHasNext) break block3;
                    leftEntry = (Map.Entry)leftIterator.next();
                    rightEntry = (Map.Entry)rightIterator.next();
                    IndexValue leftKey = (IndexValue)leftEntry.getKey();
                    int keyComparison = this.compare(leftKey, rightKey = (IndexValue)rightEntry.getKey());
                    if (keyComparison == 0) continue;
                    return keyComparison;
                } while ((valueComparison = this.compare(leftValue = (IndexValue)leftEntry.getValue(), rightValue = (IndexValue)rightEntry.getValue())) == 0);
                return valueComparison;
            }
            return 1;
        }
        if (rightHasNext) {
            return -1;
        }
        return 0;
    }
}

