/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.cloud.datastore.core.rep.Index;

public enum WorkflowState {
    CREATED,
    ENABLING,
    SERVING,
    NON_SERVING,
    DISABLING,
    DELETED;


    public boolean up() {
        return this == CREATED || this == ENABLING || this == SERVING;
    }

    public boolean write() {
        return this == ENABLING || this == SERVING || this == NON_SERVING;
    }

    public boolean initializing() {
        return this == CREATED || this == NON_SERVING;
    }

    public boolean finalizing() {
        return this == ENABLING || this == DISABLING;
    }

    public boolean terminal() {
        return this == SERVING || this == DELETED;
    }

    @Deprecated
    public boolean adjacent(WorkflowState other) {
        return this.write() == other.write() || !this.terminal() && !other.terminal();
    }

    @Deprecated
    public Index.State toIndexStateLossy() {
        switch (this) {
            case ENABLING: 
            case NON_SERVING: {
                return Index.State.ENABLING;
            }
            case SERVING: {
                return Index.State.ENABLED;
            }
            case DISABLING: 
            case CREATED: {
                return Index.State.DELETING;
            }
            case DELETED: {
                return Index.State.DISABLED;
            }
        }
        throw new AssertionError();
    }
}

