/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep.validator;

import com.google.cloud.datastore.core.exception.ValidationException;
import com.google.cloud.datastore.core.rep.PropertyMask;
import com.google.cloud.datastore.core.rep.PropertyName;
import com.google.cloud.datastore.core.rep.validator.PropertyPathValidator;
import com.google.cloud.datastore.core.rep.validator.ValidationConstraint;

public class PropertyMaskValidator {
    private final PropertyPathValidator propertyPathValidator;

    public PropertyMaskValidator(PropertyPathValidator propertyPathValidator) {
        this.propertyPathValidator = propertyPathValidator;
    }

    public void validatePropertyMask(PropertyMask mask, ValidationConstraint constraint) throws ValidationException {
        this.validatePropertyMask(mask, constraint, true);
    }

    private void validatePropertyMask(PropertyMask mask, ValidationConstraint constraint, boolean firstLevel) throws ValidationException {
        constraint = constraint.withContext(ValidationConstraint.Context.IN_PROPERTY_MASK);
        if (mask.equals(PropertyMask.FULL)) {
            return;
        }
        for (PropertyName propertyName : mask.propertyNames()) {
            PropertyMask nestedMask = mask.nestedMask(propertyName);
            boolean last = nestedMask.equals(PropertyMask.FULL);
            this.propertyPathValidator.validatePropertyNameInPath(propertyName, firstLevel, last, constraint);
            this.validatePropertyMask(nestedMask, constraint, false);
        }
    }
}

