/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.blobstore;

import com.google.appengine.api.blobstore.BlobInfo;
import com.google.appengine.api.blobstore.BlobKey;
import com.google.appengine.api.blobstore.BlobstoreFailureException;
import com.google.appengine.api.blobstore.BlobstoreService;
import com.google.appengine.api.blobstore.BlobstoreServicePb;
import com.google.appengine.api.blobstore.ByteRange;
import com.google.appengine.api.blobstore.FileInfo;
import com.google.appengine.api.blobstore.UnsupportedRangeFormatException;
import com.google.appengine.api.blobstore.UploadOptions;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.apphosting.api.ApiProxy;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

class BlobstoreServiceImpl
implements BlobstoreService {
    static final String PACKAGE = "blobstore";
    static final String SERVE_HEADER = "X-AppEngine-BlobKey";
    static final String UPLOADED_BLOBKEY_ATTR = "com.google.appengine.api.blobstore.upload.blobkeys";
    static final String UPLOADED_BLOBINFO_ATTR = "com.google.appengine.api.blobstore.upload.blobinfos";
    static final String BLOB_RANGE_HEADER = "X-AppEngine-BlobRange";
    static final String CREATION_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";

    BlobstoreServiceImpl() {
    }

    @Override
    public String createUploadUrl(String successPath) {
        return this.createUploadUrl(successPath, UploadOptions.Builder.withDefaults());
    }

    @Override
    public String createUploadUrl(String successPath, UploadOptions uploadOptions) {
        byte[] responseBytes;
        if (successPath == null) {
            throw new NullPointerException("Success path must not be null.");
        }
        BlobstoreServicePb.CreateUploadURLRequest request = new BlobstoreServicePb.CreateUploadURLRequest();
        request.setSuccessPath(successPath);
        if (uploadOptions.hasMaxUploadSizeBytesPerBlob()) {
            request.setMaxUploadSizePerBlobBytes(uploadOptions.getMaxUploadSizeBytesPerBlob());
        }
        if (uploadOptions.hasMaxUploadSizeBytes()) {
            request.setMaxUploadSizeBytes(uploadOptions.getMaxUploadSizeBytes());
        }
        if (uploadOptions.hasGoogleStorageBucketName()) {
            request.setGsBucketName(uploadOptions.getGoogleStorageBucketName());
        }
        try {
            responseBytes = ApiProxy.makeSyncCall(PACKAGE, "CreateUploadURL", request.toByteArray());
        }
        catch (ApiProxy.ApplicationException ex) {
            switch (BlobstoreServicePb.BlobstoreServiceError.ErrorCode.valueOf(ex.getApplicationError())) {
                case URL_TOO_LONG: {
                    throw new IllegalArgumentException("The resulting URL was too long.");
                }
                case INTERNAL_ERROR: {
                    throw new BlobstoreFailureException("An internal blobstore error occured.");
                }
            }
            throw new BlobstoreFailureException("An unexpected error occurred.", ex);
        }
        BlobstoreServicePb.CreateUploadURLResponse response = new BlobstoreServicePb.CreateUploadURLResponse();
        boolean parsed = response.mergeFrom(responseBytes);
        if (!parsed || !response.isInitialized()) {
            throw new BlobstoreFailureException("Could not parse CreateUploadURLResponse");
        }
        return response.getUrl();
    }

    @Override
    public void serve(BlobKey blobKey, HttpServletResponse response) {
        this.serve(blobKey, (ByteRange)null, response);
    }

    @Override
    public void serve(BlobKey blobKey, String rangeHeader, HttpServletResponse response) {
        this.serve(blobKey, ByteRange.parse(rangeHeader), response);
    }

    @Override
    public void serve(BlobKey blobKey, ByteRange byteRange, HttpServletResponse response) {
        if (response.isCommitted()) {
            throw new IllegalStateException("Response was already committed.");
        }
        response.setStatus(200);
        response.setHeader(SERVE_HEADER, blobKey.getKeyString());
        if (byteRange != null) {
            response.setHeader(BLOB_RANGE_HEADER, byteRange.toString());
        }
    }

    @Override
    public ByteRange getByteRange(HttpServletRequest request) {
        Enumeration rangeHeaders = request.getHeaders("range");
        if (!rangeHeaders.hasMoreElements()) {
            return null;
        }
        String rangeHeader = (String)rangeHeaders.nextElement();
        if (rangeHeaders.hasMoreElements()) {
            throw new UnsupportedRangeFormatException("Cannot accept multiple range headers.");
        }
        return ByteRange.parse(rangeHeader);
    }

    @Override
    public void delete(BlobKey ... blobKeys) {
        BlobstoreServicePb.DeleteBlobRequest request = new BlobstoreServicePb.DeleteBlobRequest();
        for (BlobKey blobKey : blobKeys) {
            request.addBlobKey(blobKey.getKeyString());
        }
        if (request.blobKeySize() == 0) {
            return;
        }
        try {
            byte[] responseBytes = ApiProxy.makeSyncCall(PACKAGE, "DeleteBlob", request.toByteArray());
        }
        catch (ApiProxy.ApplicationException ex) {
            switch (BlobstoreServicePb.BlobstoreServiceError.ErrorCode.valueOf(ex.getApplicationError())) {
                case INTERNAL_ERROR: {
                    throw new BlobstoreFailureException("An internal blobstore error occured.");
                }
            }
            throw new BlobstoreFailureException("An unexpected error occurred.", ex);
        }
    }

    @Override
    @Deprecated
    public Map<String, BlobKey> getUploadedBlobs(HttpServletRequest request) {
        Map<String, List<BlobKey>> blobKeys = this.getUploads(request);
        HashMap<String, BlobKey> result = new HashMap<String, BlobKey>(blobKeys.size());
        for (Map.Entry<String, List<BlobKey>> entry : blobKeys.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            result.put(entry.getKey(), entry.getValue().get(0));
        }
        return result;
    }

    @Override
    public Map<String, List<BlobKey>> getUploads(HttpServletRequest request) {
        Map attributes = (Map)request.getAttribute(UPLOADED_BLOBKEY_ATTR);
        if (attributes == null) {
            throw new IllegalStateException("Must be called from a blob upload callback request.");
        }
        HashMap<String, List<BlobKey>> blobKeys = new HashMap<String, List<BlobKey>>(attributes.size());
        for (Map.Entry attr : attributes.entrySet()) {
            ArrayList<BlobKey> blobs = new ArrayList<BlobKey>(((List)attr.getValue()).size());
            for (String key : (List)attr.getValue()) {
                blobs.add(new BlobKey(key));
            }
            blobKeys.put((String)attr.getKey(), blobs);
        }
        return blobKeys;
    }

    @Override
    public Map<String, List<BlobInfo>> getBlobInfos(HttpServletRequest request) {
        Map attributes = (Map)request.getAttribute(UPLOADED_BLOBINFO_ATTR);
        if (attributes == null) {
            throw new IllegalStateException("Must be called from a blob upload callback request.");
        }
        HashMap<String, List<BlobInfo>> blobInfos = new HashMap<String, List<BlobInfo>>(attributes.size());
        for (Map.Entry attr : attributes.entrySet()) {
            ArrayList<BlobInfo> blobs = new ArrayList<BlobInfo>(((List)attr.getValue()).size());
            for (Map info : (List)attr.getValue()) {
                BlobKey key = new BlobKey((String)info.get("key"));
                String contentType = (String)info.get("content-type");
                Date creationDate = BlobstoreServiceImpl.parseCreationDate((String)info.get("creation-date"));
                String filename = (String)info.get("filename");
                int size = Integer.parseInt((String)info.get("size"));
                String md5Hash = (String)info.get("md5-hash");
                String gsObjectName = (String)info.get("gs-name");
                blobs.add(new BlobInfo(key, contentType, creationDate, filename, size, md5Hash, gsObjectName));
            }
            blobInfos.put((String)attr.getKey(), blobs);
        }
        return blobInfos;
    }

    @Override
    public Map<String, List<FileInfo>> getFileInfos(HttpServletRequest request) {
        Map attributes = (Map)request.getAttribute(UPLOADED_BLOBINFO_ATTR);
        if (attributes == null) {
            throw new IllegalStateException("Must be called from a blob upload callback request.");
        }
        HashMap<String, List<FileInfo>> fileInfos = new HashMap<String, List<FileInfo>>(attributes.size());
        for (Map.Entry attr : attributes.entrySet()) {
            ArrayList<FileInfo> files = new ArrayList<FileInfo>(((List)attr.getValue()).size());
            for (Map info : (List)attr.getValue()) {
                String contentType = (String)info.get("content-type");
                Date creationDate = BlobstoreServiceImpl.parseCreationDate((String)info.get("creation-date"));
                String filename = (String)info.get("filename");
                long size = Long.parseLong((String)info.get("size"));
                String md5Hash = (String)info.get("md5-hash");
                String gsObjectName = null;
                if (info.containsKey("gs-name")) {
                    gsObjectName = (String)info.get("gs-name");
                }
                files.add(new FileInfo(contentType, creationDate, filename, size, md5Hash, gsObjectName));
            }
            fileInfos.put((String)attr.getKey(), files);
        }
        return fileInfos;
    }

    @VisibleForTesting
    protected static Date parseCreationDate(String date) {
        Date creationDate = null;
        try {
            date = date.trim().substring(0, CREATION_DATE_FORMAT.length());
            SimpleDateFormat dateFormat = new SimpleDateFormat(CREATION_DATE_FORMAT);
            dateFormat.setLenient(false);
            creationDate = dateFormat.parse(date);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return creationDate;
    }

    @Override
    public byte[] fetchData(BlobKey blobKey, long startIndex, long endIndex) {
        byte[] responseBytes;
        if (startIndex < 0L) {
            throw new IllegalArgumentException("Start index must be >= 0.");
        }
        if (endIndex < startIndex) {
            throw new IllegalArgumentException("End index must be >= startIndex.");
        }
        long fetchSize = endIndex - startIndex + 1L;
        if (fetchSize > 1015808L) {
            throw new IllegalArgumentException(new StringBuilder(79).append("Blob fetch size ").append(fetchSize).append(" is larger than maximum size ").append(1015808).append(" bytes.").toString());
        }
        BlobstoreServicePb.FetchDataRequest request = new BlobstoreServicePb.FetchDataRequest();
        request.setBlobKey(blobKey.getKeyString());
        request.setStartIndex(startIndex);
        request.setEndIndex(endIndex);
        try {
            responseBytes = ApiProxy.makeSyncCall(PACKAGE, "FetchData", request.toByteArray());
        }
        catch (ApiProxy.ApplicationException ex) {
            switch (BlobstoreServicePb.BlobstoreServiceError.ErrorCode.valueOf(ex.getApplicationError())) {
                case PERMISSION_DENIED: {
                    throw new SecurityException("This application does not have access to that blob.");
                }
                case BLOB_NOT_FOUND: {
                    throw new IllegalArgumentException("Blob not found.");
                }
                case INTERNAL_ERROR: {
                    throw new BlobstoreFailureException("An internal blobstore error occured.");
                }
            }
            throw new BlobstoreFailureException("An unexpected error occurred.", ex);
        }
        BlobstoreServicePb.FetchDataResponse response = new BlobstoreServicePb.FetchDataResponse();
        boolean parsed = response.mergeFrom(responseBytes);
        if (!parsed || !response.isInitialized()) {
            throw new BlobstoreFailureException("Could not parse FetchDataResponse");
        }
        return response.getDataAsBytes();
    }

    @Override
    public BlobKey createGsBlobKey(String filename) {
        byte[] responseBytes;
        if (!filename.startsWith("/gs/")) {
            throw new IllegalArgumentException("Google storage filenames must be prefixed with /gs/");
        }
        BlobstoreServicePb.CreateEncodedGoogleStorageKeyRequest request = new BlobstoreServicePb.CreateEncodedGoogleStorageKeyRequest();
        request.setFilename(filename);
        try {
            responseBytes = ApiProxy.makeSyncCall(PACKAGE, "CreateEncodedGoogleStorageKey", request.toByteArray());
        }
        catch (ApiProxy.ApplicationException ex) {
            switch (BlobstoreServicePb.BlobstoreServiceError.ErrorCode.valueOf(ex.getApplicationError())) {
                case INTERNAL_ERROR: {
                    throw new BlobstoreFailureException("An internal blobstore error occured.");
                }
            }
            throw new BlobstoreFailureException("An unexpected error occurred.", ex);
        }
        BlobstoreServicePb.CreateEncodedGoogleStorageKeyResponse response = new BlobstoreServicePb.CreateEncodedGoogleStorageKeyResponse();
        boolean parsed = response.mergeFrom(responseBytes);
        if (!parsed || !response.isInitialized()) {
            throw new BlobstoreFailureException("Could not parse CreateEncodedGoogleStorageKeyResponse");
        }
        return new BlobKey(response.getBlobKey());
    }
}

