/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.AsyncDatastoreService;
import com.google.appengine.api.datastore.DatastoreConfig;
import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceConfig;
import com.google.appengine.api.datastore.IDatastoreServiceFactory;
import com.google.appengine.api.datastore.ImplicitTransactionManagementPolicy;
import com.google.appengine.spi.ServiceFactoryFactory;

public final class DatastoreServiceFactory {
    public static DatastoreService getDatastoreService(DatastoreServiceConfig config) {
        return DatastoreServiceFactory.getFactory().getDatastoreService(config);
    }

    public static DatastoreService getDatastoreService() {
        return DatastoreServiceFactory.getDatastoreService(DatastoreServiceConfig.Builder.withDefaults());
    }

    @Deprecated
    public static DatastoreService getDatastoreService(DatastoreConfig oldConfig) {
        ImplicitTransactionManagementPolicy policy = oldConfig.getImplicitTransactionManagementPolicy();
        DatastoreServiceConfig newConfig = DatastoreServiceConfig.Builder.withImplicitTransactionManagementPolicy(policy);
        return DatastoreServiceFactory.getDatastoreService(newConfig);
    }

    public static AsyncDatastoreService getAsyncDatastoreService(DatastoreServiceConfig config) {
        return DatastoreServiceFactory.getFactory().getAsyncDatastoreService(config);
    }

    public static AsyncDatastoreService getAsyncDatastoreService() {
        return DatastoreServiceFactory.getAsyncDatastoreService(DatastoreServiceConfig.Builder.withDefaults());
    }

    @Deprecated
    public static DatastoreConfig getDefaultDatastoreConfig() {
        return DatastoreConfig.DEFAULT;
    }

    @Deprecated
    public DatastoreServiceFactory() {
    }

    private static IDatastoreServiceFactory getFactory() {
        return ServiceFactoryFactory.getFactory(IDatastoreServiceFactory.class);
    }
}

