/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.xmpp;

import com.google.appengine.api.utils.HttpRequestParser;
import com.google.appengine.api.xmpp.JID;
import com.google.appengine.api.xmpp.Subscription;
import com.google.appengine.api.xmpp.SubscriptionBuilder;
import com.google.appengine.api.xmpp.SubscriptionType;
import java.io.IOException;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMultipart;
import javax.servlet.http.HttpServletRequest;

class InboundSubscriptionParser
extends HttpRequestParser {
    InboundSubscriptionParser() {
    }

    static Subscription parseSubscription(HttpServletRequest request) throws IOException {
        try {
            MimeMultipart multipart = InboundSubscriptionParser.parseMultipartRequest(request);
            SubscriptionBuilder builder = new SubscriptionBuilder();
            if (request.getRequestURI().endsWith("/subscription/subscribe/")) {
                builder.withSubscriptionType(SubscriptionType.SUBSCRIBE);
            } else if (request.getRequestURI().endsWith("/subscription/subscribed/")) {
                builder.withSubscriptionType(SubscriptionType.SUBSCRIBED);
            } else if (request.getRequestURI().endsWith("/subscription/unsubscribe/")) {
                builder.withSubscriptionType(SubscriptionType.UNSUBSCRIBE);
            } else if (request.getRequestURI().endsWith("/subscription/unsubscribed/")) {
                builder.withSubscriptionType(SubscriptionType.UNSUBSCRIBED);
            } else {
                String string = String.valueOf(request.getRequestURI());
                throw new IllegalArgumentException(string.length() != 0 ? "Can't determine the type of stanza from the path: ".concat(string) : new String("Can't determine the type of stanza from the path: "));
            }
            int parts = multipart.getCount();
            for (int i = 0; i < parts; ++i) {
                BodyPart part = multipart.getBodyPart(i);
                String fieldName = InboundSubscriptionParser.getFieldName(part);
                if ("from".equals(fieldName)) {
                    builder.withFromJid(new JID(InboundSubscriptionParser.getTextContent(part)));
                    continue;
                }
                if ("to".equals(fieldName)) {
                    builder.withToJid(new JID(InboundSubscriptionParser.getTextContent(part)));
                    continue;
                }
                if (!"stanza".equals(fieldName)) continue;
                builder.withStanza(InboundSubscriptionParser.getTextContent(part));
            }
            return builder.build();
        }
        catch (MessagingException ex) {
            IOException ex2 = new IOException("Could not parse incoming request.");
            ex2.initCause(ex);
            throw ex2;
        }
    }
}

