/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.datanucleus;

import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.api.datastore.TransactionOptions;
import com.google.appengine.datanucleus.DatastoreTransaction;
import com.google.appengine.datanucleus.EmulatedXAResource;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.datanucleus.util.NucleusLogger;

class DatastoreXAResource
extends EmulatedXAResource {
    private DatastoreTransaction currentTxn;
    private final TransactionOptions txnOpts;

    public DatastoreXAResource(DatastoreService datastoreService, TransactionOptions txnOpts) {
        super(datastoreService);
        this.txnOpts = txnOpts;
    }

    @Override
    DatastoreTransaction getCurrentTransaction() {
        return this.currentTxn;
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        super.start(xid, flags);
        if (this.currentTxn == null) {
            Transaction datastoreTxn = this.datastoreService.beginTransaction(this.txnOpts);
            this.currentTxn = new DatastoreTransaction(datastoreTxn);
            if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
                NucleusLogger.TRANSACTION.debug((Object)LOCALISER.msg("AppEngine.Transaction.Started", (Object)this.currentTxn.getInnerTxn().getId()));
            }
        } else {
            throw new XAException(LOCALISER.msg("AppEngine.Transaction.AlreadyStarted"));
        }
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        super.commit(xid, onePhase);
        if (this.currentTxn != null) {
            this.currentTxn.commit();
            if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
                NucleusLogger.TRANSACTION.debug((Object)LOCALISER.msg("AppEngine.Transaction.Committed", (Object)this.currentTxn.getInnerTxn().getId()));
            }
        } else {
            throw new XAException(LOCALISER.msg("AppEngine.Transaction.CommitInvalid"));
        }
        this.currentTxn = null;
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        super.rollback(xid);
        if (this.currentTxn != null) {
            this.currentTxn.rollback();
            if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
                NucleusLogger.TRANSACTION.debug((Object)LOCALISER.msg("AppEngine.Transaction.RolledBack", (Object)this.currentTxn.getInnerTxn().getId()));
            }
        } else {
            throw new XAException(LOCALISER.msg("AppEngine.Transaction.RollbackInvalid"));
        }
        this.currentTxn = null;
    }
}

