/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.math.BigDecimal;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.types.converters.TypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigDecimalStringConverter
implements TypeConverter<BigDecimal, String> {
    @Override
    public BigDecimal toMemberType(String str) {
        if (str == null) {
            return null;
        }
        try {
            return new BigDecimal(str.trim());
        }
        catch (NumberFormatException nfe) {
            throw new NucleusDataStoreException(LOCALISER.msg("016002", (Object)str, (Object)BigDecimal.class.getName()), nfe);
        }
    }

    @Override
    public String toDatastoreType(BigDecimal bd) {
        return bd != null ? bd.toString() : null;
    }
}

